# $Id: Request.pm 39230 2013-04-16 10:20:15Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/SPNEGO/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::SPNEGO::Request;

use MIME::Base64;

use Aselect::Request -self;

const authorization => sub {
	return shift->http('HTTP_AUTHORIZATION');
};

const negotiate => sub {
	my $auth = shift->authorization;
	return undef unless defined $auth;
	unless($auth =~ s/^Negotiate //) {
		warn "wrong Authorization: header found\n";
		return undef;
	}
	return $auth;
};

const decoded => sub {
	my $self = shift;

	my $negotiate = $self->negotiate or return undef;

	my $decoded;
	eval {
		my $binary = decode_base64($negotiate);

		my $asn1 = $self->cfg->asn1;
		$decoded = $asn1->decode($binary)
			or die $asn1->error;
	};
	warn $@ if $@;
	return $decoded;
};

const spnego_supported => sub {
	my $self = shift;
	my $decoded = $self->decoded or return undef;
	my $supported = eval {
		my $mech = $decoded->{negToken}{negTokenInit}{mechTypes}[0];
		return $mech eq '1.2.840.48018.1.2.2' || $mech eq '1.2.840.113554.1.2.2';
	};
	warn $@ if $@;
	warn "primary mechtype not supported\n" unless $supported;
	return $supported;
};

field effective_spnego => sub {
	my $self = shift;
	my $param = $self->bool_param('spnego');
	return bool_string($param) if defined $param;
	return $self->new_spnego;
};

const feasible => sub {
	my $self = shift;
	my $cfg = $self->cfg;

	return undef unless $cfg->kerberos_principal;
	return defined $self->uid if $self->authorization;
	my $setting = $self->effective_spnego;
	return 0 if $setting eq 'false';
	return 1 if $setting eq 'true';

	if(my $re = $cfg->spnego_useragent) {
		my $ua = $self->user_agent;
		return 1 if defined $ua && $ua =~ $re;
	}

	return undef;
};

const spnego_uid => sub {
	my $self = shift;

	my $decoded = $self->decoded or return undef;

	my $uid = eval {
		my $token = $decoded->{negToken}{negTokenInit}{mechToken};

		die "no mechToken found\n"
			unless defined $token;

		$self->cfg->gssapi->authenticate($token);
	};
	warn $@ if $@;
	return $uid;
};

const uid => sub {
	my $self = shift;

	my $uid = $self->spnego_uid;
	return undef unless defined $uid;

	unless($self->cfg->dir->search($uid)->count == 1) {
		warn "uid $uid was authenticated by AD but does not exist in LDAP\n";
		return undef;
	}

	warn "Successfully authenticated as '$uid' using SPNEGO\n";

	return $uid;
};
