/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.ModeCBC;
import cryptix.jce.provider.cipher.ModeCFB;
import cryptix.jce.provider.cipher.ModeECB;
import cryptix.jce.provider.cipher.ModeOFB;
import cryptix.jce.provider.cipher.ModeOpenpgpCFB;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

abstract class Mode {
    protected final BlockCipher cipher;
    protected final int CIPHER_BLOCK_SIZE;
    protected boolean decrypt;
    protected int bufCount;

    static Mode getInstance(String mode, BlockCipher cipher) throws NoSuchAlgorithmException {
        try {
            if (mode.equalsIgnoreCase("CBC")) {
                return new ModeCBC(cipher);
            }
            if (mode.substring(0, 3).equalsIgnoreCase("CFB")) {
                String fbs = mode.substring(3, mode.length());
                if (fbs.length() > 0) {
                    return new ModeCFB(cipher, Integer.parseInt(fbs));
                }
                return new ModeCFB(cipher);
            }
            if (mode.equalsIgnoreCase("ECB")) {
                return new ModeECB(cipher);
            }
            if (mode.equalsIgnoreCase("OFB")) {
                return new ModeOFB(cipher);
            }
            if (mode.equalsIgnoreCase("openpgpCFB")) {
                return new ModeOpenpgpCFB(cipher);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new NoSuchAlgorithmException("Mode (" + mode + ") not available.");
    }

    void init(boolean decrypt, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypt = decrypt;
        this.coreInit(decrypt, key, params, random);
    }

    final byte[] getIV() {
        return this.coreGetIV();
    }

    final AlgorithmParameterSpec getParamSpec() {
        return this.coreGetParamSpec();
    }

    final int getOutputSize(int inputLen) {
        return this.coreGetOutputSize(inputLen);
    }

    final int getBlockSize() {
        return this.CIPHER_BLOCK_SIZE;
    }

    final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        return this.coreUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    final int getBufSize() {
        return this.bufCount;
    }

    protected byte[] generateIV() {
        byte[] b = new byte[this.CIPHER_BLOCK_SIZE];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(b);
        return b;
    }

    abstract int coreGetOutputSize(int var1);

    abstract void coreInit(boolean var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    abstract int coreUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5);

    abstract byte[] coreGetIV();

    abstract AlgorithmParameterSpec coreGetParamSpec();

    abstract boolean needsPadding();

    Mode(BlockCipher cipher) {
        this.cipher = cipher;
        this.CIPHER_BLOCK_SIZE = cipher.coreGetBlockSize();
    }
}

