/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.key;

import cryptix.jce.provider.key.RawKeyGenerator;

public class TripleDESKeyGenerator
extends RawKeyGenerator {
    private static final int STRENGTH = 168;
    private static final int BIT_LEN = 192;

    protected boolean isWeak(byte[] key) {
        return false;
    }

    protected boolean isValidSize(int size) {
        return size == 168;
    }

    protected int strengthToBits(int strength) {
        if (strength != 168) {
            throw new RuntimeException("Invalid strength value (" + strength + ")");
        }
        return 192;
    }

    protected byte[] fixUp(byte[] key) {
        int i = 0;
        while (i < key.length) {
            byte b = key[i];
            key[i] = (byte)(b & 0xFE | (b >> 1 ^ b >> 2 ^ b >> 3 ^ b >> 4 ^ b >> 5 ^ b >> 6 ^ b >> 7) & 1);
            ++i;
        }
        return key;
    }

    public TripleDESKeyGenerator() {
        super("TripleDES", 168);
    }
}

