/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.authspserver.authsp.db.MD5Crypt;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.crypto.CryptoEngine;
import org.aselect.authspserver.log.AuthSPAuthenticationLogger;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.authspserver.session.AuthSPSessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.servlet.ASelectHttpServlet;
import org.aselect.system.utils.Utils;

public class DBAuthSP
extends ASelectHttpServlet {
    private static final long serialVersionUID = 8572776954706719972L;
    private final String RESULT_CODE = "status";
    public static final String MODULE = "DBAuthSP";
    private static final String DEFAULT_FAILUREHANDLING = "aselect";
    public static final String VERSION = "DB AuthSP";
    private static final boolean DEFAULT_ENCRYPTION = false;
    private AuthSPSystemLogger _systemLogger;
    private AuthSPAuthenticationLogger _authenticationLogger;
    private CryptoEngine _cryptoEngine;
    private AuthSPConfigManager _configManager;
    private AuthSPSessionManager _sessionManager;
    private String _sWorkingDir;
    private Object _oAuthSpConfig;
    private String _sErrorHtmlTemplate;
    private String _sAuthenticateHtmlTemplate;
    private Properties _oErrorProperties;
    private String _sFailureHandling;
    private String _sFriendlyName;
    private int _iAllowedRetries;
    private String _sDriver;
    private String _sUrl;
    private String _sUserName;
    private String _sUserPassword;
    private String _sQuery;
    private String _sColumn;
    private boolean _bEncrypedPassword;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = "init()";
        StringBuffer stringBuffer = null;
        try {
            CharSequence charSequence;
            super.init(servletConfig);
            this._systemLogger = AuthSPSystemLogger.getHandle();
            this._authenticationLogger = AuthSPAuthenticationLogger.getHandle();
            this._configManager = AuthSPConfigManager.getHandle();
            this._sessionManager = AuthSPSessionManager.getHandle();
            StringBuffer stringBuffer2 = new StringBuffer("Starting : ");
            stringBuffer2.append(MODULE);
            this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer2.toString());
            ServletContext servletContext = servletConfig.getServletContext();
            this._cryptoEngine = (CryptoEngine)servletContext.getAttribute("CryptoEngine");
            if (this._cryptoEngine == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No CryptoEngine found in servlet context.");
                throw new ASelectException("100");
            }
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded CryptoEngine.");
            this._sFriendlyName = (String)servletContext.getAttribute("friendly_name");
            if (this._sFriendlyName == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'friendly_name' found in servlet context.");
                throw new ASelectException("100");
            }
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded 'friendly_name'.");
            this._sWorkingDir = (String)servletContext.getAttribute("working_dir");
            if (this._sWorkingDir == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No working_dir found in servlet context.");
                throw new ASelectException("100");
            }
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded working_dir");
            String string2 = servletConfig.getInitParameter("config_id");
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'config_id' found as init-parameter in web.xml.");
                throw new ASelectException("100");
            }
            try {
                this._oAuthSpConfig = this._configManager.getSection(null, "authsp", "id=" + string2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                stringBuffer = new StringBuffer("No valid 'authsp' config section found with id='");
                stringBuffer.append(string2);
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("100");
            }
            StringBuffer stringBuffer3 = new StringBuffer(this._sWorkingDir);
            stringBuffer3.append(File.separator);
            stringBuffer3.append("conf");
            stringBuffer3.append(File.separator);
            stringBuffer3.append(string2);
            stringBuffer3.append(File.separator);
            stringBuffer3.append("errors");
            stringBuffer3.append(File.separator);
            stringBuffer3.append("errors.conf");
            File file = new File(stringBuffer3.toString());
            if (!file.exists()) {
                StringBuffer stringBuffer4 = new StringBuffer("The error configuration file does not exist: \"");
                stringBuffer4.append(stringBuffer3.toString()).append("\".");
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer4.toString());
                throw new ASelectException("100");
            }
            this._oErrorProperties = new Properties();
            this._oErrorProperties.load(new FileInputStream(stringBuffer3.toString()));
            stringBuffer2 = new StringBuffer("Successfully loaded ");
            stringBuffer2.append(this._oErrorProperties.size());
            stringBuffer2.append(" error messages from: \"");
            stringBuffer2.append(stringBuffer3.toString()).append("\".");
            this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer2.toString());
            this._sErrorHtmlTemplate = this._configManager.loadHTMLTemplate(this._sWorkingDir, "error.html", string2, this._sFriendlyName, VERSION);
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded 'error.html' template.");
            this._sAuthenticateHtmlTemplate = this._configManager.loadHTMLTemplate(this._sWorkingDir, "authenticate.html", string2, this._sFriendlyName, VERSION);
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully loaded 'authenticate.html' template.");
            try {
                charSequence = this._configManager.getParam(this._oAuthSpConfig, "allowed_retries");
                this._iAllowedRetries = Integer.parseInt((String)charSequence);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'allowed_retries' parameter found in configuration", (Throwable)aSelectConfigException);
                throw new ASelectException("100", (Throwable)aSelectConfigException);
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid 'allowed_retries' parameter found in configuration", (Throwable)numberFormatException);
                throw new ASelectException("100", (Throwable)numberFormatException);
            }
            try {
                this._sFailureHandling = this._configManager.getParam(this._oAuthSpConfig, "failure_handling");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sFailureHandling = DEFAULT_FAILUREHANDLING;
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'failure_handling' parameter found in configuration, using default: aselect", (Throwable)aSelectConfigException);
            }
            if (!this._sFailureHandling.equalsIgnoreCase(DEFAULT_FAILUREHANDLING) && !this._sFailureHandling.equalsIgnoreCase("local")) {
                charSequence = new StringBuffer("Invalid 'failure_handling' parameter found in configuration: '");
                ((StringBuffer)charSequence).append(this._sFailureHandling);
                ((StringBuffer)charSequence).append("', using default: aselect");
                this._sFailureHandling = DEFAULT_FAILUREHANDLING;
                this._systemLogger.log(Level.CONFIG, MODULE, string, ((StringBuffer)charSequence).toString());
            }
            try {
                this._sDriver = this._configManager.getParam(this._oAuthSpConfig, "driver");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'driver' parameter found in configuration", (Throwable)aSelectConfigException);
                throw new ASelectException("100", (Throwable)aSelectConfigException);
            }
            try {
                Class.forName(this._sDriver);
            }
            catch (Exception exception) {
                StringBuffer stringBuffer5 = new StringBuffer("Can't initialize driver: ");
                stringBuffer5.append(this._sDriver);
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer5.toString(), (Throwable)exception);
                throw new ASelectException("100", (Throwable)exception);
            }
            try {
                this._sUrl = this._configManager.getParam(this._oAuthSpConfig, "url");
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'url' found", (Throwable)exception);
                throw new ASelectException("100", (Throwable)exception);
            }
            try {
                this._sUserName = this._configManager.getParam(this._oAuthSpConfig, "user");
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'username' found", (Throwable)exception);
                throw new ASelectException("100", (Throwable)exception);
            }
            try {
                this._sUserPassword = this._configManager.getParam(this._oAuthSpConfig, "password");
            }
            catch (Exception exception) {
                this._sUserPassword = "";
                this._systemLogger.log(Level.WARNING, MODULE, string, "No or empty config item 'password' found, using empty password. Don't use this in a live production environment.", (Throwable)exception);
                throw new ASelectException("100", (Throwable)exception);
            }
            try {
                this._sQuery = this._configManager.getParam(this._oAuthSpConfig, "query");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'query' parameter found in configuration", (Throwable)aSelectConfigException);
                throw new ASelectException("100", (Throwable)aSelectConfigException);
            }
            try {
                this._sColumn = this._configManager.getParam(this._oAuthSpConfig, "column");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'column' parameter found in configuration", (Throwable)aSelectConfigException);
                throw new ASelectException("100", (Throwable)aSelectConfigException);
            }
            try {
                charSequence = this._configManager.getParam(this._oAuthSpConfig, "encrypted");
                this._bEncrypedPassword = Boolean.parseBoolean((String)charSequence);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'encrypted' parameter found in configuration, taking default: false", (Throwable)aSelectConfigException);
                this._bEncrypedPassword = false;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not parse pasword encryption setting, taking default: false", (Throwable)exception);
                throw new ASelectException("100", (Throwable)exception);
            }
            stringBuffer2 = new StringBuffer("Successfully started ");
            stringBuffer2.append(VERSION).append(".");
            this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer2.toString());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Initializing failed", (Throwable)exception);
            throw new ServletException("Initializing failed");
        }
    }

    protected boolean isRestartableServlet() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = "doGet()";
        PrintWriter printWriter = null;
        try {
            this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
            printWriter = httpServletResponse.getWriter();
            String string2 = httpServletRequest.getQueryString();
            Hashtable hashtable = Utils.convertCGIMessage((String)string2);
            String string3 = (String)hashtable.get("request");
            if (string3 != null) {
                this.handleApiRequest(hashtable, httpServletRequest, printWriter, httpServletResponse);
            } else {
                String string4;
                String string5 = httpServletRequest.getRequestURL().toString();
                hashtable.put("my_url", string5);
                String string6 = (String)hashtable.get("rid");
                String string7 = (String)hashtable.get("as_url");
                String string8 = (String)hashtable.get("uid");
                String string9 = (String)hashtable.get("a-select-server");
                String string10 = (String)hashtable.get("signature");
                if (string6 == null || string7 == null || string8 == null || string9 == null || string10 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid request received: one or more mandatory parameters missing.");
                    throw new ASelectException("200");
                }
                String string11 = (String)hashtable.get("country");
                if (string11 == null || string11.trim().length() < 1) {
                    string11 = null;
                }
                if ((string4 = (String)hashtable.get("language")) == null || string4.trim().length() < 1) {
                    string4 = null;
                }
                httpServletResponse.setContentType("text/html");
                string7 = URLDecoder.decode(string7, "UTF-8");
                string8 = URLDecoder.decode(string8, "UTF-8");
                string10 = URLDecoder.decode(string10, "UTF-8");
                StringBuffer stringBuffer = new StringBuffer(string6);
                stringBuffer.append(string7);
                stringBuffer.append(string8);
                stringBuffer.append(string9);
                if (string11 != null) {
                    stringBuffer.append(string11);
                }
                if (string4 != null) {
                    stringBuffer.append(string4);
                }
                if (!this._cryptoEngine.verifySignature(string9, stringBuffer.toString(), string10)) {
                    StringBuffer stringBuffer2 = new StringBuffer("Invalid signature from A-Select Server '");
                    stringBuffer2.append(string9);
                    stringBuffer2.append("' for user: ");
                    stringBuffer2.append(string8);
                    this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer2.toString());
                    throw new ASelectException("200");
                }
                hashtable.put("as_url", string7);
                hashtable.put("uid", string8);
                hashtable.put("retry_counter", "1");
                if (string11 != null) {
                    hashtable.put("country", string11);
                }
                if (string4 != null) {
                    hashtable.put("language", string4);
                }
                this.showAuthenticateForm(printWriter, " ", " ", hashtable);
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Sending error to client", (Throwable)aSelectException);
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, aSelectException.getMessage());
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Error sending response", (Throwable)iOException);
            if (!httpServletResponse.isCommitted()) {
                httpServletResponse.sendError(500);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process request due to internal error", (Throwable)exception);
            this.handleResult(httpServletRequest, httpServletResponse, printWriter, "900");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        block48: {
            String string = "doPost()";
            PrintWriter printWriter = null;
            String string2 = null;
            String string3 = null;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string4;
                httpServletResponse.setContentType("text/html");
                this.setDisableCachingHttpHeaders(httpServletRequest, httpServletResponse);
                printWriter = httpServletResponse.getWriter();
                String string5 = httpServletRequest.getRequestURL().toString();
                String string6 = httpServletRequest.getParameter("rid");
                String string7 = httpServletRequest.getParameter("as_url");
                string2 = httpServletRequest.getParameter("uid");
                String string8 = httpServletRequest.getParameter("a-select-server");
                string3 = httpServletRequest.getParameter("password");
                String string9 = httpServletRequest.getParameter("signature");
                String string10 = httpServletRequest.getParameter("retry_counter");
                if (string6 == null || string7 == null || string2 == null || string3 == null || string8 == null || string10 == null || string9 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid request received: one or more mandatory parameters missing.");
                    throw new ASelectException("200");
                }
                String string11 = httpServletRequest.getParameter("country");
                if (string11 == null || string11.trim().length() < 1) {
                    string11 = null;
                }
                if ((string4 = httpServletRequest.getParameter("language")) == null || string4.trim().length() < 1) {
                    string4 = null;
                }
                if (string3.trim().length() < 1) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("my_url", string5);
                    hashtable.put("as_url", string7);
                    hashtable.put("uid", string2);
                    hashtable.put("rid", string6);
                    hashtable.put("a-select-server", string8);
                    hashtable.put("retry_counter", string10);
                    hashtable.put("signature", string9);
                    if (string11 != null) {
                        hashtable.put("country", string11);
                    }
                    if (string4 != null) {
                        hashtable.put("language", string4);
                    }
                    this.showAuthenticateForm(printWriter, "400", this._configManager.getErrorMessage("400", this._oErrorProperties), hashtable);
                    break block48;
                }
                StringBuffer stringBuffer = new StringBuffer(string6);
                stringBuffer.append(string7);
                stringBuffer.append(string2);
                stringBuffer.append(string8);
                if (string11 != null) {
                    stringBuffer.append(string11);
                }
                if (string4 != null) {
                    stringBuffer.append(string4);
                }
                if (!this._cryptoEngine.verifySignature(string8, stringBuffer.toString(), URLDecoder.decode(string9, "UTF-8"))) {
                    StringBuffer stringBuffer2 = new StringBuffer("Invalid signature from A-Select Server '");
                    stringBuffer2.append(string8);
                    stringBuffer2.append("' for user: ");
                    stringBuffer2.append(string2);
                    this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer2.toString());
                    throw new ASelectException("200");
                }
                connection = this.getConnection();
                try {
                    statement = connection.prepareStatement(this._sQuery);
                    statement.setString(1, string2);
                    resultSet = statement.executeQuery();
                }
                catch (Exception exception) {
                    this._authenticationLogger.log("SEVERE", MODULE, string, "Could not execute query: " + this._sQuery, exception.getMessage());
                    throw new ASelectException("300", (Throwable)exception);
                }
                if (resultSet.next()) {
                    boolean bl = false;
                    try {
                        String string12 = resultSet.getString(this._sColumn);
                        bl = this._bEncrypedPassword ? MD5Crypt.matches(string12, string3) : string12.equals(string3);
                    }
                    catch (Exception exception) {
                        this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not compare with database field: ", (Throwable)exception);
                        throw new ASelectException("100", (Throwable)exception);
                    }
                    if (bl) {
                        this._authenticationLogger.log(new Object[]{MODULE, string2, httpServletRequest.getRemoteAddr(), string8, "granted"});
                        this.handleResult(httpServletRequest, httpServletResponse, printWriter, "000");
                    } else {
                        int n = Integer.parseInt(string10);
                        if (n < this._iAllowedRetries) {
                            Hashtable<String, String> hashtable = new Hashtable<String, String>();
                            hashtable.put("my_url", string5);
                            hashtable.put("as_url", string7);
                            hashtable.put("uid", string2);
                            hashtable.put("rid", string6);
                            hashtable.put("a-select-server", string8);
                            hashtable.put("retry_counter", String.valueOf(n + 1));
                            hashtable.put("signature", string9);
                            if (string11 != null) {
                                hashtable.put("country", string11);
                            }
                            if (string4 != null) {
                                hashtable.put("language", string4);
                            }
                            this.showAuthenticateForm(printWriter, "400", this._configManager.getErrorMessage("400", this._oErrorProperties), hashtable);
                        } else {
                            this._authenticationLogger.log(new Object[]{MODULE, string2, httpServletRequest.getRemoteAddr(), string8, "denied"});
                            this.handleResult(httpServletRequest, httpServletResponse, printWriter, "400");
                        }
                    }
                    break block48;
                }
                this._systemLogger.log(Level.WARNING, MODULE, string, "Error authenticating user, cause: 300");
                this.handleResult(httpServletRequest, httpServletResponse, printWriter, "300");
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Sending error to client", (Throwable)aSelectException);
                this.handleResult(httpServletRequest, httpServletResponse, printWriter, aSelectException.getMessage());
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Error sending response", (Throwable)iOException);
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.sendError(500);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid request received: The retry counter parameter is invalid.");
                this.handleResult(httpServletRequest, httpServletResponse, printWriter, "200");
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process request due to internal error", (Throwable)exception);
                this.handleResult(httpServletRequest, httpServletResponse, printWriter, "900");
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                    if (printWriter != null) {
                        printWriter.close();
                        printWriter = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void showAuthenticateForm(PrintWriter printWriter, String string, String string2, Hashtable hashtable) {
        String string3 = new String(this._sAuthenticateHtmlTemplate);
        String string4 = (String)hashtable.get("my_url");
        String string5 = (String)hashtable.get("rid");
        String string6 = (String)hashtable.get("as_url");
        String string7 = (String)hashtable.get("uid");
        String string8 = (String)hashtable.get("a-select-server");
        String string9 = (String)hashtable.get("signature");
        String string10 = (String)hashtable.get("retry_counter");
        String string11 = (String)hashtable.get("country");
        String string12 = (String)hashtable.get("language");
        string3 = Utils.replaceString((String)string3, (String)"[error]", (String)string);
        string3 = Utils.replaceString((String)string3, (String)"[rid]", (String)string5);
        string3 = Utils.replaceString((String)string3, (String)"[as_url]", (String)string6);
        string3 = Utils.replaceString((String)string3, (String)"[uid]", (String)string7);
        string3 = Utils.replaceString((String)string3, (String)"[db_server]", (String)string4);
        string3 = Utils.replaceString((String)string3, (String)"[a-select-server]", (String)string8);
        string3 = Utils.replaceString((String)string3, (String)"[error_message]", (String)string2);
        string3 = Utils.replaceString((String)string3, (String)"[signature]", (String)string9);
        string3 = Utils.replaceString((String)string3, (String)"[retry_counter]", (String)string10);
        string3 = string11 != null ? Utils.replaceString((String)string3, (String)"[country]", (String)string11) : Utils.replaceString((String)string3, (String)"[country]", (String)"");
        string3 = string12 != null ? Utils.replaceString((String)string3, (String)"[language]", (String)string12) : Utils.replaceString((String)string3, (String)"[language]", (String)"");
        printWriter.println(string3);
    }

    private void handleResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string) {
        String string2 = "handleResult()";
        StringBuffer stringBuffer = null;
        try {
            if (this._sFailureHandling.equalsIgnoreCase(DEFAULT_FAILUREHANDLING) || string.equals("000")) {
                String string3 = httpServletRequest.getParameter("rid");
                String string4 = httpServletRequest.getParameter("as_url");
                String string5 = httpServletRequest.getParameter("a-select-server");
                if (string3 == null || string4 == null || string5 == null) {
                    this.showErrorPage(printWriter, this._sErrorHtmlTemplate, string, this._configManager.getErrorMessage(string, this._oErrorProperties));
                } else {
                    stringBuffer = new StringBuffer(string3);
                    stringBuffer.append(string4).append(string);
                    stringBuffer.append(string5);
                    String string6 = this._cryptoEngine.generateSignature(stringBuffer.toString());
                    string6 = URLEncoder.encode(string6, "UTF-8");
                    stringBuffer = new StringBuffer(string4);
                    stringBuffer.append("&rid=").append(string3);
                    stringBuffer.append("&result_code=").append(string);
                    stringBuffer.append("&a-select-server=").append(string5);
                    stringBuffer.append("&signature=").append(string6);
                    try {
                        httpServletResponse.sendRedirect(stringBuffer.toString());
                    }
                    catch (IOException iOException) {
                        StringBuffer stringBuffer2 = new StringBuffer("Could not send redirect to: \"");
                        stringBuffer2.append(stringBuffer.toString()).append("\"");
                        this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer2.toString(), (Throwable)iOException);
                    }
                }
            } else {
                this.showErrorPage(printWriter, this._sErrorHtmlTemplate, string, this._configManager.getErrorMessage(string, this._oErrorProperties));
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not generate DB AuthSP signature", (Throwable)aSelectException);
            this.showErrorPage(printWriter, this._sErrorHtmlTemplate, "900", this._configManager.getErrorMessage(string, this._oErrorProperties));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not encode DB AuthSP signature", (Throwable)unsupportedEncodingException);
            this.showErrorPage(printWriter, this._sErrorHtmlTemplate, "900", this._configManager.getErrorMessage(string, this._oErrorProperties));
        }
    }

    private void handleApiRequest(Hashtable hashtable, HttpServletRequest httpServletRequest, PrintWriter printWriter, HttpServletResponse httpServletResponse) {
        String string = "handleApiRequest()";
        String string2 = (String)hashtable.get("rid");
        Hashtable hashtable2 = null;
        StringBuffer stringBuffer = new StringBuffer("&rid=");
        stringBuffer.append(string2);
        int n = 0;
        try {
            if (hashtable.get("request").equals("authenticate")) {
                if (this._sessionManager.containsKey((Object)string2)) {
                    hashtable2 = this._sessionManager.getSessionContext(string2);
                    try {
                        n = (Integer)hashtable2.get("allowed_retries");
                    }
                    catch (ClassCastException classCastException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "Unable to cast to Integer.", (Throwable)classCastException);
                        throw new ASelectException("100");
                    }
                } else {
                    hashtable2 = new Hashtable();
                    this._sessionManager.createSession(string2, hashtable2);
                    n = this._iAllowedRetries;
                }
                Integer n2 = new Integer(--n);
                hashtable2.put("allowed_retries", n2);
                this._sessionManager.updateSession(string2, hashtable2);
                if (n < 0) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No login retries left for rid: '" + string2 + "'");
                    throw new ASelectException("800");
                }
            } else {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid API request received.");
                throw new ASelectException("200");
            }
            this.handleAuthenticate(hashtable, httpServletRequest);
            stringBuffer.append("&").append("status");
            stringBuffer.append("=").append("000");
            this._sessionManager.remove((Object)string2);
        }
        catch (ASelectException aSelectException) {
            stringBuffer.append("&").append("status");
            stringBuffer.append("=").append(aSelectException.getMessage());
        }
        httpServletResponse.setContentType("application/x-www-form-urlencoded");
        httpServletResponse.setContentLength(stringBuffer.length());
        printWriter.write(stringBuffer.toString());
    }

    private void handleAuthenticate(Hashtable hashtable, HttpServletRequest httpServletRequest) throws ASelectException {
        ResultSet resultSet;
        String string = "handleAuthenticate()";
        String string2 = null;
        String string3 = (String)hashtable.get("uid");
        String string4 = httpServletRequest.getParameter("password");
        String string5 = (String)hashtable.get("a-select-server");
        if (string3 == null || string4 == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid request received: one or more mandatory parameters missing.");
            throw new ASelectException("200");
        }
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(this._sQuery);
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            string2 = resultSet.next() ? "000" : "100";
        }
        catch (Exception exception) {
            this._authenticationLogger.log("SEVERE", MODULE, string, "Could not execute query: " + this._sQuery, exception.getMessage());
            throw new ASelectException("300", (Throwable)exception);
        }
        if (string2.equals("000")) {
            boolean bl = false;
            try {
                String string6 = resultSet.getString(this._sColumn);
                bl = this._bEncrypedPassword ? MD5Crypt.matches(string6, string4) : string6.equals(string4);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Could parse result: " + resultSet);
                throw new ASelectException("300", (Throwable)exception);
            }
            if (!bl) {
                this._authenticationLogger.log(new Object[]{MODULE, string3, httpServletRequest.getRemoteAddr(), string5, "denied"});
                throw new ASelectException("400");
            }
        } else {
            this._authenticationLogger.log(new Object[]{MODULE, string3, httpServletRequest.getRemoteAddr(), string5, "denied"});
            throw new ASelectException(string2);
        }
        this._authenticationLogger.log(new Object[]{MODULE, string3, httpServletRequest.getRemoteAddr(), string5, "granted"});
    }

    private Connection getConnection() throws ASelectException {
        String string = "getConnection()";
        Connection connection = null;
        try {
            Class.forName(this._sDriver);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Can't initialize driver: ");
            stringBuffer.append(this._sDriver);
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)exception);
            throw new ASelectException("100", (Throwable)exception);
        }
        try {
            connection = DriverManager.getConnection(this._sUrl, this._sUserName, this._sUserPassword);
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer = new StringBuffer("Could not open connection to: ");
            stringBuffer.append(this._sUrl);
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)sQLException);
            throw new ASelectException("100", (Throwable)sQLException);
        }
        return connection;
    }
}

