/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.authspprotocol.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.authspprotocol.IAuthSPDirectLoginProtocolHandler;
import org.aselect.server.authspprotocol.IAuthSPProtocolHandler;
import org.aselect.server.authspprotocol.handler.AuthSPHandlerManager;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.server.tgt.TGTIssuer;
import org.aselect.system.exception.ASelectAuthSPException;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class Ldap
implements IAuthSPProtocolHandler,
IAuthSPDirectLoginProtocolHandler {
    private final String MODULE = "Ldap";
    private ASelectConfigManager _configManager;
    private SessionManager _sessionManager;
    private AuthSPHandlerManager _authSPHandlerManager;
    private ASelectSystemLogger _systemLogger;
    private ASelectAuthenticationLogger _authenticationLogger;
    private String _sAuthsp;
    private String _sAuthspUrl;
    private static final String ERROR_LDAP_OK = "000";
    private static final String ERROR_LDAP_ACCESS_DENIED = "800";
    private static final String ERROR_LDAP_INVALID_CREDENTIALS = "400";
    private static final String ERROR_LDAP_PREFIX = "LDAP";

    public void init(Object object, Object object2) throws ASelectAuthSPException {
        this._configManager = ASelectConfigManager.getHandle();
        this._sessionManager = SessionManager.getHandle();
        this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
        this._systemLogger = ASelectSystemLogger.getHandle();
        try {
            try {
                this._sAuthsp = this._configManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "Ldap", "init()", "Parameter 'id' not found in Ldap AuthSP configuration", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sAuthspUrl = this._configManager.getParam(object2, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "Ldap", "init()", "Parameter 'url' not found in Ldap AuthSP configuration", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            this._systemLogger.log(Level.SEVERE, "Ldap", "init()", "Initialisation failed due to configuration error", (Throwable)aSelectAuthSPException);
            throw aSelectAuthSPException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "Ldap", "init()", "Initialisation failed due to internal error", (Throwable)exception);
            throw new ASelectAuthSPException("0001", (Throwable)exception);
        }
    }

    public void init(String string) throws ASelectAuthSPException {
        this._configManager = ASelectConfigManager.getHandle();
        this._sessionManager = SessionManager.getHandle();
        this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
        this._systemLogger = ASelectSystemLogger.getHandle();
        this._authSPHandlerManager = AuthSPHandlerManager.getHandle();
        try {
            this._sAuthsp = string;
            try {
                this._sAuthspUrl = this._authSPHandlerManager.getUrl(string);
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, "Ldap", "init()", "No parameter 'url' retrieved", (Throwable)aSelectException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectException);
            }
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            this._systemLogger.log(Level.SEVERE, "Ldap", "init()", "Initialisation failed due to configuration error", (Throwable)aSelectAuthSPException);
            throw aSelectAuthSPException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "Ldap", "init()", "Initialisation failed due to internal error", (Throwable)exception);
            throw new ASelectAuthSPException("0001", (Throwable)exception);
        }
    }

    public Hashtable computeAuthenticationRequest(String string) {
        String string2 = "computeAuthenticationRequest()";
        StringBuffer stringBuffer = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("result", "0001");
        try {
            String string3;
            String string4;
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string);
            if (hashtable2 == null) {
                stringBuffer = new StringBuffer("Could not fetch session context for rid='");
                stringBuffer.append(string).append("'.");
                this._systemLogger.log(Level.WARNING, "Ldap", string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            Hashtable hashtable3 = (Hashtable)hashtable2.get("allowed_user_authsps");
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Allowed_user_authsps missing in session context.");
                throw new ASelectAuthSPException("0003");
            }
            String string5 = (String)hashtable3.get(this._sAuthsp);
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Missing ldap user attributes.");
                throw new ASelectAuthSPException("0003");
            }
            stringBuffer = new StringBuffer((String)hashtable2.get("my_url"));
            stringBuffer.append("?authsp=").append(this._sAuthsp);
            String string6 = stringBuffer.toString();
            String string7 = (String)hashtable2.get("country");
            if (string7 == null || string7.trim().length() < 1) {
                string7 = null;
            }
            if ((string4 = (String)hashtable2.get("language")) == null || string4.trim().length() < 1) {
                string4 = null;
            }
            String string8 = this._configManager.getParam(this._configManager.getSection(null, "aselect"), "server_id");
            StringBuffer stringBuffer2 = new StringBuffer(string);
            stringBuffer2.append(string6);
            stringBuffer2.append(string5);
            stringBuffer2.append(string8);
            if (string7 != null) {
                stringBuffer2.append(string7);
            }
            if (string4 != null) {
                stringBuffer2.append(string4);
            }
            if ((string3 = CryptoEngine.getHandle().generateSignature(this._sAuthsp, stringBuffer2.toString())) == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Could not sign Ldap AuthSP request.");
                throw new ASelectAuthSPException("0003");
            }
            string3 = URLEncoder.encode(string3, "UTF-8");
            string5 = URLEncoder.encode(string5, "UTF-8");
            string6 = URLEncoder.encode(string6, "UTF-8");
            StringBuffer stringBuffer3 = new StringBuffer(this._sAuthspUrl);
            stringBuffer3.append("?as_url=").append(string6);
            stringBuffer3.append("&rid=").append(string);
            stringBuffer3.append("&uid=").append(string5);
            stringBuffer3.append("&a-select-server=").append(string8);
            if (string7 != null) {
                stringBuffer3.append("&country=").append(string7);
            }
            if (string4 != null) {
                stringBuffer3.append("&language=").append(string4);
            }
            stringBuffer3.append("&signature=").append(string3);
            hashtable.put("redirect_url", stringBuffer3.toString());
            hashtable.put("result", "0000");
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "Ldap", string2, "Could not compute authentication request due to internal error", (Throwable)exception);
            hashtable.put("result", "0003");
        }
        return hashtable;
    }

    public Hashtable verifyAuthenticationResponse(Hashtable hashtable) {
        String string = "verifyAuthenticationResponse()";
        StringBuffer stringBuffer = null;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("result", "0001");
        try {
            String string2 = (String)hashtable.get("rid");
            String string3 = (String)hashtable.get("my_url");
            String string4 = (String)hashtable.get("result_code");
            String string5 = (String)hashtable.get("a-select-server");
            String string6 = (String)hashtable.get("signature");
            if (string2 == null || string4 == null || string5 == null || string6 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string, "Incorrect AuthSP response: one or more parameters missing.");
                throw new ASelectAuthSPException("000a");
            }
            stringBuffer = new StringBuffer(string3);
            stringBuffer.append("?authsp=");
            stringBuffer.append(this._sAuthsp);
            string3 = stringBuffer.toString();
            string6 = URLDecoder.decode(string6, "UTF-8");
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            stringBuffer2.append(string3);
            stringBuffer2.append(string4);
            stringBuffer2.append(string5);
            boolean bl = CryptoEngine.getHandle().verifySignature(this._sAuthsp, stringBuffer2.toString(), string6);
            if (!bl) {
                this._systemLogger.log(Level.WARNING, "Ldap", string, "invalid signature in response from AuthSP.");
                throw new ASelectAuthSPException("000a");
            }
            Hashtable hashtable3 = this._sessionManager.getSessionContext(string2);
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string, "Incorrect AuthSP response: invalid Session (could be expired)");
                throw new ASelectAuthSPException("0102");
            }
            String string7 = (String)hashtable3.get("user_id");
            String string8 = (String)hashtable3.get("organization");
            if (string4.equalsIgnoreCase(ERROR_LDAP_ACCESS_DENIED)) {
                this._authenticationLogger.log(new Object[]{"Ldap", string7, hashtable.get("client_ip"), string8, (String)hashtable3.get("app_id"), "denied"});
                throw new ASelectAuthSPException("000b");
            }
            if (!string4.equalsIgnoreCase(ERROR_LDAP_OK)) {
                StringBuffer stringBuffer3 = new StringBuffer("AuthSP returned errorcode: ");
                stringBuffer3.append(string4);
                this._systemLogger.log(Level.WARNING, "Ldap", string, stringBuffer3.toString());
                throw new ASelectAuthSPException("0003");
            }
            this._authenticationLogger.log(new Object[]{"Ldap", string7, hashtable.get("client_ip"), string8, (String)hashtable3.get("app_id"), "granted"});
            hashtable2.put("rid", string2);
            hashtable2.put("result", "0000");
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable2.put("result", aSelectAuthSPException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.SEVERE, "Ldap", string, "Could not decode signature", (Throwable)unsupportedEncodingException);
            hashtable2.put("result", "0003");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "Ldap", string, "Could not verify authentication response due to internal error", (Throwable)exception);
            hashtable2.put("result", "0003");
        }
        return hashtable2;
    }

    public void handleDirectLoginRequest(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, HttpServletRequest httpServletRequest) throws ASelectException {
        String string2 = "handleDirectLoginRequest()";
        String string3 = (String)hashtable.get("request");
        if (string3.equalsIgnoreCase("direct_login1")) {
            this.handleDirectLogin1(hashtable, printWriter, string);
        } else if (string3.equalsIgnoreCase("direct_login2")) {
            this.handleDirectLogin2(hashtable, httpServletResponse, printWriter, string, httpServletRequest);
        } else {
            this._systemLogger.log(Level.WARNING, "Ldap", string2, "Invalid request :'" + string3 + "'");
            throw new ASelectException("0030");
        }
    }

    private void handleDirectLogin1(Hashtable hashtable, PrintWriter printWriter, String string) throws ASelectException {
        this.showDirectLoginForm(hashtable, printWriter, string);
    }

    private void handleDirectLogin2(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, HttpServletRequest httpServletRequest) throws ASelectException {
        String string2 = "handleDirectLogin2()";
        try {
            Object object;
            Object object2;
            Serializable serializable;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            string3 = (String)hashtable.get("rid");
            string4 = (String)hashtable.get("user_id");
            string5 = (String)hashtable.get("password");
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Invalid request, missing parmeter 'rid'");
                throw new ASelectCommunicationException("0030");
            }
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Invalid request, missing parmeter 'user_id'");
                throw new ASelectCommunicationException("0030");
            }
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Invalid request, missing parmeter 'password'");
                throw new ASelectCommunicationException("0030");
            }
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string3);
            if (hashtable2 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Invalid session");
                throw new ASelectException("0070");
            }
            String string6 = (String)hashtable2.get("direct_authsp");
            if (string6 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "parameter 'direct_authsp' not found in session");
                throw new ASelectException("0070");
            }
            String string7 = this._authSPHandlerManager.getUrl(string6);
            Integer n = this._authSPHandlerManager.getLevel(string6);
            String string8 = null;
            try {
                serializable = new StringBuffer(string7);
                ((StringBuffer)serializable).append("?request=authenticate");
                ((StringBuffer)serializable).append("&rid=").append(URLEncoder.encode(string3, "UTF-8"));
                ((StringBuffer)serializable).append("&user=").append(URLEncoder.encode(string4, "UTF-8"));
                ((StringBuffer)serializable).append("&password=").append(URLEncoder.encode(string5, "UTF-8"));
                object2 = new URL(((StringBuffer)serializable).toString());
                object = new BufferedReader(new InputStreamReader(((URL)object2).openStream()), 16000);
                string8 = ((BufferedReader)object).readLine();
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Invalid/No response from DirectAuthSP: '" + string6 + "'", (Throwable)iOException);
                throw new ASelectException("4006");
            }
            serializable = Utils.convertCGIMessage((String)string8);
            object2 = (String)((Hashtable)serializable).get("status");
            if (object2 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Invalid response from Direct AuthSP: '" + string6 + "'.");
                throw new ASelectException("4006");
            }
            if (((String)object2).equals(ERROR_LDAP_OK)) {
                object = new TGTIssuer(string);
                String string9 = (String)hashtable.get("aselect_credentials_tgt");
                hashtable2.put("user_id", string4);
                hashtable2.put("authsp_level", n.toString());
                this._sessionManager.updateSession(string3, hashtable2);
                object.issueTGT(string3, string6, null, httpServletResponse, string9, httpServletRequest);
            } else if (((String)object2).equals(ERROR_LDAP_ACCESS_DENIED)) {
                object = this._configManager.getForm("error");
                object = Utils.replaceString((String)object, (String)"[error]", (String)ERROR_LDAP_ACCESS_DENIED);
                String string10 = this._configManager.getErrorMessage("LDAP800");
                object = Utils.replaceString((String)object, (String)"[error_message]", (String)string10);
                object = this._configManager.updateTemplate((String)object, hashtable2);
                printWriter.println((String)object);
            } else {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Error response received: '" + string8 + "' from DirectAuthSP: '" + string6 + "'.");
                object = this._configManager.getErrorMessage("LDAP400");
                hashtable.put("error_message", object);
                this.showDirectLoginForm(hashtable, printWriter, string);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "Ldap", string2, "Exception occured", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    private void showDirectLoginForm(Hashtable hashtable, PrintWriter printWriter, String string) throws ASelectException {
        String string2 = "showDirectLoginForm()";
        try {
            String string3 = this._configManager.getForm("direct_login");
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "template file 'directlogin.html' not found");
                throw new ASelectException("4005");
            }
            String string4 = (String)hashtable.get("rid");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "no parameter 'rid' found in request");
                throw new ASelectException("0030");
            }
            Hashtable hashtable2 = this._sessionManager.getSessionContext(string4);
            if (hashtable2 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "Could not fetch session context for rid='" + string4 + "'");
                throw new ASelectException("0070");
            }
            String string5 = (String)hashtable.get("my_url");
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, "Ldap", string2, "no parameter 'my_url' found in request");
                throw new ASelectException("0030");
            }
            String string6 = (String)hashtable.get("error_message");
            if (string6 == null) {
                string6 = "";
            }
            string3 = Utils.replaceString((String)string3, (String)"[rid]", (String)string4);
            string3 = Utils.replaceString((String)string3, (String)"[aselect_url]", (String)((String)hashtable.get("my_url")));
            string3 = Utils.replaceString((String)string3, (String)"[a-select-server]", (String)string);
            string3 = Utils.replaceString((String)string3, (String)"[request]", (String)"direct_login2");
            string3 = Utils.replaceString((String)string3, (String)"[cross_request]", (String)"cross_login");
            String string7 = (String)hashtable.get("user_id");
            string3 = string7 != null ? Utils.replaceString((String)string3, (String)"[user_name]", (String)string7) : Utils.replaceString((String)string3, (String)"[user_name]", (String)"");
            string3 = Utils.replaceString((String)string3, (String)"[error_message]", (String)string6);
            StringBuffer stringBuffer = new StringBuffer(string5).append("?request=error").append("&result_code=").append("0040").append("&a-select-server=").append(string).append("&rid=").append(string4);
            string3 = Utils.replaceString((String)string3, (String)"[cancel]", (String)stringBuffer.toString());
            string3 = this._configManager.updateTemplate(string3, hashtable2);
            printWriter.println(string3);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, "Ldap", string2, "Could not show direct login page", (Throwable)aSelectException);
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "Ldap", string2, "Could not show direct login page", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }
}

