/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.agent.admin.AdminMonitor;
import org.aselect.agent.authorization.AuthorizationEngine;
import org.aselect.agent.config.ASelectAgentConfigManager;
import org.aselect.agent.handler.RequestHandler;
import org.aselect.agent.handler.TraceRequestHandler;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.agent.sam.ASelectAgentSAMAgent;
import org.aselect.agent.session.SessionManager;
import org.aselect.agent.ticket.TicketManager;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.communication.client.raw.RawCommunicator;
import org.aselect.system.communication.client.soap11.SOAP11Communicator;
import org.aselect.system.communication.client.soap12.SOAP12Communicator;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class ASelectAgent {
    public static final String MODULE = "ASelectAgent";
    public static final String VERSION = "1.5.7";
    private int _servicePort;
    private int _adminPort;
    private boolean _bActive;
    private boolean _bGui;
    private AdminMonitor _adminMonitor;
    private ASelectAgentSystemLogger _oASelectAgentSystemLogger;
    private Object _oAgentSection;
    private String _sWorkingDir = null;
    private ServerSocket _oAdminSocket;
    private ServerSocket _oServiceSocket;
    private IClientCommunicator _oCommunicator;
    private Thread _tServiceHandler;
    private boolean _bAuthorization = false;

    public static void main(String[] stringArray) {
        String string = "main()";
        ASelectAgentSystemLogger aSelectAgentSystemLogger = ASelectAgentSystemLogger.getHandle();
        ASelectAgent aSelectAgent = null;
        StringBuffer stringBuffer = new StringBuffer(MODULE);
        stringBuffer.append(" ").append(VERSION);
        try {
            aSelectAgent = new ASelectAgent();
            aSelectAgent.init();
            aSelectAgent.startServices();
            stringBuffer.append(" succesfully started.");
            System.out.println(stringBuffer.toString());
            aSelectAgentSystemLogger.log(Level.INFO, MODULE, "main()", stringBuffer.toString());
        }
        catch (Exception exception) {
            stringBuffer.append(" failed to start.");
            System.out.println(stringBuffer.toString());
            aSelectAgentSystemLogger.log(Level.SEVERE, MODULE, string, "Failed to start ASelectAgent", exception);
            if (aSelectAgent != null) {
                aSelectAgent.destroy();
            }
            System.exit(1);
        }
    }

    public void init() throws ASelectException {
        String string = "init()";
        try {
            Object object;
            Object object2;
            this._sWorkingDir = System.getProperty("user.dir");
            this._oASelectAgentSystemLogger = ASelectAgentSystemLogger.getHandle();
            ASelectAgentConfigManager aSelectAgentConfigManager = ASelectAgentConfigManager.getHandle();
            aSelectAgentConfigManager.init(this._sWorkingDir);
            this._oAgentSection = aSelectAgentConfigManager.getSection(null, "agent");
            try {
                object2 = aSelectAgentConfigManager.getParam(this._oAgentSection, "truststore");
                System.setProperty("javax.net.ssl.trustStore", (String)object2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectAgentSystemLogger.log(Level.CONFIG, MODULE, string, "Missing or invalid optional config item 'truststore', using default keystore", aSelectConfigException);
            }
            object2 = null;
            try {
                object2 = aSelectAgentConfigManager.getSection(this._oAgentSection, "logging", "id=system");
            }
            catch (Exception exception) {
                this._oASelectAgentSystemLogger.log(Level.SEVERE, MODULE, string, "No valid 'logging' config section with id='system' found.", exception);
                throw new ASelectException("4009", exception);
            }
            this._oASelectAgentSystemLogger.init(object2, this._sWorkingDir);
            this._oASelectAgentSystemLogger.log(Level.INFO, MODULE, string, "Starting A-Select Agent");
            ASelectAgentSAMAgent aSelectAgentSAMAgent = ASelectAgentSAMAgent.getHandle();
            aSelectAgentSAMAgent.init();
            if (!TicketManager.getHandle().init()) {
                throw new ASelectException("4009");
            }
            if (!SessionManager.getHandle().init()) {
                throw new ASelectException("4009");
            }
            Object object3 = null;
            try {
                object3 = aSelectAgentConfigManager.getSection(this._oAgentSection, "authorization");
                this._bAuthorization = true;
            }
            catch (Exception exception) {
                this._oASelectAgentSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'authorization' config section found, authorization is disabled.");
                this._bAuthorization = false;
            }
            if (this._bAuthorization && !((AuthorizationEngine)(object = AuthorizationEngine.getHandle())).init(object3, aSelectAgentConfigManager, this._oASelectAgentSystemLogger)) {
                throw new ASelectException("4009");
            }
            object = null;
            try {
                object = aSelectAgentConfigManager.getParam(this._oAgentSection, "serviceport");
                this._servicePort = Integer.parseInt((String)object);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectAgentSystemLogger.log(Level.WARNING, MODULE, string, "missing serviceport directive in configuration", aSelectConfigException);
                throw aSelectConfigException;
            }
            catch (NumberFormatException numberFormatException) {
                this._oASelectAgentSystemLogger.log(Level.WARNING, MODULE, string, "invalid serviceport directive in configuration: " + (String)object, numberFormatException);
                throw new ASelectConfigException("4011", numberFormatException);
            }
            try {
                object = aSelectAgentConfigManager.getParam(this._oAgentSection, "adminport");
                this._adminPort = Integer.parseInt((String)object);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectAgentSystemLogger.log(Level.WARNING, MODULE, string, "missing 'adminport' directive in configuration", aSelectConfigException);
                throw aSelectConfigException;
            }
            catch (NumberFormatException numberFormatException) {
                this._oASelectAgentSystemLogger.log(Level.WARNING, MODULE, string, "invalid 'adminport' directive in configuration: " + (String)object, numberFormatException);
                throw new ASelectConfigException("4011", numberFormatException);
            }
            this._oCommunicator = this.getCommunicator();
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._oASelectAgentSystemLogger.log(Level.SEVERE, MODULE, string, "Error during initialisation", exception);
            throw new ASelectException("0001", exception);
        }
    }

    public void destroy() {
        String string = "destroy()";
        this._oASelectAgentSystemLogger.log(Level.INFO, MODULE, string, "Stopping all components.");
        try {
            this._bActive = false;
            try {
                if (this._tServiceHandler != null) {
                    this._tServiceHandler.interrupt();
                    if (!this._oServiceSocket.isClosed()) {
                        this._oServiceSocket.close();
                    }
                }
            }
            catch (Exception exception) {
                this._oASelectAgentSystemLogger.log(Level.WARNING, MODULE, string, "Error stopping service handler", exception);
            }
            if (this._bGui) {
                this._adminMonitor.stop();
            }
            ASelectAgentSAMAgent.getHandle().destroy();
            TicketManager.getHandle().stop();
            SessionManager.getHandle().stop();
            this._oASelectAgentSystemLogger.log(Level.INFO, MODULE, "destroy()", "A-Select Agent stopped.");
            this._oASelectAgentSystemLogger.closeHandlers();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyGui() {
        if (this._bGui) {
            this._adminMonitor.dispose();
        }
    }

    public void startServices() throws Exception {
        String string = "startServices()";
        this._oServiceSocket = new ServerSocket(this._servicePort, 50, InetAddress.getByName("127.0.0.1"));
        this._oAdminSocket = new ServerSocket(this._adminPort, 50, InetAddress.getByName("127.0.0.1"));
        this._bGui = false;
        try {
            String string2 = ASelectAgentConfigManager.getHandle().getParam(this._oAgentSection, "admin_gui");
            if (string2.equalsIgnoreCase("true")) {
                this._bGui = true;
                this._adminMonitor = new AdminMonitor();
                this._adminMonitor.start(5);
            }
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oASelectAgentSystemLogger.log(Level.CONFIG, MODULE, string, "No admin.gui parameter found in configuration (default is off).");
        }
        this._bActive = true;
        this._tServiceHandler = this._oASelectAgentSystemLogger.isDebug() ? new Thread(new VerboseServiceHandler()) : new Thread(new APIServiceHandler());
        this._tServiceHandler.start();
        new Thread(new AdminServiceHandler()).start();
    }

    public int getAdminPort() {
        return this._adminPort;
    }

    public boolean isActive() {
        return this._bActive;
    }

    public boolean isInGuiMode() {
        return this._bGui;
    }

    private IClientCommunicator getCommunicator() {
        Object object;
        String string = "getCommunicator()";
        IClientCommunicator iClientCommunicator = null;
        ASelectAgentConfigManager aSelectAgentConfigManager = ASelectAgentConfigManager.getHandle();
        String string2 = null;
        try {
            object = aSelectAgentConfigManager.getSection(this._oAgentSection, "server_communication");
            string2 = aSelectAgentConfigManager.getParam(object, "transferprotocol");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oASelectAgentSystemLogger.log(Level.CONFIG, MODULE, string, "Could not find transferprotocol class in config file, using Raw communication.", aSelectConfigException);
            string2 = "raw";
        }
        if (string2.equalsIgnoreCase("soap11")) {
            iClientCommunicator = new SOAP11Communicator("ASelect", ASelectAgentSystemLogger.getHandle());
        } else if (string2.equalsIgnoreCase("soap12")) {
            iClientCommunicator = new SOAP12Communicator("ASelect", ASelectAgentSystemLogger.getHandle());
        } else if (string2.equalsIgnoreCase("raw")) {
            iClientCommunicator = new RawCommunicator(ASelectAgentSystemLogger.getHandle());
        } else {
            object = new StringBuffer("Invalid transferprotocol configured: ");
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append(" , using Raw communication");
            this._oASelectAgentSystemLogger.log(Level.CONFIG, MODULE, string, ((StringBuffer)object).toString());
            iClientCommunicator = new RawCommunicator(ASelectAgentSystemLogger.getHandle());
        }
        return iClientCommunicator;
    }

    private class AdminServiceHandler
    implements Runnable {
        private AdminServiceHandler() {
        }

        public void run() {
            String string = "AdminServiceHandler.run()";
            StringBuffer stringBuffer = new StringBuffer("AdminServiceHandler started on port: ");
            stringBuffer.append(ASelectAgent.this._adminPort);
            ASelectAgent.this._oASelectAgentSystemLogger.log(Level.INFO, ASelectAgent.MODULE, string, stringBuffer.toString());
            while (ASelectAgent.this._bActive) {
                try {
                    Socket socket = ASelectAgent.this._oAdminSocket.accept();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    PrintStream printStream = new PrintStream(socket.getOutputStream());
                    String string2 = bufferedReader.readLine();
                    Hashtable hashtable = Utils.convertCGIMessage(string2);
                    String string3 = (String)hashtable.get("request");
                    if (string3.equalsIgnoreCase("stop")) {
                        ASelectAgent.this.destroy();
                    }
                    printStream.println("result=0000");
                    socket.close();
                }
                catch (Exception exception) {
                    ASelectAgent.this._oASelectAgentSystemLogger.log(Level.WARNING, ASelectAgent.MODULE, string, "Exception occurred", exception);
                }
            }
            ASelectAgent.this.destroyGui();
            ASelectAgent.this._oASelectAgentSystemLogger.log(Level.INFO, ASelectAgent.MODULE, string, "AdminServiceHandler stopped.");
        }
    }

    private class VerboseServiceHandler
    extends APIServiceHandler
    implements Runnable {
        private VerboseServiceHandler() {
        }

        public void run() {
            Socket socket = null;
            String string = "VerboseServiceHandler.run()";
            StringBuffer stringBuffer = new StringBuffer("VerboseServiceHandler started on port: ");
            stringBuffer.append(ASelectAgent.this._servicePort);
            ASelectAgent.this._oASelectAgentSystemLogger.log(Level.INFO, ASelectAgent.MODULE, string, stringBuffer.toString());
            while (ASelectAgent.this._bActive) {
                try {
                    socket = ASelectAgent.this._oServiceSocket.accept();
                    TraceRequestHandler traceRequestHandler = new TraceRequestHandler(socket, ASelectAgent.this._oCommunicator, ASelectAgent.this._bAuthorization);
                    traceRequestHandler.start();
                }
                catch (Exception exception) {
                    if (!ASelectAgent.this._bActive) continue;
                    StringBuffer stringBuffer2 = new StringBuffer("Exception occurred: \"");
                    stringBuffer2.append(exception.getMessage());
                    stringBuffer2.append("\"");
                    ASelectAgent.this._oASelectAgentSystemLogger.log(Level.WARNING, ASelectAgent.MODULE, string, stringBuffer2.toString(), exception);
                }
            }
            stringBuffer = new StringBuffer("VerboseServiceHandler stopped.");
            ASelectAgent.this._oASelectAgentSystemLogger.log(Level.INFO, ASelectAgent.MODULE, string, stringBuffer.toString());
        }
    }

    private class APIServiceHandler
    implements Runnable {
        private APIServiceHandler() {
        }

        public void run() {
            Socket socket = null;
            String string = "APIServiceHandler.run()";
            StringBuffer stringBuffer = new StringBuffer("APIServiceHandler started on port: ");
            stringBuffer.append(ASelectAgent.this._servicePort);
            ASelectAgent.this._oASelectAgentSystemLogger.log(Level.INFO, ASelectAgent.MODULE, string, stringBuffer.toString());
            while (ASelectAgent.this._bActive) {
                try {
                    socket = ASelectAgent.this._oServiceSocket.accept();
                    RequestHandler requestHandler = new RequestHandler(socket, ASelectAgent.this._oCommunicator, ASelectAgent.this._bAuthorization);
                    requestHandler.start();
                }
                catch (Exception exception) {
                    if (!ASelectAgent.this._bActive) continue;
                    ASelectAgent.this._oASelectAgentSystemLogger.log(Level.WARNING, ASelectAgent.MODULE, string, "Exception occurred", exception);
                }
            }
            ASelectAgent.this._oASelectAgentSystemLogger.log(Level.INFO, ASelectAgent.MODULE, string, "APIServiceHandler stopped.");
        }
    }
}

