/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.admin;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.table.AbstractTableModel;
import org.aselect.agent.config.ASelectAgentConfigManager;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.agent.session.SessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectStorageException;

public class SessionMonitorModel
extends AbstractTableModel
implements Runnable {
    private Thread _runner;
    private String[] _sessionsStrings;
    private String[] _headersStrings = new String[]{"Rid", "On A-Select Server", "Expires at", "For Application", "Type"};
    private int _iCheckInterval;
    private Hashtable _sessionContexts;
    private SessionManager _sessionManager = SessionManager.getHandle();
    private ASelectAgentConfigManager _configManager = ASelectAgentConfigManager.getHandle();
    private boolean _active = false;
    public static final String MODULE = "SessionMonitorModel";

    public SessionMonitorModel(int n) throws ASelectConfigException {
        this._iCheckInterval = n;
        Object object = this._configManager.getSection(null, "storagemanager", "id=session");
        String string = this._configManager.getParam(object, "max");
        Integer n2 = Integer.valueOf(string);
        this._sessionsStrings = new String[n2.intValue()];
        this.getAgentStatus();
        this._active = true;
        this._runner = new Thread(this);
        this._runner.start();
        this.fireTableDataChanged();
    }

    public void stop() {
        this._active = false;
        this._runner.interrupt();
    }

    public long getSessionsCounter() {
        return this._sessionManager.getSessionsCounter();
    }

    public int getRowCount() {
        return this._sessionContexts.size();
    }

    public int getColumnCount() {
        return this._headersStrings.length;
    }

    public Object getValueAt(int n, int n2) {
        String string = this._sessionsStrings[n];
        Hashtable hashtable = (Hashtable)this._sessionContexts.get(string);
        if (n2 == 0) {
            return (String)hashtable.get("rid");
        }
        if (n2 == 1) {
            return (String)hashtable.get("a-select-server");
        }
        if (n2 == 2) {
            long l = 0L;
            try {
                l = this._sessionManager.getSessionTimeout(string);
                return new Date(l).toString();
            }
            catch (ASelectStorageException aSelectStorageException) {
                return "unknown";
            }
        }
        if (n2 == 3) {
            return (String)hashtable.get("app_id");
        }
        if (n2 == 4) {
            return (String)hashtable.get("user_type");
        }
        return null;
    }

    public String getColumnName(int n) {
        return this._headersStrings[n];
    }

    public void run() {
        String string = "run()";
        while (this._active) {
            try {
                Thread.sleep(this._iCheckInterval * 1000);
                this.getAgentStatus();
                this.fireTableDataChanged();
            }
            catch (Exception exception) {}
        }
        ASelectAgentSystemLogger.getHandle().log(Level.INFO, MODULE, string, "SessionMonitorModel stopped.");
    }

    private void getAgentStatus() {
        this._sessionContexts = this._sessionManager.getSessionContexts();
        int n = 0;
        Enumeration enumeration = this._sessionContexts.keys();
        while (enumeration.hasMoreElements()) {
            this._sessionsStrings[n++] = (String)enumeration.nextElement();
        }
    }
}

