/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.authorization;

import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.agent.authorization.evaluation.AuthorizationRuleEvaluator;
import org.aselect.agent.authorization.parsing.AuthorizationRule;
import org.aselect.agent.authorization.parsing.AuthorizationRuleParser;
import org.aselect.agent.authorization.parsing.AuthorizationRuleScanner;
import org.aselect.agent.authorization.parsing.EvaluationTree;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectAuthorizationException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.utils.Utils;

public class AuthorizationEngine {
    private final String MODULE = "AuthorizationEngine";
    private final String[] ARRAY_TYPE = new String[0];
    private static AuthorizationEngine _instance;
    private ConfigManager _configManager;
    private SystemLogger _systemLogger;
    private Hashtable _htEvaluationForrest;
    private AuthorizationRuleEvaluator _oEvaluator;

    public static AuthorizationEngine getHandle() {
        if (_instance == null) {
            _instance = new AuthorizationEngine();
        }
        return _instance;
    }

    public boolean init(Object object, ConfigManager configManager, SystemLogger systemLogger) {
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        boolean bl = false;
        this._systemLogger = systemLogger;
        this._configManager = configManager;
        this._oEvaluator = new AuthorizationRuleEvaluator(this._systemLogger);
        this._htEvaluationForrest = new Hashtable();
        try {
            try {
                object2 = this._configManager.getSection(object, "policies");
            }
            catch (ASelectConfigException aSelectConfigException) {
                // empty catch block
            }
            if (object2 != null) {
                try {
                    object3 = this._configManager.getSection(object2, "policy");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    // empty catch block
                }
            }
            while (object3 != null) {
                String string = null;
                try {
                    string = this._configManager.getParam(object3, "app_id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, "AuthorizationEngine", "init()", "Invalid policy section: missing 'app_id' parameter", aSelectConfigException);
                    throw aSelectConfigException;
                }
                try {
                    object4 = this._configManager.getSection(object3, "rules");
                    object5 = this._configManager.getSection(object4, "rule");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, "AuthorizationEngine", "init()", "Missing or invalid authorization rules section", aSelectConfigException);
                    throw aSelectConfigException;
                }
                Vector<String> vector = new Vector<String>();
                Vector<String> vector2 = new Vector<String>();
                Vector<String> vector3 = new Vector<String>();
                while (object5 != null) {
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    try {
                        string2 = this._configManager.getParam(object5, "id");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, "AuthorizationEngine", "init()", "Invalid authorization rule section: missing 'id' parameter", aSelectConfigException);
                        throw aSelectConfigException;
                    }
                    try {
                        string3 = this._configManager.getParam(object5, "condition");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, "AuthorizationEngine", "init()", "Invalid authorization rule section: missing 'condition' parameter", aSelectConfigException);
                        throw aSelectConfigException;
                    }
                    try {
                        string4 = this._configManager.getParam(object5, "target");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        // empty catch block
                    }
                    vector.add(string2);
                    vector2.add(string3);
                    vector3.add(string4);
                    object5 = this._configManager.getNextSection(object5);
                }
                this.setAuthorizationRules(string, vector.toArray(this.ARRAY_TYPE), vector2.toArray(this.ARRAY_TYPE), vector3.toArray(this.ARRAY_TYPE));
                object3 = this._configManager.getNextSection(object3);
            }
            bl = true;
            this._systemLogger.log(Level.INFO, "AuthorizationEngine", "init()", "Successfully started");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, "AuthorizationEngine", "init()", "Error in authorization configuration", aSelectConfigException);
            bl = false;
        }
        catch (ASelectAuthorizationException aSelectAuthorizationException) {
            this._systemLogger.log(Level.SEVERE, "AuthorizationEngine", "init()", "Error in authorization configuration: invalid authorization rule", aSelectAuthorizationException);
            bl = false;
        }
        return bl;
    }

    public synchronized void setAuthorizationRules(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) throws ASelectAuthorizationException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Hashtable<String, AuthorizationRule> hashtable = new Hashtable<String, AuthorizationRule>();
        try {
            for (int i = 0; i < stringArray2.length; ++i) {
                string3 = stringArray2[i];
                string4 = stringArray3[i];
                string2 = stringArray[i];
                AuthorizationRuleScanner authorizationRuleScanner = new AuthorizationRuleScanner(new StringReader(string3));
                AuthorizationRuleParser authorizationRuleParser = new AuthorizationRuleParser(authorizationRuleScanner, this._systemLogger);
                authorizationRuleParser.parse();
                EvaluationTree evaluationTree = authorizationRuleParser.getEvaluationTree();
                AuthorizationRule authorizationRule = new AuthorizationRule(string3, string4, evaluationTree);
                hashtable.put(string2, authorizationRule);
            }
            this._htEvaluationForrest.put(string, hashtable);
        }
        catch (ASelectAuthorizationException aSelectAuthorizationException) {
            StringBuffer stringBuffer = new StringBuffer("Error parsing authorization rule : \"");
            stringBuffer.append(string3).append("\"");
            this._systemLogger.log(Level.WARNING, "AuthorizationEngine", "addAuthorizationRule()", stringBuffer.toString(), aSelectAuthorizationException);
            throw aSelectAuthorizationException;
        }
    }

    public boolean isUserAuthorized(String string, String string2, Hashtable hashtable) throws ASelectAuthorizationException {
        StringBuffer stringBuffer = null;
        boolean bl = true;
        Hashtable hashtable2 = (Hashtable)this._htEvaluationForrest.get(string);
        if (hashtable2 == null) {
            bl = true;
        } else {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                AuthorizationRule authorizationRule = (AuthorizationRule)hashtable2.get(string3);
                EvaluationTree evaluationTree = authorizationRule.getEvaluationTree();
                String string4 = authorizationRule.getURI();
                if (string4 != null && (string2 == null || !Utils.matchWildcardMask(string2, string4))) continue;
                try {
                    if (this._oEvaluator.evaluate(hashtable, evaluationTree)) continue;
                    bl = false;
                    stringBuffer = new StringBuffer("User attributes not sufficient for rule: '");
                    stringBuffer.append(string3).append("' ('");
                    stringBuffer.append(authorizationRule.getPlainTextRule()).append("').");
                    this._systemLogger.log(Level.WARNING, "AuthorizationEngine", "isUserAuthorized()", stringBuffer.toString());
                }
                catch (ASelectAuthorizationException aSelectAuthorizationException) {
                    stringBuffer = new StringBuffer("Error evaluating authorization rule: '");
                    stringBuffer.append(string3).append("' ('");
                    stringBuffer.append(authorizationRule.getPlainTextRule()).append("')");
                    this._systemLogger.log(Level.WARNING, "AuthorizationEngine", "isUserAuthorized()", stringBuffer.toString(), aSelectAuthorizationException);
                    throw aSelectAuthorizationException;
                }
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this._htEvaluationForrest.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string).append(": ");
            Hashtable hashtable = (Hashtable)this._htEvaluationForrest.get(string);
            stringBuffer.append(hashtable.keySet());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private AuthorizationEngine() {
    }
}

