/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.authorization.parsing.types;

import java.util.StringTokenizer;

public class IPv4Address
implements Comparable {
    public static final String IPV4_REGEX = "([0-9]+\\.){3}([0-9]+)(\\/([0-9]+)(\\.[0-9]+){0,3})?";
    private final byte[][] MASK_CONVERT_TABLE = new byte[][]{{0, 0, 0, 0}, {-128, 0, 0, 0}, {-64, 0, 0, 0}, {-32, 0, 0, 0}, {-16, 0, 0, 0}, {-8, 0, 0, 0}, {-4, 0, 0, 0}, {-2, 0, 0, 0}, {-1, 0, 0, 0}, {-1, -128, 0, 0}, {-1, -64, 0, 0}, {-1, -32, 0, 0}, {-1, -16, 0, 0}, {-1, -8, 0, 0}, {-1, -4, 0, 0}, {-1, -2, 0, 0}, {-1, -1, 0, 0}, {-1, -1, -128, 0}, {-1, -1, -64, 0}, {-1, -1, -32, 0}, {-1, -1, -16, 0}, {-1, -1, -4, 0}, {-1, -1, -2, 0}, {-1, -1, -1, 0}, {-1, -1, -1, -128}, {-1, -1, -1, -64}, {-1, -1, -1, -32}, {-1, -1, -1, -16}, {-1, -1, -1, -8}, {-1, -1, -1, -4}, {-1, -1, -1, -2}, {-1, -1, -1, -1}};
    private final byte[] DEFAULT_MASK = new byte[]{-1, -1, -1, -1};
    private byte[] _baAddress;
    private byte[] _baMask;

    public IPv4Address(String string) throws Exception {
        String string2 = null;
        if (!string.matches(IPV4_REGEX)) {
            throw new Exception("Not a valid IP v4 address");
        }
        int n = string.indexOf(47);
        if (n > 0) {
            string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            this._baMask = this.convertAddress(string3, true);
        } else {
            string2 = string;
            this._baMask = this.DEFAULT_MASK;
        }
        this._baAddress = this.convertAddress(string2, false);
    }

    public int compareTo(Object object) throws ClassCastException {
        int n = 0;
        if (object instanceof IPv4Address) {
            IPv4Address iPv4Address = (IPv4Address)object;
            boolean bl = true;
            for (int i = 0; i < 4 && bl; ++i) {
                bl = (iPv4Address._baAddress[i] & this._baMask[i]) == this._baAddress[i];
            }
            n = bl ? 0 : -1;
        } else {
            throw new ClassCastException("IPv4Address objects are only comparable to other IPv4Address objects");
        }
        return n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this._baAddress.length; ++n) {
            stringBuffer.append(this._baAddress[n]);
            if (n >= this._baAddress.length - 1) continue;
            stringBuffer.append(".");
        }
        if (this._baMask.length > 0) {
            stringBuffer.append("/");
            for (n = 0; n < this._baMask.length; ++n) {
                stringBuffer.append(this._baMask[n]);
                if (n >= this._baMask.length - 1) continue;
                stringBuffer.append(".");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] convertAddress(String string, boolean bl) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        byte[] byArray = null;
        int n = stringTokenizer.countTokens();
        if (n == 1 && bl) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 < 0) throw new NumberFormatException("Invalid IP v4 address");
            if (n2 > 32) throw new NumberFormatException("Invalid IP v4 address");
            return this.MASK_CONVERT_TABLE[n2 - 1];
        }
        byArray = new byte[n];
        int n3 = 0;
        while (n3 < n) {
            String string2 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string2);
            if (n4 < 0) throw new NumberFormatException("Invalid IP v4 address");
            if (n4 > 255) throw new NumberFormatException("Invalid IP v4 address");
            byArray[n3] = (byte)n4;
            ++n3;
        }
        return byArray;
    }
}

