/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class ASelectAgentConfigManager
extends ConfigManager {
    private final String MODULE = "ASelectAgentConfigManager";
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static ASelectAgentConfigManager _oASelectAgentConfigManager;
    private ASelectAgentSystemLogger _systemLogger;
    private String _sWorkingDir = null;
    private boolean _bSignRequests;
    private String _sSignatureAlgorithm = null;
    private Provider _oSignatureProvider;
    private PrivateKey _privateKey = null;
    private Hashtable _htAttributeForwarding = null;

    public static ASelectAgentConfigManager getHandle() {
        if (_oASelectAgentConfigManager == null) {
            _oASelectAgentConfigManager = new ASelectAgentConfigManager();
        }
        return _oASelectAgentConfigManager;
    }

    public void init(String string) throws ASelectConfigException, Exception {
        this._sWorkingDir = string;
        this._systemLogger = ASelectAgentSystemLogger.getHandle();
        StringBuffer stringBuffer = new StringBuffer(this._sWorkingDir).append(File.separator).append("agent.xml");
        super.init(stringBuffer.toString(), ASelectAgentSystemLogger.getHandle());
        this.loadCrypto();
    }

    public String getSignatureAlgorithm() {
        return this._sSignatureAlgorithm;
    }

    public Provider getSignatureProvider() {
        return this._oSignatureProvider;
    }

    public PrivateKey getSigningKey() {
        return this._privateKey;
    }

    public boolean isSigningEnabled() {
        return this._bSignRequests;
    }

    public Hashtable getAttributeForwardingRule(String string) {
        Hashtable hashtable = (Hashtable)this._htAttributeForwarding.get(string);
        if (hashtable == null) {
            hashtable = (Hashtable)this._htAttributeForwarding.get("*");
        }
        return hashtable;
    }

    private ASelectAgentConfigManager() {
    }

    private void loadCrypto() throws ASelectException {
        Serializable serializable;
        String string;
        String string2;
        String string3 = "loadCrypto()";
        Object object = null;
        try {
            object = this.getSection(null, "agent");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, "ASelectAgentConfigManager", string3, "Could not find aselect config section in config file", aSelectConfigException);
            throw aSelectConfigException;
        }
        Object object2 = null;
        try {
            object2 = this.getSection(object, "crypto");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, "ASelectAgentConfigManager", string3, "Could not find crypto config section in config file", aSelectConfigException);
            throw aSelectConfigException;
        }
        Object object3 = null;
        try {
            object3 = this.getSection(object2, "providers");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string3, "Could not find 'providers' config section in configuration. No providers specified", aSelectConfigException);
        }
        Object object4 = null;
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        if (object3 != null) {
            try {
                object4 = this.getSection(object3, "provider");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string3, "Could not find a 'provider' config section in config file. No providers specified", aSelectConfigException);
                throw new ASelectException("4009", aSelectConfigException);
            }
            while (object4 != null) {
                string2 = null;
                try {
                    string2 = this.getParam(object4, "id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string3, "No valid 'id' config item found", aSelectConfigException);
                    throw new ASelectException("4009", aSelectConfigException);
                }
                string = null;
                try {
                    string = this.getParam(object4, "class");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string3, "No valid 'class' config item found", aSelectConfigException);
                    throw new ASelectException("4009", aSelectConfigException);
                }
                serializable = null;
                try {
                    serializable = (Provider)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer("The configured provider is not a valid Provider class: ");
                    stringBuffer.append(string);
                    this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string3, string, exception);
                    throw new ASelectException("4009", exception);
                }
                Security.addProvider((Provider)serializable);
                hashtable.put(string2, serializable);
                object4 = this.getNextSection(object4);
            }
        }
        this.readSignatureConfig(object2, hashtable);
        try {
            string2 = this.getParam(object2, "sign_requests");
            this._bSignRequests = new Boolean(string2);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._bSignRequests = false;
            this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string3, "Missing 'sign_requests' parameter in 'crypto' section of agent configuration, disabling request signing.", aSelectConfigException);
        }
        if (this._bSignRequests) {
            try {
                string = this.getParam(object2, "applications_keystore_password");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string3, "Missing 'applications_keystore_password' parameter in 'crypto' section of agent configuration.", aSelectConfigException);
                throw new ASelectException("4009", aSelectConfigException);
            }
            serializable = new StringBuffer(this._sWorkingDir);
            ((StringBuffer)serializable).append(File.separator);
            ((StringBuffer)serializable).append("applications.keystore");
            this.loadDefaultPrivateKey(((StringBuffer)serializable).toString(), string);
        }
    }

    private void loadDefaultPrivateKey(String string, String string2) throws ASelectException {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), null);
            Enumeration<String> enumeration = keyStore.aliases();
            String string3 = enumeration.nextElement();
            char[] cArray = string2.toCharArray();
            this._privateKey = (PrivateKey)keyStore.getKey(string3, cArray);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not load default private key from keystore: ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.SEVERE, "ASelectAgentConfigManager", "loadDefaultPrivateKey()", stringBuffer.toString(), exception);
            throw new ASelectException("4009", exception);
        }
    }

    private void readSignatureConfig(Object object, Hashtable hashtable) throws ASelectException {
        String string = "readSignatureConfig()";
        String string2 = null;
        Object object2 = null;
        try {
            object2 = this.getSection(object, "signature_algorithm");
        }
        catch (ASelectConfigException aSelectConfigException) {
            object2 = null;
            this._sSignatureAlgorithm = DEFAULT_SIGNATURE_ALGORITHM;
            this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string, "Could not retrieve 'signature_algorithm' config section in crypto config section. Using default algorithm and provider.", aSelectConfigException);
        }
        if (object2 != null) {
            try {
                this._sSignatureAlgorithm = this.getParam(object2, "algorithm");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sSignatureAlgorithm = DEFAULT_SIGNATURE_ALGORITHM;
                StringBuffer stringBuffer = new StringBuffer("Could not retrieve 'signature_algorithm' config parameter in crypto config section. Using default algorithm: ");
                stringBuffer.append(this._sSignatureAlgorithm);
                this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string, stringBuffer.toString());
            }
        }
        if (object2 != null) {
            try {
                string2 = this.getParam(object2, "provider");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string2 = null;
                this._systemLogger.log(Level.CONFIG, "ASelectAgentConfigManager", string, "Could not retrieve 'provider' config section in crypto config section. Using default provider.", aSelectConfigException);
            }
            if (string2 != null) {
                StringBuffer stringBuffer;
                if (!hashtable.containsKey(string2)) {
                    stringBuffer = new StringBuffer("Unknown 'provider': ");
                    stringBuffer.append(string2);
                    this._systemLogger.log(Level.SEVERE, "ASelectAgentConfigManager", string, stringBuffer.toString());
                    throw new ASelectException("4009");
                }
                this._oSignatureProvider = (Provider)hashtable.get(string2);
                stringBuffer = new StringBuffer("Using provider '");
                stringBuffer.append(string2);
                stringBuffer.append("' for signature generation");
                this._systemLogger.log(Level.INFO, "ASelectAgentConfigManager", string, stringBuffer.toString());
            }
        }
    }
}

