/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.session;

import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.agent.config.ASelectAgentConfigManager;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.agent.sam.ASelectAgentSAMAgent;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.storagemanager.StorageManager;

public class SessionManager {
    public static final String MODULE = "SessionManager";
    private static SessionManager _instance;
    private ASelectAgentConfigManager _oConfigManager;
    private StorageManager _oSessionTable;
    private SecureRandom _oRandomGenerator;
    private SystemLogger _systemLogger = ASelectAgentSystemLogger.getHandle();
    private long _lSessionsCounter;

    public static SessionManager getHandle() {
        if (_instance == null) {
            _instance = new SessionManager();
        }
        return _instance;
    }

    public boolean init() {
        String string = "init()";
        try {
            this._oConfigManager = ASelectAgentConfigManager.getHandle();
            this._oSessionTable = new StorageManager();
            Object object = null;
            try {
                object = this._oConfigManager.getSection(null, "storagemanager", "id=session");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "no storagemanager section with id=session declared in config file", aSelectConfigException);
                return false;
            }
            this._oSessionTable.init(object, this._oConfigManager, ASelectAgentSystemLogger.getHandle(), ASelectAgentSAMAgent.getHandle());
            this._oRandomGenerator = SecureRandom.getInstance("SHA1PRNG");
            this._oRandomGenerator.setSeed(this._oRandomGenerator.generateSeed(20));
            this._lSessionsCounter = 0L;
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully started");
            return true;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "exception: " + exception.getMessage(), exception);
            return false;
        }
    }

    public void stop() {
        if (this._oSessionTable != null) {
            this._oSessionTable.destroy();
        }
        this._systemLogger.log(Level.INFO, MODULE, "stop()", "Session manager stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSession(String string, Hashtable hashtable) {
        String string2 = "createSession()";
        try {
            StorageManager storageManager = this._oSessionTable;
            synchronized (storageManager) {
                if (this._oSessionTable.containsKey(string)) {
                    return false;
                }
                try {
                    this._oSessionTable.put(string, hashtable);
                }
                catch (ASelectStorageException aSelectStorageException) {
                    if (aSelectStorageException.getMessage().equals("6010")) {
                        this._systemLogger.log(Level.WARNING, MODULE, string2, "Maximum number of sessions reached", aSelectStorageException);
                        return false;
                    }
                    throw aSelectStorageException;
                }
                ++this._lSessionsCounter;
            }
            return true;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Exception: " + exception.getMessage(), exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killSession(String string) {
        try {
            StorageManager storageManager = this._oSessionTable;
            synchronized (storageManager) {
                this._oSessionTable.remove(string);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, "killSession()", "Exception: " + exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSessionContext(String string, Hashtable hashtable) {
        try {
            StorageManager storageManager = this._oSessionTable;
            synchronized (storageManager) {
                if (this.getSessionContext(string) != null) {
                    this._oSessionTable.update(string, hashtable);
                }
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, "updateSessionContext()", "Exception: " + exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public long getSessionsCounter() {
        return this._lSessionsCounter;
    }

    public Hashtable getSessionContext(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)this._oSessionTable.get(string);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, "getSessionContext()", "Exception: " + exception.getMessage());
        }
        return hashtable;
    }

    public Hashtable getSessionContexts() {
        Hashtable hashtable = null;
        try {
            hashtable = this._oSessionTable.getAll();
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, "getSessionContexts()", "Exception: " + exception.getMessage(), exception);
        }
        return hashtable;
    }

    public long getSessionTimeout(String string) throws ASelectStorageException {
        return this._oSessionTable.getExpirationTime(string);
    }

    private SessionManager() {
    }
}

