/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.ticket;

import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.agent.config.ASelectAgentConfigManager;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.agent.sam.ASelectAgentSAMAgent;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.storagemanager.StorageManager;
import org.aselect.system.utils.Utils;

public class TicketManager {
    public static final String MODULE = "TicketManager";
    private static TicketManager _instance;
    private ASelectAgentConfigManager _oConfigManager;
    private StorageManager _oTicketTable;
    private SecureRandom _oRandomGenerator;
    private SystemLogger _systemLogger = ASelectAgentSystemLogger.getHandle();
    private long _lTicketsCounter;
    private static final int TICKET_LENGTH = 256;

    public static TicketManager getHandle() {
        if (_instance == null) {
            _instance = new TicketManager();
        }
        return _instance;
    }

    public boolean init() {
        String string = "init()";
        try {
            this._oConfigManager = ASelectAgentConfigManager.getHandle();
            Object object = null;
            try {
                object = this._oConfigManager.getSection(null, "storagemanager", "id=ticket");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "no storagemanager section with 'id=ticket' declared in config file", aSelectConfigException);
                return false;
            }
            this._oTicketTable = new StorageManager();
            this._oTicketTable.init(object, this._oConfigManager, ASelectAgentSystemLogger.getHandle(), ASelectAgentSAMAgent.getHandle());
            this._oRandomGenerator = SecureRandom.getInstance("SHA1PRNG");
            this._oRandomGenerator.setSeed(this._oRandomGenerator.generateSeed(20));
            this._lTicketsCounter = 0L;
            this._systemLogger.log(Level.INFO, MODULE, string, "Ticket manager Successfully started.");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Exception occured.", exception);
            return false;
        }
        return true;
    }

    public void stop() {
        String string = "stop()";
        if (this._oTicketTable != null) {
            this._oTicketTable.destroy();
        }
        this._systemLogger.log(Level.INFO, MODULE, string, "Ticket manager stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTicket(Hashtable hashtable) {
        String string = "createTicket()";
        String string2 = null;
        byte[] byArray = new byte[256];
        try {
            StorageManager storageManager = this._oTicketTable;
            synchronized (storageManager) {
                this._oRandomGenerator.nextBytes(byArray);
                string2 = Utils.toHexString(byArray);
                while (this._oTicketTable.containsKey(string2)) {
                    this._oRandomGenerator.nextBytes(byArray);
                    string2 = Utils.toHexString(byArray);
                }
                try {
                    this._oTicketTable.put(string2, hashtable);
                }
                catch (ASelectStorageException aSelectStorageException) {
                    if (aSelectStorageException.getMessage().equals("6010")) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "Maximum number of tickets reached", aSelectStorageException);
                        return null;
                    }
                    throw aSelectStorageException;
                }
                ++this._lTicketsCounter;
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Exception occured.", exception);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTicketContext(String string, Hashtable hashtable) {
        String string2 = "updateTicketContext()";
        try {
            StorageManager storageManager = this._oTicketTable;
            synchronized (storageManager) {
                this._oTicketTable.update(string, hashtable);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Exception occured.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killTicket(String string) {
        String string2 = "killTicket()";
        try {
            StorageManager storageManager = this._oTicketTable;
            synchronized (storageManager) {
                this._oTicketTable.remove(string);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Exception occured.", exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllTickets() {
        String string = "killAllTickets()";
        try {
            StorageManager storageManager = this._oTicketTable;
            synchronized (storageManager) {
                this._oTicketTable.removeAll();
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Exception occured.", exception);
        }
    }

    public Hashtable getTicketContext(String string) {
        String string2 = "getTicketContext()";
        Hashtable hashtable = null;
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            hashtable = (Hashtable)this._oTicketTable.get(string);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Ticket doesn't exist: ");
            stringBuffer.append(string);
            this._systemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString(), exception);
        }
        return hashtable;
    }

    public long getTicketTimeout(String string) throws ASelectStorageException {
        return this._oTicketTable.getExpirationTime(string);
    }

    public long getTicketStartTime(String string) throws ASelectStorageException {
        return this._oTicketTable.getTimestamp(string);
    }

    public Hashtable getTicketContexts() {
        String string = "getTicketContexts()";
        Hashtable hashtable = null;
        try {
            hashtable = this._oTicketTable.getAll();
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Exception occured.", exception);
        }
        return hashtable;
    }

    public long getTicketsCounter() {
        return this._lTicketsCounter;
    }

    private TicketManager() {
    }
}

