/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.attributes.requestors.api;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.attributes.requestors.GenericAttributeRequestor;
import org.aselect.server.attributes.requestors.IAttributeRequestor;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.communication.client.raw.RawCommunicator;
import org.aselect.system.communication.client.soap11.SOAP11Communicator;
import org.aselect.system.communication.client.soap12.SOAP12Communicator;
import org.aselect.system.exception.ASelectAttributesException;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMResource;

public class APIAttributeRequestor
extends GenericAttributeRequestor
implements IAttributeRequestor {
    private final String MODULE = "APIAttributeRequestor";
    private String _sSOAPMethod;
    private String _sAttributesName;
    private IClientCommunicator _communicator;
    private Vector _vTGTParameters;
    private Hashtable _htConfigParameters;
    private Vector _vAllAttributes;
    private Vector _vAllAttributesMappings;
    private String _sAPIResourceGroup;

    public void init(Object object) throws ASelectException {
        block39: {
            String string = "init()";
            try {
                Object object2;
                Object object3;
                Object object4 = null;
                try {
                    object4 = this._configManager.getSection(object, "main");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", string, "Could not retrieve 'main' configuration section", (Throwable)aSelectConfigException);
                    throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                }
                String string2 = null;
                try {
                    string2 = this._configManager.getParam(object4, "transferprotocol");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, "APIAttributeRequestor", string, "Could not find config item 'transferprotocol', using Raw communication", (Throwable)aSelectConfigException);
                    string2 = "raw";
                }
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.equalsIgnoreCase("soap11")) {
                    this.retrieveSOAPMethodFromConfig(object4);
                    this._communicator = new SOAP11Communicator(this._sSOAPMethod, (SystemLogger)this._systemLogger);
                } else if (string2.equalsIgnoreCase("soap12")) {
                    this.retrieveSOAPMethodFromConfig(object4);
                    this._communicator = new SOAP12Communicator(this._sSOAPMethod, (SystemLogger)this._systemLogger);
                } else {
                    this._communicator = new RawCommunicator((SystemLogger)this._systemLogger);
                }
                try {
                    this._sAPIResourceGroup = this._configManager.getParam(object, "resourcegroup");
                    this.getConnection();
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", string, "Could not retrieve 'resourcegroup' parameter in 'main' configuration section", (Throwable)aSelectConfigException);
                    throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                }
                catch (ASelectSAMException aSelectSAMException) {
                    this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", string, "Could not retrieve SAM resource group with name:" + this._sAPIResourceGroup, (Throwable)aSelectSAMException);
                    throw new ASelectAttributesException("0001", (Throwable)aSelectSAMException);
                }
                this._vTGTParameters = new Vector();
                this._htConfigParameters = new Hashtable();
                Object object5 = null;
                try {
                    object5 = this._configManager.getSection(object, "parameters");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, "APIAttributeRequestor", string, "Could not retrieve 'parameters' configuration section; no parameters will be send", (Throwable)aSelectConfigException);
                }
                if (object5 != null) {
                    object3 = null;
                    try {
                        object3 = this._configManager.getSection(object5, "parameter");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.CONFIG, "APIAttributeRequestor", string, "Could not retrieve one 'parameter' in 'parameters' configuration section", (Throwable)aSelectConfigException);
                    }
                    while (object3 != null) {
                        try {
                            String string3;
                            object2 = this._configManager.getParam(object3, "id");
                            boolean bl = false;
                            try {
                                string3 = this._configManager.getParam(object3, "session");
                                if (string3.equals("true")) {
                                    bl = true;
                                }
                            }
                            catch (ASelectConfigException aSelectConfigException) {
                                // empty catch block
                            }
                            if (bl) {
                                this._vTGTParameters.add(object2);
                            } else {
                                string3 = this._configManager.getParam(object3, "value");
                                this._htConfigParameters.put(object2, string3);
                            }
                        }
                        catch (ASelectConfigException aSelectConfigException) {
                            this._systemLogger.log(Level.CONFIG, "APIAttributeRequestor", string, "Could not retrieve mandatory parameter in attribute", (Throwable)aSelectConfigException);
                            throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                        }
                        object3 = this._configManager.getNextSection(object3);
                    }
                }
                try {
                    this._sAttributesName = this._configManager.getParam(object, "attribute_parameter_name");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", string, "Could not retrieve 'attribute_parameter_name' parameter in configuration section", (Throwable)aSelectConfigException);
                    throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                }
                this._vAllAttributes = new Vector();
                this._vAllAttributesMappings = new Vector();
                object3 = null;
                try {
                    object3 = this._configManager.getSection(object, "attribute_mapping");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, "APIAttributeRequestor", string, "Could not retrieve 'attribute_mapping' configuration section, no mapping used", (Throwable)aSelectConfigException);
                }
                if (object3 == null) break block39;
                object2 = null;
                try {
                    object2 = this._configManager.getSection(object3, "attribute");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, "APIAttributeRequestor", string, "Could not retrieve one 'attribute' in 'attribute_mapping' configuration section, no mapping used", (Throwable)aSelectConfigException);
                }
                while (object2 != null) {
                    String string4;
                    try {
                        string4 = this._configManager.getParam(object2, "id");
                        this._vAllAttributes.add(string4);
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.CONFIG, "APIAttributeRequestor", string, "Could not retrieve 'id' parameter in attribute", (Throwable)aSelectConfigException);
                        throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                    }
                    try {
                        string4 = this._configManager.getParam(object2, "map");
                        this._vAllAttributesMappings.add(string4);
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.CONFIG, "APIAttributeRequestor", string, "Could not retrieve 'map' parameter in attribute", (Throwable)aSelectConfigException);
                        throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                    }
                    object2 = this._configManager.getNextSection(object2);
                }
            }
            catch (ASelectException aSelectException) {
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, "APIAttributeRequestor", string, "Error initializing due to internal error", (Throwable)exception);
                throw new ASelectException("0001");
            }
        }
    }

    public Hashtable getAttributes(Hashtable hashtable, Vector vector) throws ASelectAttributesException {
        Hashtable<String, Object> hashtable2;
        block17: {
            String string = null;
            String string2 = null;
            String string3 = null;
            int n = -1;
            String string4 = null;
            hashtable2 = new Hashtable<String, Object>();
            try {
                int n2;
                Object[] objectArray;
                Object object;
                if (vector.isEmpty()) break block17;
                try {
                    string4 = this.getConnection();
                }
                catch (ASelectSAMException aSelectSAMException) {
                    this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", "getAttributes()", "Could not retrieve connection from sam", (Throwable)aSelectSAMException);
                    throw new ASelectAttributesException(aSelectSAMException.getMessage());
                }
                Hashtable<String, Object[]> hashtable3 = new Hashtable<String, Object[]>();
                Hashtable hashtable4 = new Hashtable();
                Enumeration enumeration = this._vTGTParameters.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    objectArray = (Object[])hashtable.get(object);
                    if (objectArray == null) {
                        StringBuffer stringBuffer = new StringBuffer("Error retrieving '");
                        stringBuffer.append((String)object);
                        stringBuffer.append("' parameter from session context.");
                        this._systemLogger.log(Level.SEVERE, "APIAttributeRequestor", "getAttributes()", stringBuffer.toString());
                        throw new ASelectAttributesException("4011");
                    }
                    hashtable3.put((String)object, objectArray);
                }
                hashtable3.putAll(this._htConfigParameters);
                if (!vector.firstElement().equals("*")) {
                    object = new Vector();
                    objectArray = vector.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        n2 = this._vAllAttributes.indexOf(objectArray[i]);
                        if (n2 < 0) {
                            object.add(objectArray[i]);
                            continue;
                        }
                        object.add(this._vAllAttributesMappings.get(n2));
                    }
                    String[] stringArray = object.toArray(new String[0]);
                    hashtable3.put(this._sAttributesName, stringArray);
                }
                if ((object = (String[])(hashtable4 = this._communicator.sendMessage(hashtable3, string4)).get(this._sAttributesName)) == null) {
                    this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", "getAttributes()", "No attributes in response from: " + string4);
                    this._systemLogger.log(Level.FINE, "APIAttributeRequestor", "getAttributes()", "Response: " + hashtable4);
                    throw new ASelectCommunicationException("4007");
                }
                for (int i = 0; i < ((String[])object).length; ++i) {
                    Vector<String> vector2 = null;
                    string = object[i];
                    n = string.indexOf("=");
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                    n2 = this._vAllAttributesMappings.indexOf(string2);
                    if (n2 >= 0) {
                        string2 = (String)this._vAllAttributes.get(n2);
                    }
                    if (hashtable2.containsKey(string2)) {
                        Object v = hashtable2.get(string2);
                        if (v instanceof Vector) {
                            vector2 = (Vector<String>)v;
                        } else {
                            vector2 = new Vector<String>();
                            vector2.add(v.toString());
                        }
                        vector2.add(string3);
                        hashtable2.put(string2, vector2);
                        continue;
                    }
                    hashtable2.put(string2, string3);
                }
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                StringBuffer stringBuffer = new StringBuffer("Error communicating with host: ");
                stringBuffer.append(string4);
                this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", "getAttributes()", stringBuffer.toString(), (Throwable)aSelectCommunicationException);
                throw new ASelectAttributesException(aSelectCommunicationException.getMessage());
            }
            catch (ASelectAttributesException aSelectAttributesException) {
                throw aSelectAttributesException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, "APIAttributeRequestor", "getAttributes()", "Error retrieving attributes due to internal error", (Throwable)exception);
                throw new ASelectAttributesException("0001");
            }
        }
        return hashtable2;
    }

    public void destroy() {
    }

    private String getConnection() throws ASelectSAMException {
        String string = "getConnection()";
        SAMResource sAMResource = null;
        String string2 = null;
        try {
            sAMResource = this._samAgent.getActiveResource(this._sAPIResourceGroup);
        }
        catch (ASelectSAMException aSelectSAMException) {
            StringBuffer stringBuffer = new StringBuffer("No active resource found in udb resourcegroup: ");
            stringBuffer.append(this._sAPIResourceGroup);
            this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", string, stringBuffer.toString(), (Throwable)aSelectSAMException);
            throw aSelectSAMException;
        }
        Object object = sAMResource.getAttributes();
        try {
            string2 = this._configManager.getParam(object, "url");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", string, "No valid config item 'url' found in connector resource configuration", (Throwable)aSelectConfigException);
            throw new ASelectSAMException("4011", (Throwable)aSelectConfigException);
        }
        return string2;
    }

    private void retrieveSOAPMethodFromConfig(Object object) throws ASelectAttributesException {
        String string = "retrieveSOAPMethodFromConfig()";
        try {
            this._sSOAPMethod = this._configManager.getParam(object, "method");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, "APIAttributeRequestor", string, "Could not retrieve 'SOAPMethod' parameter in 'main' configuration section", (Throwable)aSelectConfigException);
            throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
        }
    }
}

