/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.pki;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.authspserver.authsp.pki.crl.handler.ICRLHandler;
import org.aselect.authspserver.authsp.pki.crl.handler.file.FileCRLHandler;
import org.aselect.authspserver.authsp.pki.crl.handler.html.HttpCRLHandler;
import org.aselect.authspserver.authsp.pki.crl.handler.ldap.LDAPCRLHandler;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class PKIManager {
    public static final String MODULE = "PKIManager";
    private AuthSPConfigManager _oConfigManager;
    private Object _oConfig;
    private KeyStore _oCaKeystore;
    private String _sCaKeyStorePassword;
    private String _sCaKeyStoreLocation;
    private Hashtable _htCRLs;
    private Hashtable _htFailedCRLs;
    private AutoCRLUpdater _oAutoCrlUpdater;
    private CRLRecoverer _oCrlRecoverer;
    private PKIAdminServer _oPkiAdminServer;
    private AuthSPSystemLogger _systemLogger;
    private final String _sCrlDistributionPointOid = "2.5.29.31";

    public void init(Object object, AuthSPSystemLogger authSPSystemLogger) throws ASelectException {
        String string = "init()";
        this._oConfig = object;
        this._systemLogger = authSPSystemLogger;
        this._htCRLs = new Hashtable();
        this._htFailedCRLs = new Hashtable();
        this._oConfigManager = AuthSPConfigManager.getHandle();
        try {
            String string2 = this._oConfigManager.getParam(object, "enabled");
            if (!string2.equalsIgnoreCase("false")) {
                this._oConfigManager = AuthSPConfigManager.getHandle();
                Object object2 = this._oConfigManager.getSection(object, "ca_keystore");
                this._sCaKeyStoreLocation = this._oConfigManager.getParam(object2, "location");
                this._sCaKeyStorePassword = this._oConfigManager.getParam(object2, "password");
                this.loadCaKeyStoreFromPFXFile(this._sCaKeyStoreLocation, this._sCaKeyStorePassword);
                this.loadCRLs();
                Integer n = new Integer(this._oConfigManager.getParam(object, "crl_update_timer"));
                this._oAutoCrlUpdater = new AutoCRLUpdater(n.intValue());
                new Thread(this._oAutoCrlUpdater).start();
                n = new Integer(this._oConfigManager.getParam(object, "crl_recover_timer"));
                this._oCrlRecoverer = new CRLRecoverer(n.intValue());
                new Thread(this._oCrlRecoverer).start();
                n = new Integer(this._oConfigManager.getParam(object, "pki_admin_port"));
                this._oPkiAdminServer = new PKIAdminServer(n);
                new Thread(this._oPkiAdminServer).start();
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Failed to initialize PKIManager", (Throwable)aSelectException);
            throw aSelectException;
        }
    }

    public void destroy() {
        this._oAutoCrlUpdater.destroy();
        this._oCrlRecoverer.destroy();
        this._oPkiAdminServer.destroy();
    }

    private void loadCRLs() throws ASelectException {
        this._htCRLs = new Hashtable();
        String string = "loadCRLs()";
        try {
            Enumeration<String> enumeration = this._oCaKeystore.aliases();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                try {
                    this.loadCRLForCA(string2);
                }
                catch (ASelectException aSelectException) {
                    this._htFailedCRLs.put(string2, aSelectException);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Unable to read keystore aliases", (Throwable)keyStoreException);
            throw new ASelectException("010", (Throwable)keyStoreException);
        }
    }

    private void loadCRLForCA(String string) throws ASelectException {
        String string2;
        Object object;
        String string3 = "loadCRLForCA()";
        try {
            Object object2 = this._oConfigManager.getSection(this._oConfig, "ca", "alias=" + string);
            object = this._oConfigManager.getSection(object2, "crl_check");
            string2 = this._oConfigManager.getParam(object, "enabled");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string3, "No config found for CA: " + string, (Throwable)aSelectConfigException);
            throw aSelectConfigException;
        }
        if (!string2.equalsIgnoreCase("false")) {
            X509CRL x509CRL = null;
            X509Certificate x509Certificate = null;
            boolean bl = false;
            try {
                x509Certificate = this.getCA(string);
            }
            catch (KeyStoreException keyStoreException) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "Keystore does not contain CA Certificate: " + string, (Throwable)keyStoreException);
                throw new ASelectException("103");
            }
            Vector vector = this.getCRLUrls(object, string);
            for (int i = 0; i < vector.size() && !bl; ++i) {
                String string4 = (String)vector.get(i);
                X509CRL x509CRL2 = this.getCRL(string4);
                if (x509CRL2 == null || !this.validateCrl(x509CRL2, x509Certificate)) continue;
                x509CRL = x509CRL2;
                bl = true;
                if (bl) continue;
                this._systemLogger.log(Level.INFO, MODULE, string3, "CA '" + string + "' CRL distribution point '" + string4 + "' failed, trying next distributionpoint.");
            }
            if (!bl) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No CRL Found which is signed by CA: " + string);
                throw new ASelectException("108");
            }
            this._htCRLs.put(string, x509CRL);
        }
    }

    public Hashtable getTrustedCACertificate(X509Certificate x509Certificate) throws ASelectException {
        String string = "getTrustedCACertificate()";
        Object var3_3 = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Certificate certificate = null;
        String string2 = null;
        Enumeration<String> enumeration = null;
        boolean bl = false;
        try {
            enumeration = this._oCaKeystore.aliases();
            while (enumeration.hasMoreElements() && !bl) {
                string2 = enumeration.nextElement();
                certificate = this._oCaKeystore.getCertificate(string2);
                bl = this.validateCertificateIsSignedByCA(x509Certificate, certificate);
            }
        }
        catch (KeyStoreException keyStoreException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Keystore does not contain CA Certificate: " + string2, (Throwable)keyStoreException);
            throw new ASelectException("010", (Throwable)keyStoreException);
        }
        if (!bl) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Client Certificate is not signed by a Trusted CA: " + string2);
            throw new ASelectException("002");
        }
        hashtable.put("caCert", certificate);
        hashtable.put("caAlias", string2);
        return hashtable;
    }

    public boolean validateCertificateIsSignedByCA(Certificate certificate, Certificate certificate2) {
        String string = "validateCertificateIsSignedByCA()";
        boolean bl = true;
        PublicKey publicKey = certificate2.getPublicKey();
        try {
            certificate.verify(publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            bl = false;
            this._systemLogger.log(Level.FINE, MODULE, string, invalidKeyException.getMessage(), (Throwable)invalidKeyException);
        }
        catch (CertificateException certificateException) {
            bl = false;
            this._systemLogger.log(Level.FINE, MODULE, string, certificateException.getMessage(), (Throwable)certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            bl = false;
            this._systemLogger.log(Level.FINE, MODULE, string, noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            bl = false;
            this._systemLogger.log(Level.FINE, MODULE, string, noSuchProviderException.getMessage(), (Throwable)noSuchProviderException);
        }
        catch (SignatureException signatureException) {
            bl = false;
            this._systemLogger.log(Level.FINE, MODULE, string, signatureException.getMessage(), (Throwable)signatureException);
        }
        return bl;
    }

    private X509Certificate getCA(String string) throws KeyStoreException {
        return (X509Certificate)this._oCaKeystore.getCertificate(string);
    }

    public void validateCertificateDate(X509Certificate x509Certificate) throws ASelectException {
        String string = "validateCertificateDate()";
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            this._systemLogger.log(Level.FINE, MODULE, string, "Certificate expired", (Throwable)certificateExpiredException);
            throw new ASelectException("004", (Throwable)certificateExpiredException);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            this._systemLogger.log(Level.FINE, MODULE, string, "Certificate not yet valid", (Throwable)certificateNotYetValidException);
            throw new ASelectException("003", (Throwable)certificateNotYetValidException);
        }
    }

    public boolean validateCrl(X509CRL x509CRL, X509Certificate x509Certificate) {
        String string = "getValidCrl()";
        boolean bl = true;
        PublicKey publicKey = x509Certificate.getPublicKey();
        try {
            x509CRL.verify(publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            this._systemLogger.log(Level.INFO, MODULE, string, invalidKeyException.getMessage(), (Throwable)invalidKeyException);
            bl = false;
        }
        catch (CRLException cRLException) {
            this._systemLogger.log(Level.INFO, MODULE, string, cRLException.getMessage(), (Throwable)cRLException);
            bl = false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this._systemLogger.log(Level.INFO, MODULE, string, noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            bl = false;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            this._systemLogger.log(Level.INFO, MODULE, string, noSuchProviderException.getMessage(), (Throwable)noSuchProviderException);
            bl = false;
        }
        catch (SignatureException signatureException) {
            this._systemLogger.log(Level.INFO, MODULE, string, signatureException.getMessage(), (Throwable)signatureException);
            bl = false;
        }
        return bl;
    }

    public boolean isClientCertRevoked(String string, X509Certificate x509Certificate) throws ASelectException {
        String string2 = "isCRLisSignedByCA()";
        X509CRL x509CRL = null;
        if (!this._htCRLs.containsKey(string)) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No Valid CRL Found for CA: " + string);
            throw new ASelectException("108");
        }
        x509CRL = (X509CRL)this._htCRLs.get(string);
        return x509CRL.isRevoked(x509Certificate);
    }

    private Vector getCRLUrls(Object object, String string) throws ASelectException {
        Vector vector;
        block5: {
            String string2 = "getCRLUrls()";
            vector = null;
            try {
                Object object2 = this._oConfigManager.getSection(object, "crl_distributionpoints");
                String string3 = this._oConfigManager.getParam(object2, "location");
                if (string3.equalsIgnoreCase("cacert")) {
                    X509Certificate x509Certificate = (X509Certificate)this._oCaKeystore.getCertificate(string);
                    vector = this.getCrlUrls(x509Certificate);
                    break block5;
                }
                if (string3.equalsIgnoreCase("config")) {
                    vector = new Vector();
                    Object object3 = this._oConfigManager.getSection(object2, "distributionpoint");
                    while (object3 != null) {
                        String string4 = this._oConfigManager.getParam(object3, "location");
                        vector.add(string4);
                        object3 = this._oConfigManager.getNextSection(object3);
                    }
                    break block5;
                }
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Config Error: Invalid location specified for CRL distribution points: " + string);
                throw new ASelectConfigException("101");
            }
            catch (KeyStoreException keyStoreException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No Certificate found in Keystore for: " + string, (Throwable)keyStoreException);
                throw new ASelectException("010", (Throwable)keyStoreException);
            }
        }
        return vector;
    }

    private X509CRL getCRL(String string) {
        String string2 = "getCRL()";
        ICRLHandler iCRLHandler = null;
        X509CRL x509CRL = null;
        if (string.indexOf("http://") >= 0) {
            iCRLHandler = new HttpCRLHandler();
            iCRLHandler.init(this._systemLogger);
        } else if (string.indexOf("ldap://") >= 0) {
            iCRLHandler = new LDAPCRLHandler();
            iCRLHandler.init(this._systemLogger);
        } else if (string.indexOf("file://") >= 0) {
            iCRLHandler = new FileCRLHandler();
            iCRLHandler.init(this._systemLogger);
        } else {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "can't handle supplied CRL uri: " + string);
        }
        try {
            x509CRL = (X509CRL)iCRLHandler.getCRL(string);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "sUri: " + aSelectException.getMessage());
        }
        return x509CRL;
    }

    private void loadCaKeyStoreFromPFXFile(String string, String string2) throws ASelectException {
        String string3 = "loadCaKeyStoreFromPFXFile()";
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInputStream = new FileInputStream(string);
            char[] cArray = string2.toCharArray();
            keyStore.load(fileInputStream, cArray);
            this._oCaKeystore = keyStore;
        }
        catch (KeyStoreException keyStoreException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "Failed to initialize JKS Keystore", (Throwable)keyStoreException);
            throw new ASelectException("010", (Throwable)keyStoreException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, string, (Throwable)fileNotFoundException);
            throw new ASelectException("010", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, string, (Throwable)iOException);
            throw new ASelectException("010", (Throwable)iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, string, (Throwable)noSuchAlgorithmException);
            throw new ASelectException("010", (Throwable)noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, string, (Throwable)certificateException);
            throw new ASelectException("010", (Throwable)certificateException);
        }
    }

    private Vector getCrlUrls(X509Certificate x509Certificate) throws ASelectException {
        String string = "getCRLUrls()";
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.31");
        if (byArray == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No CRL Distribution Points in Ca Certificate");
            throw new ASelectException("107");
        }
        vector = this.getOctetValues(byArray);
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = new String((byte[])vector.get(i));
            vector2.add(string2);
        }
        return vector2;
    }

    private Vector getOctetValues(byte[] byArray) throws ASelectException {
        return this.getOctetValues(this.getDERObject(byArray));
    }

    private DERObject getDERObject(byte[] byArray) throws ASelectException {
        String string = "getDERObject()";
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
            byte[] byArray2 = ((ASN1OctetString)aSN1InputStream.readObject()).getOctets();
            aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray2));
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, iOException.getMessage(), (Throwable)iOException);
            throw new ASelectException("010", (Throwable)iOException);
        }
    }

    private Vector getOctetValues(DERObject dERObject) throws ASelectException {
        String string = "getOctetValues(DERObject derObject)";
        Vector<byte[]> vector = new Vector<byte[]>();
        if (dERObject == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Supplied derObject is null");
            throw new ASelectException("010");
        }
        if (dERObject instanceof DERSequence) {
            Enumeration enumeration = ((DERSequence)dERObject).getObjects();
            while (enumeration.hasMoreElements()) {
                DERObject dERObject2 = (DERObject)enumeration.nextElement();
                vector.addAll(this.getOctetValues(dERObject2));
            }
        } else if (dERObject instanceof DERTaggedObject) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
            if (dERTaggedObject.isExplicit() && !dERTaggedObject.isEmpty()) {
                DERObject dERObject3 = dERTaggedObject.getObject();
                vector = this.getOctetValues(dERObject3);
            } else {
                DEROctetString dEROctetString = (DEROctetString)dERTaggedObject.getObject();
                byte[] byArray = dEROctetString.getOctets();
                vector = new Vector<byte[]>();
                vector.add(byArray);
            }
        }
        return vector;
    }

    class PKIAdminRequestDispatcher
    implements Runnable {
        private Socket _oClientSocket;
        private boolean _bActive = true;
        private BufferedReader _oInputReader;
        private PrintWriter _pwOutput;

        public PKIAdminRequestDispatcher(Socket socket) {
            this._oClientSocket = socket;
        }

        public void run() {
            try {
                this._oInputReader = new BufferedReader(new InputStreamReader(this._oClientSocket.getInputStream()));
                this._pwOutput = new PrintWriter(this._oClientSocket.getOutputStream(), true);
                while (this._bActive) {
                    this.handleRequest("menu");
                    String string = this._oInputReader.readLine();
                    if (string == null) {
                        this._bActive = false;
                        continue;
                    }
                    this.handleRequest(string);
                }
                this._oClientSocket.close();
            }
            catch (IOException iOException) {
                PKIManager.this._systemLogger.log(Level.WARNING, PKIManager.MODULE, "PKIAdminRequestDispatcher", iOException.getMessage(), (Throwable)iOException);
            }
        }

        public void handleRequest(String string) {
            block20: {
                if (string.equalsIgnoreCase("menu")) {
                    this._pwOutput.println("1 ) Reload All (CA Keystore and CRL's)");
                    this._pwOutput.println("2 ) Reload CRL's only ");
                    this._pwOutput.println("3 ) Reload CRL for CA (usage: 3 <CA alias>)");
                    this._pwOutput.println("Type \"quit\" to stop and \"menu\" for this menu.");
                    this._pwOutput.flush();
                } else if (string.equalsIgnoreCase("1")) {
                    try {
                        PKIManager.this.loadCaKeyStoreFromPFXFile(PKIManager.this._sCaKeyStoreLocation, PKIManager.this._sCaKeyStorePassword);
                        PKIManager.this.loadCRLs();
                        this._pwOutput.println("Succesfully Reloaded CA Keystore and CRL's");
                    }
                    catch (ASelectException aSelectException) {
                        this._pwOutput.println("The Following exception occured: " + aSelectException.getMessage());
                        PKIManager.this._systemLogger.log(Level.WARNING, PKIManager.MODULE, "PKIAdminRequestDispatcher->handleRequest()", aSelectException.getMessage(), (Throwable)aSelectException);
                    }
                } else if (string.equalsIgnoreCase("2")) {
                    try {
                        PKIManager.this.loadCRLs();
                    }
                    catch (ASelectException aSelectException) {
                        this._pwOutput.println("The Following exception occured: " + aSelectException.getMessage());
                        PKIManager.this._systemLogger.log(Level.WARNING, PKIManager.MODULE, "PKIAdminRequestDispatcher->handleRequest()", aSelectException.getMessage(), (Throwable)aSelectException);
                    }
                    this._pwOutput.println("Succesfully Reloaded CRL's");
                } else if (string.equalsIgnoreCase("3")) {
                    try {
                        this._pwOutput.println("CA alias: ");
                        this._pwOutput.flush();
                        String string2 = this._oInputReader.readLine();
                        if (PKIManager.this._oCaKeystore.containsAlias(string2)) {
                            try {
                                PKIManager.this.loadCRLForCA(string2);
                                this._pwOutput.println("Succesfully Reloaded CRL for CA with Alias: " + string2);
                            }
                            catch (ASelectException aSelectException) {
                                PKIManager.this._htCRLs.remove(string2);
                                PKIManager.this._htFailedCRLs.put(string2, aSelectException);
                                this._pwOutput.println("Failed to reload CRL for CA with Alias: " + string2);
                                this._pwOutput.println("CRL is added to the auto recovery list");
                            }
                            break block20;
                        }
                        this._pwOutput.println("\nNo Such CA Alias found in CA Keystore.");
                    }
                    catch (IOException iOException) {
                        this._pwOutput.println("The Following exception occured: " + iOException.getMessage());
                        PKIManager.this._systemLogger.log(Level.WARNING, PKIManager.MODULE, "PKIAdminRequestDispatcher->handleRequest()", iOException.getMessage(), (Throwable)iOException);
                    }
                    catch (KeyStoreException keyStoreException) {
                        this._pwOutput.println("The Following exception occured: " + keyStoreException.getMessage());
                        PKIManager.this._systemLogger.log(Level.WARNING, PKIManager.MODULE, "PKIAdminRequestDispatcher->handleRequest()", keyStoreException.getMessage(), (Throwable)keyStoreException);
                    }
                } else if (string.equalsIgnoreCase("quit")) {
                    this._bActive = false;
                    this._pwOutput.println("Connection Closed");
                } else {
                    this._pwOutput.println("Unknown Command");
                }
            }
        }

        public void destroy() {
            this._bActive = false;
            try {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PKIAdminServer
    implements Runnable {
        private ServerSocket oSocket;
        private boolean _bActive;

        public PKIAdminServer(int n) throws ASelectException {
            try {
                this.oSocket = new ServerSocket(n, 0, InetAddress.getByName("127.0.0.1"));
            }
            catch (UnknownHostException unknownHostException) {
                PKIManager.this._systemLogger.log(Level.SEVERE, PKIManager.MODULE, "PKIAdminServer", "127.0.0.1", (Throwable)unknownHostException);
                throw new ASelectException("010", (Throwable)unknownHostException);
            }
            catch (IOException iOException) {
                PKIManager.this._systemLogger.log(Level.SEVERE, PKIManager.MODULE, "PKIAdminServer", "127.0.0.1", (Throwable)iOException);
                throw new ASelectException("010", (Throwable)iOException);
            }
            this._bActive = true;
        }

        public void run() {
            while (this._bActive) {
                try {
                    Socket socket = this.oSocket.accept();
                    PKIAdminRequestDispatcher pKIAdminRequestDispatcher = new PKIAdminRequestDispatcher(socket);
                    Thread thread = new Thread(pKIAdminRequestDispatcher);
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (IOException iOException) {
                    PKIManager.this._systemLogger.log(Level.WARNING, PKIManager.MODULE, "PKIAdminServer", iOException.getMessage(), (Throwable)iOException);
                }
            }
        }

        public void destroy() {
            this._bActive = false;
            try {
                Thread.currentThread().interrupt();
                this.oSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CRLRecoverer
    implements Runnable {
        private boolean _bActive;
        private long _lMilliSeconds;

        public CRLRecoverer(long l) {
            this._lMilliSeconds = l * 1000L;
            this._bActive = true;
        }

        public void run() {
            while (this._bActive) {
                try {
                    Thread.sleep(this._lMilliSeconds);
                    Enumeration enumeration = PKIManager.this._htFailedCRLs.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        try {
                            PKIManager.this.loadCRLForCA((String)k);
                            PKIManager.this._htFailedCRLs.remove(k);
                        }
                        catch (ASelectException aSelectException) {
                            PKIManager.this._systemLogger.log(Level.WARNING, PKIManager.MODULE, "CRLRecoverer", "Reloading CRL for CA with alias: " + k.toString() + " failed");
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    PKIManager.this._systemLogger.log(Level.INFO, PKIManager.MODULE, "CRLRecoverer", "Thread Stopped");
                }
            }
        }

        public void destroy() {
            this._bActive = false;
            try {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class AutoCRLUpdater
    implements Runnable {
        private boolean _bActive;
        private long _lMilliSeconds;

        public AutoCRLUpdater(long l) {
            this._lMilliSeconds = l * 1000L;
            this._bActive = true;
        }

        public void run() {
            while (this._bActive) {
                try {
                    Thread.sleep(this._lMilliSeconds);
                    Enumeration enumeration = PKIManager.this._htCRLs.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        X509CRL x509CRL = (X509CRL)PKIManager.this._htCRLs.get(k);
                        Date date = x509CRL.getNextUpdate();
                        Date date2 = new Date(System.currentTimeMillis());
                        if (!date2.after(date)) continue;
                        try {
                            PKIManager.this.loadCRLForCA((String)k);
                        }
                        catch (ASelectException aSelectException) {
                            PKIManager.this._htFailedCRLs.put(k, aSelectException);
                            PKIManager.this._htCRLs.remove(k);
                            PKIManager.this._systemLogger.log(Level.WARNING, PKIManager.MODULE, "AutoCRLUpdater", "Reloading CRL for CA with alias: " + k.toString() + " failed");
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    PKIManager.this._systemLogger.log(Level.INFO, PKIManager.MODULE, "AutoCRLUpdater", "Thread Stopped");
                }
            }
        }

        public void destroy() {
            this._bActive = false;
            try {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

