/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.pki.cert.handler.ldap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.aselect.authspserver.authsp.pki.cert.handler.ICertificateHandler;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class LDAPCertificateHandler
implements ICertificateHandler {
    public static final String MODULE = "LDAPCertificateHandler";
    private AuthSPSystemLogger _systemLogger;
    private String _sDriver = null;
    private String _sLdapMethod = null;
    private String _sUrl = null;
    private String _sBaseDn = null;
    private String _sCertificateAttrName = null;
    private String _sPrincipalDn = null;
    private String _sPrincipalPassword = null;
    private AuthSPConfigManager _oConfigManager;

    public void init(AuthSPSystemLogger authSPSystemLogger, Object object) throws ASelectException {
        String string = "init()";
        this._oConfigManager = AuthSPConfigManager.getHandle();
        this._systemLogger = authSPSystemLogger;
        try {
            this._sDriver = this._oConfigManager.getParam(object, "driver");
            this._sLdapMethod = this._oConfigManager.getParam(object, "method");
            this._sUrl = this._oConfigManager.getParam(object, "url");
            this._sBaseDn = this._oConfigManager.getParam(object, "base_dn");
            this._sCertificateAttrName = this._oConfigManager.getParam(object, "cert_attribute_name");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize LDAPCertificateHandler", (Throwable)aSelectConfigException);
            throw aSelectConfigException;
        }
        try {
            this._sPrincipalDn = this._oConfigManager.getParam(object, "principal_dn");
            this._sPrincipalPassword = this._oConfigManager.getParam(object, "principal_password");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.FINE, MODULE, string, "No principal name and password found: continue", (Throwable)aSelectConfigException);
        }
    }

    public KeyStore getCertificates(String string) throws ASelectException {
        String string2 = "getCertificates()";
        Context context = null;
        NamingEnumeration<? extends Attribute> namingEnumeration = null;
        NamingEnumeration<?> namingEnumeration2 = null;
        CertificateFactory certificateFactory = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
        }
        catch (KeyStoreException keyStoreException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Internal error occured by creating instance of JKS KeyStore", (Throwable)keyStoreException);
            throw new ASelectException("010");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Internal error occured by creating instance of JKS KeyStore", (Throwable)noSuchAlgorithmException);
            throw new ASelectException("010");
        }
        catch (CertificateException certificateException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Internal error occured by creating instance of JKS KeyStore", (Throwable)certificateException);
            throw new ASelectException("010");
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Internal error occured by creating instance of JKS KeyStore", (Throwable)iOException);
            throw new ASelectException("010");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", this._sDriver);
        hashtable.put("java.naming.provider.url", this._sUrl);
        if (this._sPrincipalDn != null || this._sPrincipalPassword != null) {
            hashtable.put("java.naming.security.principal", this._sPrincipalDn);
            hashtable.put("java.naming.security.credentials", this._sPrincipalPassword);
        }
        if (this._sDriver == null || this._sLdapMethod == null || this._sUrl == null || this._sBaseDn == null || this._sCertificateAttrName == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "The necessary configuration is not complete");
            throw new ASelectConfigException("101");
        }
        if (string == null || string.equalsIgnoreCase("")) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Invalid PkiUserAttribute");
            throw new ASelectConfigException("101");
        }
        if (this._sLdapMethod.equalsIgnoreCase("ssl")) {
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X509");
            String[] stringArray = new String[]{this._sCertificateAttrName};
            String string3 = string + "," + this._sBaseDn;
            context = new InitialDirContext(hashtable);
            Attributes attributes = context.getAttributes(string3, stringArray);
            namingEnumeration = attributes.getAll();
            X509Certificate x509Certificate = null;
            int n = 0;
            while (namingEnumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)namingEnumeration.nextElement();
                namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    Object obj = namingEnumeration2.next();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])obj);
                    x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                    String string4 = "clientcert" + n;
                    keyStore.setCertificateEntry(string4, x509Certificate);
                    ++n;
                }
            }
        }
        catch (NamingException namingException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Failed to get certificates for: " + string, (Throwable)namingException);
            throw new ASelectException("010");
        }
        catch (CertificateException certificateException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Failed to get certificates for: " + string, (Throwable)certificateException);
            throw new ASelectException("010");
        }
        catch (KeyStoreException keyStoreException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Failed to get certificates for: " + string, (Throwable)keyStoreException);
            throw new ASelectException("010");
        }
        finally {
            try {
                if (namingEnumeration != null) {
                    namingEnumeration.close();
                }
                if (namingEnumeration2 != null) {
                    namingEnumeration2.close();
                }
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception exception) {}
        }
        return keyStore;
    }
}

