/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.pki.crl.handler.html;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Level;
import org.aselect.authspserver.authsp.pki.crl.handler.ICRLHandler;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectException;

public class HttpCRLHandler
implements ICRLHandler {
    public static final String MODULE = "HttpCRLHandler";
    private AuthSPSystemLogger _systemLogger;

    public void init(AuthSPSystemLogger authSPSystemLogger) {
        this._systemLogger = authSPSystemLogger;
    }

    public CRL getCRL(String string) throws ASelectException {
        String string2 = "getCRL()";
        CertificateFactory certificateFactory = null;
        InputStream inputStream = null;
        CRL cRL = null;
        Object var6_6 = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException certificateException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Internal error occured by creating instance of CertificateFactory", (Throwable)certificateException);
            throw new ASelectException("010");
        }
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            this._systemLogger.log(Level.INFO, MODULE, string2, string, (Throwable)malformedURLException);
            throw new ASelectException("101");
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.INFO, MODULE, string2, string, (Throwable)iOException);
            throw new ASelectException("108");
        }
        try {
            cRL = certificateFactory.generateCRL(inputStream);
        }
        catch (CRLException cRLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not generate CRL: " + string, (Throwable)cRLException);
            throw new ASelectException("108");
        }
        return cRL;
    }
}

