/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.attributes.requestors.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.aselect.server.attributes.requestors.GenericAttributeRequestor;
import org.aselect.server.udb.UDBConnectorFactory;
import org.aselect.system.exception.ASelectAttributesException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.exception.ASelectUDBException;
import org.aselect.system.sam.agent.SAMResource;

public class JNDIAttributeRequestor
extends GenericAttributeRequestor {
    private static final String MODULE = "JNDIAttributeRequestor";
    private String _sResourceGroup;
    private String _sAuthSPUID;
    private String _sUserDN;
    private String _sBaseDN;
    private Hashtable _htAttributes;
    private Hashtable _htReMapAttributes;
    private boolean _bUseFullUid;

    public void init(Object object) throws ASelectException {
        String string = "init()";
        Object object2 = null;
        this._htAttributes = new Hashtable();
        this._htReMapAttributes = new Hashtable();
        try {
            Object object3;
            try {
                this._sResourceGroup = this._configManager.getParam(object, "resourcegroup");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'resourcegroup' config item found", (Throwable)aSelectConfigException);
                throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
            }
            try {
                object2 = this._configManager.getSection(object, "main");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'main' config section found", (Throwable)aSelectConfigException);
                throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
            }
            try {
                String string2 = this._configManager.getParam(object2, "full_uid");
                this._bUseFullUid = new Boolean(string2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._bUseFullUid = false;
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'full_uid' config item in 'main' section found, using default value 'false'", (Throwable)aSelectConfigException);
            }
            try {
                this._sAuthSPUID = this._configManager.getParam(object2, "authsp_uid");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sAuthSPUID = null;
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No valid 'authsp_uid' config item in 'main' section found, using the A-Select UID to retrieve the attributes", (Throwable)aSelectConfigException);
            }
            try {
                this._sUserDN = this._configManager.getParam(object2, "user_dn");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'user_dn' config item in 'main' section found", (Throwable)aSelectConfigException);
                throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sBaseDN = this._configManager.getParam(object2, "base_dn");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'base_dn' config item in 'main' section found", (Throwable)aSelectConfigException);
                throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
            }
            Object object4 = null;
            try {
                object4 = this._configManager.getSection(object, "attribute_mapping");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No valid 'attribute_mapping' config section found, no mapping used", (Throwable)aSelectConfigException);
            }
            if (object4 != null) {
                object3 = null;
                try {
                    object3 = this._configManager.getSection(object4, "attribute");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "Not one valid 'attribute' config section in 'attributes' section found, no mapping used", (Throwable)aSelectConfigException);
                }
                while (object3 != null) {
                    String string3 = null;
                    String string4 = null;
                    try {
                        string3 = this._configManager.getParam(object3, "id");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'id' config item in 'attribute' section found", (Throwable)aSelectConfigException);
                        throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                    }
                    try {
                        string4 = this._configManager.getParam(object3, "map");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'map' config item in 'attribute' section found", (Throwable)aSelectConfigException);
                        throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                    }
                    this._htAttributes.put(string3, string4);
                    this._htReMapAttributes.put(string4, string3);
                    object3 = this._configManager.getNextSection(object3);
                }
            }
            object3 = this.getConnection();
            try {
                if (object3 != null) {
                    object3.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (ASelectAttributesException aSelectAttributesException) {
            throw aSelectAttributesException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not initialize the Ldap attributes requestor", (Throwable)exception);
            throw new ASelectAttributesException("0001", (Throwable)exception);
        }
    }

    public Hashtable getAttributes(Hashtable hashtable, Vector vector) throws ASelectAttributesException {
        String string = "getAttributes()";
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Context context = null;
        NamingEnumeration<SearchResult> namingEnumeration = null;
        StringBuffer stringBuffer = null;
        Attributes attributes = null;
        Vector<String[]> vector2 = new Vector<String[]>();
        String string2 = null;
        try {
            int n;
            Object object;
            Object object2;
            SearchControls searchControls;
            string2 = (String)hashtable.get("uid");
            if (this._sAuthSPUID != null) {
                searchControls = null;
                try {
                    searchControls = UDBConnectorFactory.getUDBConnector();
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Failed to connect with UDB.", (Throwable)aSelectException);
                    throw aSelectException;
                }
                try {
                    string2 = searchControls.getUserAttributes(string2, this._sAuthSPUID);
                }
                catch (ASelectUDBException aSelectUDBException) {
                    StringBuffer stringBuffer2 = new StringBuffer("Could not retrieve user attributes (for authsp '");
                    stringBuffer2.append(this._sAuthSPUID);
                    stringBuffer2.append("') user: ");
                    stringBuffer2.append(string2);
                    this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer2.toString(), (Throwable)aSelectUDBException);
                    throw new ASelectAttributesException("0001", (Throwable)aSelectUDBException);
                }
                if (string2 == null) {
                    StringBuffer stringBuffer3 = new StringBuffer("The configured authsp_uid '");
                    stringBuffer3.append(this._sAuthSPUID);
                    stringBuffer3.append("' does not map to any configured AuthSP (authsp_id)");
                    this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer3.toString());
                    throw new ASelectAttributesException("0001");
                }
            }
            searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            if (!vector.isEmpty() && !vector.firstElement().equals("*")) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (String[])enumeration.nextElement();
                    object = null;
                    object = this._htAttributes.containsKey(object2) ? (String)this._htAttributes.get(object2) : object2;
                    vector2.add((String[])object);
                }
                object2 = vector2.toArray(new String[0]);
                searchControls.setReturningAttributes((String[])object2);
            }
            if (!this._bUseFullUid && (n = string2.indexOf(64)) > 0) {
                string2 = string2.substring(0, n);
            }
            stringBuffer = new StringBuffer("(");
            stringBuffer.append(this._sUserDN);
            stringBuffer.append("=");
            stringBuffer.append(string2);
            stringBuffer.append(")");
            context = this.getConnection();
            try {
                namingEnumeration = context.search(this._sBaseDN, stringBuffer.toString(), searchControls);
            }
            catch (InvalidSearchFilterException invalidSearchFilterException) {
                object2 = new StringBuffer("Wrong filter: ");
                ((StringBuffer)object2).append(stringBuffer.toString());
                ((StringBuffer)object2).append(" with attributes: ");
                ((StringBuffer)object2).append(vector2.toString());
                this._systemLogger.log(Level.WARNING, MODULE, string, ((StringBuffer)object2).toString(), (Throwable)invalidSearchFilterException);
                throw new ASelectAttributesException("0001", (Throwable)invalidSearchFilterException);
            }
            catch (NamingException namingException) {
                object2 = new StringBuffer("User unknown: ");
                ((StringBuffer)object2).append(string2);
                this._systemLogger.log(Level.FINE, MODULE, string, ((StringBuffer)object2).toString(), (Throwable)namingException);
                throw new ASelectAttributesException("4010", (Throwable)namingException);
            }
            if (!namingEnumeration.hasMore()) {
                StringBuffer stringBuffer4 = new StringBuffer("User '");
                stringBuffer4.append(string2);
                stringBuffer4.append("' not found during LDAP search. The filter was: ");
                stringBuffer4.append(stringBuffer.toString());
                this._systemLogger.log(Level.FINE, MODULE, string, stringBuffer4.toString());
                throw new ASelectAttributesException("4010");
            }
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                attributes = searchResult.getAttributes();
                object2 = attributes.getAll();
                while (object2.hasMore()) {
                    object = (Attribute)object2.next();
                    String string3 = object.getID();
                    try {
                        Object object3;
                        if (object.size() > 1) {
                            object3 = new Vector();
                            for (int i = 0; i < object.size(); ++i) {
                                ((Vector)object3).add(object.get(i));
                            }
                            if (this._htReMapAttributes.containsKey(string3)) {
                                string3 = (String)this._htReMapAttributes.get(string3);
                            }
                            hashtable2.put(string3, object3);
                            continue;
                        }
                        object3 = (String)object.get();
                        if (object3 == null) {
                            object3 = "";
                        }
                        if (this._htReMapAttributes.containsKey(string3)) {
                            string3 = (String)this._htReMapAttributes.get(string3);
                        }
                        hashtable2.put(string3, object3);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (ASelectAttributesException aSelectAttributesException) {
            throw aSelectAttributesException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error", (Throwable)exception);
            throw new ASelectAttributesException("0001", (Throwable)exception);
        }
        finally {
            try {
                if (namingEnumeration != null) {
                    namingEnumeration.close();
                }
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not close directory context", (Throwable)exception);
            }
        }
        return hashtable2;
    }

    public void destroy() {
    }

    private DirContext getConnection() throws ASelectUDBException, ASelectSAMException {
        String string = "getConnection()";
        SAMResource sAMResource = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        InitialDirContext initialDirContext = null;
        Object object = null;
        try {
            sAMResource = this._samAgent.getActiveResource(this._sResourceGroup);
        }
        catch (ASelectSAMException aSelectSAMException) {
            StringBuffer stringBuffer = new StringBuffer("No active resource found in udb resourcegroup: ");
            stringBuffer.append(this._sResourceGroup);
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)aSelectSAMException);
            throw aSelectSAMException;
        }
        object = sAMResource.getAttributes();
        try {
            string2 = this._configManager.getParam(object, "driver");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No valid config item 'driver' found in connector configuration", (Throwable)aSelectConfigException);
            throw new ASelectUDBException("4011", (Throwable)aSelectConfigException);
        }
        try {
            string3 = this._configManager.getParam(object, "security_principal_dn");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No valid config item 'security_principal_dn' found in connector resource configuration", (Throwable)aSelectConfigException);
            throw new ASelectUDBException("4011", (Throwable)aSelectConfigException);
        }
        try {
            string4 = this._configManager.getParam(object, "security_principal_password");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string, "Invalid or empty config item 'security_principal_password' found in connector resource configuration, using empty password.", (Throwable)aSelectConfigException);
        }
        try {
            string5 = this._configManager.getParam(object, "ssl");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No valid config item 'ssl' found in connector resource configuration", (Throwable)aSelectConfigException);
            throw new ASelectUDBException("4011", (Throwable)aSelectConfigException);
        }
        try {
            string6 = this._configManager.getParam(object, "url");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No valid config item 'url' found in connector resource configuration", (Throwable)aSelectConfigException);
            throw new ASelectUDBException("4011", (Throwable)aSelectConfigException);
        }
        try {
            initialDirContext = new InitialDirContext(this.createJNDIEnvironment(string2, string3, string4, string5, string6));
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not create JNDI environment", (Throwable)exception);
            throw new ASelectUDBException("4006", (Throwable)exception);
        }
        return initialDirContext;
    }

    private Hashtable createJNDIEnvironment(String string, String string2, String string3, String string4, String string5) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(11);
        hashtable.put("java.naming.factory.initial", string);
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", string2);
        hashtable.put("java.naming.security.credentials", string3);
        if (string4.equalsIgnoreCase("true")) {
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        hashtable.put("java.naming.provider.url", string5);
        return hashtable;
    }
}

