/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)RetrievalMethodResolver.class.getName());

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        return XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod");
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        try {
            RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
            Attr uri = rm.getURIAttr();
            String type = rm.getType();
            Transforms transforms = rm.getTransforms();
            ResourceResolver resRes = ResourceResolver.getInstance(uri, BaseURI);
            if (resRes != null) {
                XMLSignatureInput resource = resRes.resolve(uri, BaseURI);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Before applying Transforms, resource has " + resource.getBytes().length + "bytes"));
                }
                if (transforms != null) {
                    log.debug((Object)"We have Transforms");
                    resource = transforms.performTransforms(resource);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("After applying Transforms, resource has " + resource.getBytes().length + "bytes"));
                    log.debug((Object)("Resolved to resource " + resource.getSourceURI()));
                }
                byte[] inputBytes = resource.getBytes();
                if (type != null && type.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(inputBytes));
                    if (cert != null) {
                        return cert.getPublicKey();
                    }
                } else {
                    KeyResolver newKeyResolver;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("we have to parse " + inputBytes.length + " bytes"));
                    }
                    Element e = this.getDocFromBytes(inputBytes);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Now we have a {" + e.getNamespaceURI() + "}" + e.getLocalName() + " Element"));
                    }
                    if (e != null && (newKeyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(e), BaseURI, storage)) != null) {
                        return newKeyResolver.resolvePublicKey(RetrievalMethodResolver.getFirstElementChild(e), BaseURI, storage);
                    }
                }
            }
        }
        catch (XMLSecurityException ex) {
            log.debug((Object)"XMLSecurityException", (Throwable)ex);
        }
        catch (CertificateException ex) {
            log.debug((Object)"CertificateException", (Throwable)ex);
        }
        catch (IOException ex) {
            log.debug((Object)"IOException", (Throwable)ex);
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        try {
            ResourceResolver resRes;
            RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
            Attr uri = rm.getURIAttr();
            Transforms transforms = rm.getTransforms();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Asked to resolve URI " + uri));
            }
            if ((resRes = ResourceResolver.getInstance(uri, BaseURI)) != null) {
                XMLSignatureInput resource = resRes.resolve(uri, BaseURI);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Before applying Transforms, resource has " + resource.getBytes().length + "bytes"));
                }
                if (transforms != null) {
                    log.debug((Object)"We have Transforms");
                    resource = transforms.performTransforms(resource);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("After applying Transforms, resource has " + resource.getBytes().length + "bytes"));
                    log.debug((Object)("Resolved to resource " + resource.getSourceURI()));
                }
                byte[] inputBytes = resource.getBytes();
                if (rm.getType() != null && rm.getType().equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(inputBytes));
                    if (cert != null) {
                        return cert;
                    }
                } else {
                    KeyResolver newKeyResolver;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("we have to parse " + inputBytes.length + " bytes"));
                    }
                    Element e = this.getDocFromBytes(inputBytes);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Now we have a {" + e.getNamespaceURI() + "}" + e.getLocalName() + " Element"));
                    }
                    if (e != null && (newKeyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(e), BaseURI, storage)) != null) {
                        return newKeyResolver.resolveX509Certificate(RetrievalMethodResolver.getFirstElementChild(e), BaseURI, storage);
                    }
                }
            }
        }
        catch (XMLSecurityException ex) {
            log.debug((Object)"XMLSecurityException", (Throwable)ex);
        }
        catch (CertificateException ex) {
            log.debug((Object)"CertificateException", (Throwable)ex);
        }
        catch (IOException ex) {
            log.debug((Object)"IOException", (Throwable)ex);
        }
        return null;
    }

    Element getDocFromBytes(byte[] bytes) throws KeyResolverException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (SAXException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (IOException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new KeyResolverException("empty", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    static Element getFirstElementChild(Element e) {
        Node n;
        for (n = e.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        return (Element)n;
    }
}

