/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509CertificateResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)X509CertificateResolver.class.getName());
    Element[] _x509CertKeyElements = null;
    XMLX509Certificate[] _x509certObject = null;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug((Object)"I can't");
            return false;
        }
        this._x509CertKeyElements = XMLUtils.selectDsNodes(element.getFirstChild(), "X509Certificate");
        if (this._x509CertKeyElements != null && this._x509CertKeyElements.length > 0) {
            log.debug((Object)"Yes Sir, I can");
            return true;
        }
        log.debug((Object)"I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            int i;
            boolean weCanResolve;
            if (!(this._x509CertKeyElements != null && this._x509CertKeyElements.length != 0 || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._x509CertKeyElements != null && this._x509CertKeyElements.length != 0)) {
                return null;
            }
            this._x509certObject = new XMLX509Certificate[this._x509CertKeyElements.length];
            for (i = 0; i < this._x509CertKeyElements.length; ++i) {
                this._x509certObject[i] = new XMLX509Certificate(this._x509CertKeyElements[i], BaseURI);
            }
            for (i = 0; i < this._x509certObject.length; ++i) {
                X509Certificate cert = this._x509certObject[i].getX509Certificate();
                if (cert == null) continue;
                return cert;
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            log.debug((Object)"XMLSecurityException", (Throwable)ex);
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

