/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315OmitComments;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInputDebugger;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSignatureInput {
    static Log log = LogFactory.getLog((String)XMLSignatureInput.class.getName());
    InputStream _inputOctetStreamProxy = null;
    Set _inputNodeSet = null;
    Node _subNode = null;
    Node excludeNode = null;
    boolean excludeComments = false;
    byte[] bytes = null;
    private String _MIMEType = null;
    private String _SourceURI = null;
    OutputStream outputStream = null;

    public XMLSignatureInput(byte[] inputOctets) {
        this.bytes = inputOctets;
    }

    public XMLSignatureInput(InputStream inputOctetStream) {
        this._inputOctetStreamProxy = inputOctetStream;
    }

    public XMLSignatureInput(String inputStr) {
        this(inputStr.getBytes());
    }

    public XMLSignatureInput(String inputStr, String encoding) throws UnsupportedEncodingException {
        this(inputStr.getBytes(encoding));
    }

    public XMLSignatureInput(Node rootNode) {
        this._subNode = rootNode;
    }

    public XMLSignatureInput(Set inputNodeSet) {
        this._inputNodeSet = inputNodeSet;
    }

    public XMLSignatureInput(NodeList inputNodeSet) {
        this(XMLUtils.convertNodelistToSet(inputNodeSet));
    }

    public Set getNodeSet() throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        return this.getNodeSet(false);
    }

    public Set getNodeSet(boolean circunvent) throws ParserConfigurationException, IOException, SAXException, CanonicalizationException {
        if (this._inputNodeSet != null) {
            return this._inputNodeSet;
        }
        if (this.isElement()) {
            if (circunvent) {
                XMLUtils.circumventBug2650(XMLUtils.getOwnerDocument(this._subNode));
            }
            this._inputNodeSet = new HashSet();
            XMLUtils.getSet(this._subNode, this._inputNodeSet, this.excludeNode, this.excludeComments);
            return this._inputNodeSet;
        }
        if (this.isOctetStream()) {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setValidating(false);
            dfactory.setNamespaceAware(true);
            DocumentBuilder db = dfactory.newDocumentBuilder();
            try {
                db.setErrorHandler(new IgnoreAllErrorHandler());
                Document doc = db.parse(this.getOctetStream());
                XMLUtils.circumventBug2650(doc);
                HashSet result = new HashSet();
                XMLUtils.getSet(doc.getDocumentElement(), result, null, false);
                return result;
            }
            catch (SAXException ex) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write("<container>".getBytes());
                baos.write(this.getBytes());
                baos.write("</container>".getBytes());
                byte[] result = baos.toByteArray();
                Document document = db.parse(new ByteArrayInputStream(result));
                HashSet set = new HashSet();
                XMLUtils.getSet(document.getDocumentElement().getFirstChild().getFirstChild(), set, null, true);
                return set;
            }
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public InputStream getOctetStream() throws IOException {
        return this.getResetableInputStream();
    }

    public InputStream getOctetStreamReal() {
        return this._inputOctetStreamProxy;
    }

    public byte[] getBytes() throws IOException, CanonicalizationException {
        if (this.bytes != null) {
            return this.bytes;
        }
        InputStream is = this.getResetableInputStream();
        if (is != null) {
            if (this.bytes == null) {
                is.reset();
                this.bytes = JavaUtils.getBytesFromStream(is);
            }
            return this.bytes;
        }
        if (this.isElement()) {
            Canonicalizer20010315OmitComments c14nizer = new Canonicalizer20010315OmitComments();
            this.bytes = c14nizer.engineCanonicalizeSubTree(this._subNode, this.excludeNode);
            return this.bytes;
        }
        if (this.isNodeSet()) {
            Canonicalizer20010315OmitComments c14nizer = new Canonicalizer20010315OmitComments();
            if (this._inputNodeSet.size() == 0) {
                return null;
            }
            this.bytes = c14nizer.engineCanonicalizeXPathNodeSet(this._inputNodeSet);
            return this.bytes;
        }
        throw new RuntimeException("getBytes() called but no input data present");
    }

    public boolean isNodeSet() {
        return this._inputOctetStreamProxy == null && this._inputNodeSet != null;
    }

    public boolean isElement() {
        return this._inputOctetStreamProxy == null && this._subNode != null && this._inputNodeSet == null;
    }

    public boolean isOctetStream() {
        return (this._inputOctetStreamProxy != null || this.bytes != null) && this._inputNodeSet == null && this._subNode == null;
    }

    public boolean isByteArray() {
        return this.bytes != null && this._inputNodeSet == null && this._subNode == null;
    }

    public boolean isInitialized() {
        return this.isOctetStream() || this.isNodeSet();
    }

    public String getMIMEType() {
        return this._MIMEType;
    }

    public void setMIMEType(String MIMEType) {
        this._MIMEType = MIMEType;
    }

    public String getSourceURI() {
        return this._SourceURI;
    }

    public void setSourceURI(String SourceURI) {
        this._SourceURI = SourceURI;
    }

    public String toString() {
        if (this.isNodeSet()) {
            return "XMLSignatureInput/NodeSet/" + this._inputNodeSet.size() + " nodes/" + this.getSourceURI();
        }
        if (this.isElement()) {
            return "XMLSignatureInput/Element/" + this._subNode + " exclude " + this.excludeNode + " comments:" + this.excludeComments + "/" + this.getSourceURI();
        }
        try {
            return "XMLSignatureInput/OctetStream/" + this.getBytes().length + " octets/" + this.getSourceURI();
        }
        catch (Exception ex) {
            return "XMLSignatureInput/OctetStream//" + this.getSourceURI();
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        XMLSignatureInputDebugger db = new XMLSignatureInputDebugger(this);
        return db.getHTMLRepresentation();
    }

    public String getHTMLRepresentation(Set inclusiveNamespaces) throws XMLSignatureException {
        XMLSignatureInputDebugger db = new XMLSignatureInputDebugger(this, inclusiveNamespaces);
        return db.getHTMLRepresentation();
    }

    public Node getExcludeNode() {
        return this.excludeNode;
    }

    public void setExcludeNode(Node excludeNode) {
        this.excludeNode = excludeNode;
    }

    public Node getSubNode() {
        return this._subNode;
    }

    public boolean isExcludeComments() {
        return this.excludeComments;
    }

    public void setExcludeComments(boolean excludeComments) {
        this.excludeComments = excludeComments;
    }

    public void updateOutputStream(OutputStream diOs) throws CanonicalizationException, IOException {
        int num;
        if (diOs == this.outputStream) {
            return;
        }
        if (this.bytes != null) {
            diOs.write(this.bytes);
            return;
        }
        if (this.isElement()) {
            Canonicalizer20010315OmitComments c14nizer = new Canonicalizer20010315OmitComments();
            c14nizer.setWriter(diOs);
            c14nizer.engineCanonicalizeSubTree(this._subNode, this.excludeNode);
            return;
        }
        if (this.isNodeSet()) {
            Canonicalizer20010315OmitComments c14nizer = new Canonicalizer20010315OmitComments();
            c14nizer.setWriter(diOs);
            if (this._inputNodeSet.size() == 0) {
                return;
            }
            c14nizer.engineCanonicalizeXPathNodeSet(this._inputNodeSet);
            return;
        }
        InputStream is = this.getResetableInputStream();
        if (this.bytes != null) {
            diOs.write(this.bytes, 0, this.bytes.length);
            return;
        }
        is.reset();
        byte[] bytesT = new byte[1024];
        while ((num = is.read(bytesT)) > 0) {
            diOs.write(bytesT, 0, num);
        }
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    protected InputStream getResetableInputStream() throws IOException {
        if (this._inputOctetStreamProxy instanceof ByteArrayInputStream) {
            if (!this._inputOctetStreamProxy.markSupported()) {
                throw new RuntimeException("Accepted as Markable but not truly been" + this._inputOctetStreamProxy);
            }
            return this._inputOctetStreamProxy;
        }
        if (this.bytes != null) {
            this._inputOctetStreamProxy = new ByteArrayInputStream(this.bytes);
            return this._inputOctetStreamProxy;
        }
        if (this._inputOctetStreamProxy == null) {
            return null;
        }
        if (this._inputOctetStreamProxy.markSupported()) {
            log.info((Object)"Mark Suported but not used as reset");
        }
        this.bytes = JavaUtils.getBytesFromStream(this._inputOctetStreamProxy);
        this._inputOctetStreamProxy = new ByteArrayInputStream(this.bytes);
        return this._inputOctetStreamProxy;
    }
}

