/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TransformXPath
extends TransformSpi {
    static Log log = LogFactory.getLog((String)TransformXPath.class.getName());
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xpath-19991116";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        try {
            CachedXPathAPIHolder.setDoc(this._transformObject.getElement().getOwnerDocument());
            CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            Element xpathElement = XMLUtils.selectDsNode(this._transformObject.getElement().getFirstChild(), "XPath", 0);
            if (xpathElement == null) {
                Object[] exArgs = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            Node xpathnode = xpathElement.getChildNodes().item(0);
            String str = CachedXPathFuncHereAPI.getStrFromNode(xpathnode);
            boolean circumvent = this.needsCircunvent(str);
            Set inputSet = input.getNodeSet(circumvent);
            if (inputSet.size() == 0) {
                Object[] exArgs = new Object[]{"input node set contains no nodes"};
                throw new TransformationException("empty", exArgs);
            }
            HashSet<Node> resultNodes = new HashSet<Node>();
            PrefixResolverDefault prefixResolver = new PrefixResolverDefault((Node)xpathElement);
            if (xpathnode == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            Iterator iterator = inputSet.iterator();
            while (iterator.hasNext()) {
                Node currentNode = (Node)iterator.next();
                XObject includeInResult = xPathFuncHereAPI.eval(currentNode, xpathnode, str, (PrefixResolver)prefixResolver);
                if (!includeInResult.bool()) continue;
                resultNodes.add(currentNode);
            }
            XMLSignatureInput result = new XMLSignatureInput(resultNodes);
            result.setSourceURI(input.getSourceURI());
            return result;
        }
        catch (TransformerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (DOMException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private boolean needsCircunvent(String str) {
        return true;
    }
}

