/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformXPath2Filter
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2002/06/xmldsig-filter2";
    List _filterTypes = new ArrayList();
    List _filterNodes = new ArrayList();
    Set _F = null;
    List _ancestors = null;
    private static final String FUnion = "union";
    private static final String FSubtract = "subtract";
    private static final String FIntersect = "intersect";
    Set _inputSet = null;

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        CachedXPathAPIHolder.setDoc(this._transformObject.getElement().getOwnerDocument());
        try {
            this._inputSet = input.getNodeSet(true);
            if (this._inputSet.size() == 0) {
                return input;
            }
            CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            Document inputDoc = XMLUtils.getOwnerDocument(this._inputSet);
            Element[] xpathElements = XMLUtils.selectNodes(this._transformObject.getElement().getFirstChild(), implementedTransformURI, "XPath");
            int noOfSteps = xpathElements.length;
            if (noOfSteps == 0) {
                Object[] exArgs = new Object[]{implementedTransformURI, "XPath"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            this._filterTypes.add(FUnion);
            HelperNodeList root = new HelperNodeList();
            root.appendChild(inputDoc);
            this._filterNodes.add(root);
            for (int i = 0; i < noOfSteps; ++i) {
                Element xpathElement = XMLUtils.selectNode(this._transformObject.getElement().getFirstChild(), implementedTransformURI, "XPath", i);
                XPath2FilterContainer xpathContainer = XPath2FilterContainer.newInstance(xpathElement, input.getSourceURI());
                if (xpathContainer.isIntersect()) {
                    this._filterTypes.add(FIntersect);
                } else if (xpathContainer.isSubtract()) {
                    this._filterTypes.add(FSubtract);
                } else if (xpathContainer.isUnion()) {
                    this._filterTypes.add(FUnion);
                } else {
                    this._filterTypes.add(null);
                }
                NodeList subtreeRoots = xPathFuncHereAPI.selectNodeList(inputDoc, xpathContainer.getXPathFilterTextNode(), CachedXPathFuncHereAPI.getStrFromNode(xpathContainer.getXPathFilterTextNode()), xpathContainer.getElement());
                this._filterNodes.add(subtreeRoots);
            }
            this._F = new HashSet();
            this._ancestors = new ArrayList();
            this.traversal(inputDoc);
            HashSet resultSet = new HashSet();
            Iterator it = this._inputSet.iterator();
            while (it.hasNext()) {
                Object n = it.next();
                if (!this._F.contains(n)) continue;
                resultSet.add(n);
            }
            XMLSignatureInput result = new XMLSignatureInput(resultSet);
            result.setSourceURI(input.getSourceURI());
            return result;
        }
        catch (TransformerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (DOMException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private void traversal(Node currentNode) {
        this._ancestors.add(currentNode);
        if (this._inputSet.contains(currentNode)) {
            int IStart;
            int iMax = this._filterTypes.size();
            int i = 0;
            for (i = iMax - 1; i >= 0; --i) {
                NodeList rootNodes = (NodeList)this._filterNodes.get(i);
                String type = (String)this._filterTypes.get(i);
                if (type == FUnion && this.rooted(this._ancestors, rootNodes)) break;
            }
            if ((IStart = i) == -1) {
                IStart = 0;
            }
            boolean include = true;
            for (int I = IStart; I < iMax; ++I) {
                NodeList rootNodes = (NodeList)this._filterNodes.get(I);
                String type = (String)this._filterTypes.get(I);
                boolean rooted = this.rooted(this._ancestors, rootNodes);
                if (type == FIntersect && !rooted) {
                    include = false;
                    break;
                }
                if (type != FSubtract || !rooted) continue;
                include = false;
                break;
            }
            if (include) {
                this._F.add(currentNode);
            }
        }
        if (currentNode.getNodeType() == 1) {
            NamedNodeMap attributes = ((Element)currentNode).getAttributes();
            int attributesLength = attributes.getLength();
            for (int x = 0; x < attributesLength; ++x) {
                Node attr = attributes.item(x);
                this.traversal(attr);
            }
        }
        for (Node currentChild = currentNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            this.traversal(currentChild);
        }
        this._ancestors.remove(currentNode);
    }

    boolean rooted(List ancestors, NodeList rootNodes) {
        int length = rootNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node rootNode = rootNodes.item(i);
            if (!ancestors.contains(rootNode)) continue;
            return true;
        }
        return false;
    }
}

