/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.xml.security.Init;

public class I18n {
    public static final String NOT_INITIALIZED_MSG = "You must initialize the xml-security library correctly before you use it. Call the static method \"org.apache.xml.security.Init.init();\" to do that before you use any functionality from that library.";
    public static String defaultLanguageCode;
    public static String defaultCountryCode;
    protected static ResourceBundle resourceBundle;
    protected static boolean alreadyInitialized;
    protected static String _languageCode;
    protected static String _countryCode;

    private I18n() {
    }

    public static String translate(String message, Object[] args) {
        return I18n.getExceptionMessage(message, args);
    }

    public static String translate(String message) {
        return I18n.getExceptionMessage(message);
    }

    public static String getExceptionMessage(String msgID) {
        try {
            String s = resourceBundle.getString(msgID);
            return s;
        }
        catch (Throwable t) {
            if (Init.isInitialized()) {
                return "No message with ID \"" + msgID + "\" found in resource bundle \"" + "org/apache/xml/security/resource/xmlsecurity" + "\"";
            }
            return NOT_INITIALIZED_MSG;
        }
    }

    public static String getExceptionMessage(String msgID, Exception originalException) {
        try {
            Object[] exArgs = new Object[]{originalException.getMessage()};
            String s = MessageFormat.format(resourceBundle.getString(msgID), exArgs);
            return s;
        }
        catch (Throwable t) {
            if (Init.isInitialized()) {
                return "No message with ID \"" + msgID + "\" found in resource bundle \"" + "org/apache/xml/security/resource/xmlsecurity" + "\". Original Exception was a " + originalException.getClass().getName() + " and message " + originalException.getMessage();
            }
            return NOT_INITIALIZED_MSG;
        }
    }

    public static String getExceptionMessage(String msgID, Object[] exArgs) {
        try {
            String s = MessageFormat.format(resourceBundle.getString(msgID), exArgs);
            return s;
        }
        catch (Throwable t) {
            if (Init.isInitialized()) {
                return "No message with ID \"" + msgID + "\" found in resource bundle \"" + "org/apache/xml/security/resource/xmlsecurity" + "\"";
            }
            return NOT_INITIALIZED_MSG;
        }
    }

    public static void init(String _defaultLanguageCode, String _defaultCountryCode) {
        defaultLanguageCode = _defaultLanguageCode;
        if (defaultLanguageCode == null) {
            defaultLanguageCode = Locale.getDefault().getLanguage();
        }
        if ((defaultCountryCode = _defaultCountryCode) == null) {
            defaultCountryCode = Locale.getDefault().getCountry();
        }
        I18n.initLocale(defaultLanguageCode, defaultCountryCode);
    }

    public static void initLocale(String languageCode, String countryCode) {
        if (alreadyInitialized && languageCode.equals(_languageCode) && countryCode.equals(_countryCode)) {
            return;
        }
        if (languageCode != null && countryCode != null && languageCode.length() > 0 && countryCode.length() > 0) {
            _languageCode = languageCode;
            _countryCode = countryCode;
        } else {
            _countryCode = defaultCountryCode;
            _languageCode = defaultLanguageCode;
        }
        resourceBundle = ResourceBundle.getBundle("org/apache/xml/security/resource/xmlsecurity", new Locale(_languageCode, _countryCode));
    }

    static {
        alreadyInitialized = false;
        _languageCode = null;
        _countryCode = null;
    }
}

