/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.UnsyncByteArrayOutputStream;

public class JavaUtils {
    static Log log = LogFactory.getLog((String)JavaUtils.class.getName());

    private JavaUtils() {
    }

    public static byte[] getBytesFromFile(String fileName) throws FileNotFoundException, IOException {
        int len;
        byte[] refBytes = null;
        FileInputStream fisRef = new FileInputStream(fileName);
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = fisRef.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        refBytes = baos.toByteArray();
        return refBytes;
    }

    public static void writeBytesToFilename(String filename, byte[] bytes) {
        try {
            if (filename != null && bytes != null) {
                File f = new File(filename);
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(bytes);
                fos.close();
            } else {
                log.debug((Object)"writeBytesToFilename got null byte[] pointed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] getBytesFromStream(InputStream inputStream) throws IOException {
        int len;
        byte[] refBytes = null;
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        refBytes = baos.toByteArray();
        return refBytes;
    }
}

