/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.elo.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.aselect.server.elo.ELO;
import org.aselect.server.elo.IELOStorage;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;

public class ConfigStorage
implements IELOStorage {
    private static final String MODULE = "ConfigStorage";
    private Map _mELOsIDKeys = new HashMap();
    private Map _mELOsURLKeys = new HashMap();
    private SystemLogger _systemLogger;

    public void destroy() throws ASelectException {
    }

    public ELO getEloByID(String string) throws ASelectStorageException {
        if (this._mELOsIDKeys == null) {
            return null;
        }
        return (ELO)this._mELOsIDKeys.get(string);
    }

    public ELO getEloByURL(String string) throws ASelectStorageException {
        if (this._mELOsURLKeys == null) {
            return null;
        }
        return (ELO)this._mELOsURLKeys.get(string);
    }

    public void init(Object object, ConfigManager configManager, SystemLogger systemLogger) throws ASelectException {
        this._systemLogger = systemLogger;
        String string = "init()";
        Object object2 = null;
        try {
            object2 = configManager.getSection(object, "elos");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'elos' in 'elostore' section found", (Throwable)aSelectConfigException);
            throw new ASelectException("4009", (Throwable)aSelectConfigException);
        }
        int n = -1;
        String string2 = null;
        try {
            string2 = configManager.getParam(object2, "authsp_level");
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No optional (default level) parameter 'authsp_level' in 'elo' section found");
        }
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Parameter 'authsp_level' in 'elo' section is not an integer value: " + string2, (Throwable)numberFormatException);
                throw new ASelectException("4009");
            }
        }
        String string3 = "FALSE";
        try {
            string3 = configManager.getParam(object2, "show_template");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional (default show template) parameter 'show_template' in 'elos' section found");
        }
        boolean bl = false;
        if ("TRUE".equalsIgnoreCase(string3)) {
            bl = true;
        } else if (!"FALSE".equalsIgnoreCase(string3)) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid parameter 'show_template' in 'elos' section found (must be true or false): " + string3);
            throw new ASelectException("4009");
        }
        Object object3 = null;
        try {
            object3 = configManager.getSection(object2, "elo");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string, "Not even one config item 'elo' in 'elos' section found", (Throwable)aSelectConfigException);
        }
        while (object3 != null) {
            Object object4;
            String string4 = null;
            try {
                string4 = configManager.getParam(object3, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No parameter 'id' in 'elo' section found");
                throw new ASelectException("4009");
            }
            String string5 = null;
            try {
                string5 = configManager.getParam(object3, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No parameter 'url' in 'elo' section found");
                throw new ASelectException("4009");
            }
            String string6 = null;
            try {
                string6 = configManager.getParam(object3, "shared_secret");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No parameter 'shared_secret' in 'elo' section found");
                throw new ASelectException("4009");
            }
            int n2 = -1;
            String string7 = null;
            try {
                string7 = configManager.getParam(object3, "authsp_level");
            }
            catch (ASelectConfigException aSelectConfigException) {
                if (n < 0) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No parameter 'authsp_level' in 'elo' section with id: " + string4);
                    throw new ASelectException("4009");
                }
                n2 = n;
            }
            if (string7 != null) {
                try {
                    n2 = Integer.parseInt(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Parameter 'authsp_level' in 'elo' section is not an integer value: " + string7, (Throwable)numberFormatException);
                    throw new ASelectException("4009");
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Using authsp_level '");
            stringBuffer.append(n2);
            stringBuffer.append("' for ELO with id: ");
            stringBuffer.append(string4);
            this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
            if (this._mELOsIDKeys.containsKey(string4)) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "duplicate elo ID found in section 'elos': " + string4);
                throw new ASelectException("4009");
            }
            if (this._mELOsURLKeys.containsValue(string5)) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "duplicate elo URL found in section 'elos': " + string5);
                throw new ASelectException("4009");
            }
            boolean bl2 = false;
            try {
                object4 = configManager.getParam(object3, "show_template");
                if ("TRUE".equalsIgnoreCase((String)object4)) {
                    bl2 = true;
                } else if (!"FALSE".equalsIgnoreCase((String)object4)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid parameter 'show_template' in 'elo' section found (must be true or false): " + (String)object4);
                    throw new ASelectException("4009");
                }
            }
            catch (ASelectConfigException aSelectConfigException) {
                bl2 = bl;
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional parameter 'show_template' in 'elo' section found, using default: " + bl2);
            }
            object4 = new ELO(string4, string6, string5, n2, bl2);
            this._mELOsIDKeys.put(string4, object4);
            this._mELOsURLKeys.put(string5, object4);
            object3 = configManager.getNextSection(object3);
        }
    }
}

