/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.processor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.processor.AttributesMulti;
import org.aselect.server.processor.IProcessor;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.sam.agent.SAMResource;
import org.aselect.system.utils.BASE64Encoder;
import org.aselect.system.utils.Base64;

public class AttributeProcessor
implements IProcessor {
    private static final String MODULE = "AttributeProcessor";
    private ASelectAuthenticationLogger _authenticationLogger;
    private SAMResource _samActiveResource;
    private String _sTargetUrl;
    private String _sTargetResourceGroup;
    private String _sResumeUrl;
    private HttpClient _httpClient;
    private ASelectSystemLogger _systemLogger = ASelectSystemLogger.getHandle();
    private SessionManager _sessionManager;
    private ASelectSAMAgent _samAgent;
    private ASelectConfigManager _configManager;

    public AttributeProcessor() {
        this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
        this._samAgent = ASelectSAMAgent.getHandle();
        this._sessionManager = SessionManager.getHandle();
    }

    public void destroy() {
    }

    public void init(ASelectConfigManager aSelectConfigManager, Object object) throws ASelectException {
        String string = "init()";
        try {
            this._configManager = aSelectConfigManager;
            this._httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            Object object2 = this.getSection(aSelectConfigManager, "target", object);
            if (object2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'target' section found in configuration");
                throw new ASelectException("4009");
            }
            this._sTargetResourceGroup = this.getParam(aSelectConfigManager, object2, "resourcegroup");
            if (this._sTargetResourceGroup == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'resourcegroup' item found in 'target' section in configuration");
                throw new ASelectException("4009");
            }
            this.getTargetUrl();
            Object object3 = this.getSection(aSelectConfigManager, "resume", object);
            if (object3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'resume' section found in configuration");
                throw new ASelectException("4009");
            }
            this._sResumeUrl = this.getParam(aSelectConfigManager, object3, "url");
            if (this._sResumeUrl == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'url' item found in 'resume' section in configuration");
                throw new ASelectException("4009");
            }
            try {
                new URL(this._sResumeUrl);
            }
            catch (MalformedURLException malformedURLException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Configured 'url' item in 'resume' section is not a URL: " + this._sResumeUrl);
                throw new ASelectException("4009");
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    public boolean process(HttpServletResponse httpServletResponse, String string, Hashtable hashtable, Hashtable hashtable2) throws ASelectException {
        boolean bl = true;
        try {
            Hashtable hashtable3;
            AttributesMulti attributesMulti = null;
            String string2 = (String)hashtable2.get("attributes");
            if (string2 != null && (hashtable3 = this.deserializeAttributes(string2)) != null) {
                attributesMulti = new AttributesMulti(hashtable3);
            }
            bl = this.performCall(httpServletResponse, string, attributesMulti, hashtable2);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, "process()", "Could not process request", (Throwable)exception);
            throw new ASelectException("0001");
        }
        return bl;
    }

    private boolean performCall(HttpServletResponse httpServletResponse, String string, AttributesMulti attributesMulti, Hashtable hashtable) throws ASelectException {
        boolean bl;
        block29: {
            bl = true;
            GetMethod getMethod = null;
            try {
                String string2;
                Object object;
                Object object2;
                Hashtable hashtable2 = this._sessionManager.getSessionContext(string);
                if (hashtable2 == null) {
                    this._systemLogger.log(Level.FINE, MODULE, "performCall()", "Session expired or no session found with rid: " + string);
                    throw new ASelectException("0102");
                }
                String string3 = (String)hashtable.get("uid");
                if (string3 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, "performCall()", "No uid found in request with rid: " + string);
                    throw new ASelectException("0070");
                }
                String string4 = (String)hashtable2.get("remote_organization");
                if (string4 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, "performCall()", "No 'remote_organization' found in session with rid: " + string);
                    throw new ASelectException("0070");
                }
                String string5 = (String)hashtable2.get("app_url");
                if (string5 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, "performCall()", "No 'app_url' found in session with rid: " + string);
                    throw new ASelectException("0070");
                }
                String string6 = (String)hashtable2.get("app_id");
                if (string6 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, "performCall()", "No 'app_id' found in session with rid: " + string);
                    throw new ASelectException("0070");
                }
                AttributesMulti attributesMulti2 = new AttributesMulti();
                attributesMulti2.addAttribute("rid", string);
                attributesMulti2.addAttribute("uid", string3);
                if (attributesMulti != null) {
                    attributesMulti2.addAttribute("attributes", attributesMulti.toEncodedString());
                }
                attributesMulti2.addAttribute("requestor", string6);
                attributesMulti2.addAttribute("remote_idp", string4);
                attributesMulti2.addAttribute("requestor_url", string5);
                String string7 = this.getTargetUrl();
                getMethod = new GetMethod(string7);
                getMethod.setQueryString(attributesMulti2.toEncodedString());
                this._systemLogger.log(Level.FINER, MODULE, "performCall()", "Sending " + getMethod.getURI());
                try {
                    this._httpClient.executeMethod((HttpMethod)getMethod);
                }
                catch (HttpException httpException) {
                    this._systemLogger.log(Level.WARNING, MODULE, "performCall()", "Could not execute method call: " + getMethod.toString(), (Throwable)httpException);
                    throw new ASelectException("4006");
                }
                String string8 = getMethod.getResponseBodyAsString();
                StringBuffer stringBuffer = new StringBuffer("Response from ");
                stringBuffer.append(string7);
                stringBuffer.append(" contains message body: ");
                stringBuffer.append(string8);
                this._systemLogger.log(Level.FINER, MODULE, "performCall()", stringBuffer.toString());
                AttributesMulti attributesMulti3 = new AttributesMulti(string8);
                String string9 = attributesMulti3.getAttribute("attributes");
                if (string9 != null) {
                    object2 = new AttributesMulti(string9);
                    object = ((AttributesMulti)object2).toHashtable();
                    String string10 = this.serializeAttributes((Hashtable)object);
                    if (string10 != null) {
                        hashtable.put("attributes", string10);
                    } else if (hashtable.containsKey("attributes")) {
                        hashtable.remove("attributes");
                    }
                }
                if ((object2 = attributesMulti3.getAttribute("uid")) != null) {
                    hashtable.put("uid", object2);
                }
                if ((object = attributesMulti3.getAttribute("action")) == null) {
                    this._systemLogger.log(Level.FINE, MODULE, "performCall()", "No required 'action' parameter in response");
                    throw new ASelectException("0030");
                }
                boolean bl2 = true;
                if (((String)object).equals("t")) {
                    bl2 = false;
                    this._sessionManager.remove((Object)string);
                } else if (!((String)object).equals("p")) {
                    this._systemLogger.log(Level.FINE, MODULE, "performCall()", "Invalid 'action' parameter in response: " + (String)object);
                    throw new ASelectException("0030");
                }
                if (bl2) {
                    hashtable2.put("uid", string3);
                    hashtable2.put("cross_attributes", hashtable);
                    this._sessionManager.updateSession(string, hashtable2);
                }
                if ((string2 = attributesMulti3.getAttribute("redirect_url")) != null) {
                    bl = false;
                    try {
                        new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this._systemLogger.log(Level.FINE, MODULE, "performCall()", "Invalid 'redirect_url' parameter in response: " + string2, (Throwable)malformedURLException);
                        throw new ASelectException("0030");
                    }
                    this.performRedirect(httpServletResponse, string2, string, bl2);
                    break block29;
                }
                if (!bl2) {
                    this._authenticationLogger.log(new Object[]{"Processor", string3, null, string4, string6, "denied"});
                    throw new ASelectException("000b");
                }
            }
            catch (ASelectException aSelectException) {
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, "performCall()", "Could not perform call", (Throwable)exception);
                throw new ASelectException("0001");
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        return bl;
    }

    private void performRedirect(HttpServletResponse httpServletResponse, String string, String string2, boolean bl) throws ASelectException {
        String string3 = "performRedirect()";
        StringBuffer stringBuffer = null;
        try {
            AttributesMulti attributesMulti = new AttributesMulti();
            attributesMulti.addAttribute("rid", string2);
            if (bl) {
                StringBuffer stringBuffer2 = new StringBuffer(this._sResumeUrl);
                stringBuffer2.append("?rid=");
                stringBuffer2.append(string2);
                attributesMulti.addAttribute("redirect_url", stringBuffer2.toString());
            }
            stringBuffer = new StringBuffer(string);
            if (string.indexOf(63) == -1) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append(attributesMulti.toEncodedString());
            this._systemLogger.log(Level.FINER, MODULE, string3, "Performing redirect: " + stringBuffer.toString());
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "Could not send redirect: " + stringBuffer.toString(), (Throwable)iOException);
            throw new ASelectException("0030");
        }
    }

    private Object getSection(ASelectConfigManager aSelectConfigManager, String string, Object object) {
        Object object2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf("/");
        string3 = n == -1 ? string : string.substring(0, n);
        int n2 = string3.indexOf("@");
        if (n2 > -1) {
            string4 = string3.substring(n2 + 1);
            string3 = string3.substring(0, n2);
        }
        if (string4 == null) {
            try {
                object2 = aSelectConfigManager.getSection(object, string3);
            }
            catch (ASelectConfigException aSelectConfigException) {
                object2 = null;
            }
        } else {
            try {
                object2 = aSelectConfigManager.getSection(object, string3, "id=" + string4);
            }
            catch (ASelectConfigException aSelectConfigException) {
                object2 = null;
            }
        }
        if (n == -1 || object2 == null) {
            return object2;
        }
        string2 = string.substring(n + 1);
        return this.getSection(aSelectConfigManager, string2, object2);
    }

    private String getParam(ASelectConfigManager aSelectConfigManager, Object object, String string) {
        String string2 = null;
        try {
            string2 = aSelectConfigManager.getParam(object, string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            return null;
        }
        return string2;
    }

    private Hashtable deserializeAttributes(String string) {
        String string2 = "deSerializeAttributes()";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string != null) {
            try {
                String string3 = new String(Base64.decode((String)string));
                String[] stringArray = string3.split("&");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf("=");
                    String string4 = "";
                    String string5 = "";
                    Vector<String> vector = null;
                    if (n > 0) {
                        string4 = URLDecoder.decode(stringArray[i].substring(0, n), "UTF-8");
                        string5 = URLDecoder.decode(stringArray[i].substring(n + 1), "UTF-8");
                        if (string4.endsWith("[]")) {
                            vector = (Vector<String>)hashtable.get(string4 = string4.substring(0, string4.length() - 2));
                            if (vector == null) {
                                vector = new Vector<String>();
                            }
                            vector.add(string5);
                        }
                    } else {
                        string4 = URLDecoder.decode(stringArray[i], "UTF-8");
                    }
                    if (vector != null) {
                        hashtable.put(string4, vector);
                        continue;
                    }
                    hashtable.put(string4, string5);
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Error during deserialization of attributes", (Throwable)exception);
            }
        }
        return hashtable;
    }

    private String serializeAttributes(Hashtable hashtable) throws ASelectException {
        try {
            if (hashtable == null || hashtable.isEmpty()) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            BASE64Encoder bASE64Encoder = hashtable.keys();
            while (bASE64Encoder.hasMoreElements()) {
                Object object;
                String string = (String)bASE64Encoder.nextElement();
                Object v = hashtable.get(string);
                if (v instanceof Vector) {
                    object = (Vector)v;
                    string = URLEncoder.encode(string + "[]", "UTF-8");
                    Enumeration enumeration = ((Vector)object).elements();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        stringBuffer.append(string);
                        stringBuffer.append("=");
                        stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
                        if (!enumeration.hasMoreElements()) continue;
                        stringBuffer.append("&");
                    }
                } else if (v instanceof String) {
                    object = (String)v;
                    stringBuffer.append(URLEncoder.encode(string, "UTF-8"));
                    stringBuffer.append("=");
                    stringBuffer.append(URLEncoder.encode((String)object, "UTF-8"));
                }
                if (!bASE64Encoder.hasMoreElements()) continue;
                stringBuffer.append("&");
            }
            bASE64Encoder = new BASE64Encoder();
            return bASE64Encoder.encode(stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, "serializeAttributes()", "Could not serialize attributes", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    private String getTargetUrl() throws ASelectException {
        block6: {
            String string = "getTargetUrl()";
            try {
                if (this._sTargetUrl != null && this._samActiveResource != null && this._samActiveResource.live()) break block6;
                this._samActiveResource = this._samAgent.getActiveResource(this._sTargetResourceGroup);
                this._sTargetUrl = this.getParam(this._configManager, this._samActiveResource.getAttributes(), "url");
                if (this._sTargetUrl == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No 'url' configuration item found in resourcegroup with id: " + this._sTargetResourceGroup);
                    throw new ASelectException("4011");
                }
                try {
                    new URL(this._sTargetUrl);
                }
                catch (MalformedURLException malformedURLException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Configured 'url' item in resourcegroup is not a valid URL: " + this._sTargetUrl, (Throwable)malformedURLException);
                    throw new ASelectException("4011");
                }
            }
            catch (ASelectException aSelectException) {
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not retrieve remote url from resourcegroup: " + this._sTargetResourceGroup, (Throwable)exception);
                throw new ASelectException("0001");
            }
        }
        return this._sTargetUrl;
    }
}

