/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.processor;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.processor.NMVPair;
import org.aselect.system.exception.ASelectException;

public class AttributesMulti {
    private static final String MODULE = "AttributesMulti";
    private ASelectSystemLogger _systemLogger = ASelectSystemLogger.getHandle();
    private Hashtable _attributes = new Hashtable();

    public AttributesMulti() {
    }

    public AttributesMulti(String string) throws ASelectException {
        if (string != null) {
            this.addString(string);
        }
    }

    public AttributesMulti(Hashtable hashtable) {
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = hashtable.get(string);
            if (v instanceof Vector) {
                this.addAttributes(string, (Vector)v);
                continue;
            }
            this.addAttribute(string, (String)v);
        }
    }

    public void addAttribute(String string, String string2) {
        NMVPair nMVPair = null;
        if (this._attributes.containsKey(string)) {
            nMVPair = (NMVPair)this._attributes.get(string);
        } else {
            nMVPair = new NMVPair(string);
            this._attributes.put(string, nMVPair);
        }
        nMVPair.addValue(string2);
    }

    public void addAttributes(String string, Vector vector) {
        NMVPair nMVPair = null;
        if (this._attributes.containsKey(string)) {
            nMVPair = (NMVPair)this._attributes.get(string);
        } else {
            nMVPair = new NMVPair(string);
            this._attributes.put(string, nMVPair);
        }
        nMVPair.addValues(vector);
    }

    public String getAttribute(String string) {
        if (this._attributes.containsKey(string)) {
            return (String)this.getAttributes(string).get(0);
        }
        return null;
    }

    public List getAttributes(String string) {
        NMVPair nMVPair = (NMVPair)this._attributes.get(string);
        return nMVPair.getValues();
    }

    public void remove(String string) {
        if (this._attributes.containsKey(string)) {
            this._attributes.remove(string);
        }
    }

    public Hashtable toHashtable() {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this._attributes.values().iterator();
        while (iterator.hasNext()) {
            NMVPair nMVPair = (NMVPair)iterator.next();
            nMVPair.updateMixedHashtable(hashtable);
        }
        return hashtable;
    }

    public String toEncodedString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._attributes.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NMVPair nMVPair = (NMVPair)this._attributes.get(string);
            stringBuffer.append(nMVPair.encodeMV());
            if (!iterator.hasNext()) continue;
            stringBuffer.append('&');
        }
        return stringBuffer.toString();
    }

    private void addString(String string) throws ASelectException {
        String string2 = "addString()";
        try {
            String[] stringArray = string.split("&");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                if (stringArray2.length < 1 || stringArray2.length > 2) {
                    this._systemLogger.log(Level.FINE, MODULE, string2, "Malformed attribute name/value pair: " + stringArray[i]);
                    throw new ASelectException("0001");
                }
                String string3 = "";
                if (stringArray2.length <= 0) continue;
                string3 = URLDecoder.decode(stringArray2[0], "UTF-8");
                String string4 = "";
                if (stringArray2.length > 1) {
                    string4 = URLDecoder.decode(stringArray2[1], "UTF-8");
                }
                if (string3.trim().equals("")) continue;
                this.addAttribute(string3, string4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.FINE, MODULE, string2, "Could not use decode with UTF-8", (Throwable)unsupportedEncodingException);
            throw new ASelectException("0001");
        }
    }
}

