/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.attributeprocessor;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.server.session.SessionManager;
import org.aselect.server.tgt.TGTIssuer;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class AttributeProcessorProceeder
extends AbstractRequestHandler {
    private static final String MODULE = "AttributeProcessorProceeder";
    private ASelectAuthenticationLogger _authenticationLogger = ASelectAuthenticationLogger.getHandle();
    private TGTManager _tgtManager = TGTManager.getHandle();
    private SessionManager _sessionManager = SessionManager.getHandle();
    private String _sMyServerId;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            super.init(servletConfig, object);
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not find 'aselect' config section in config file", (Throwable)aSelectConfigException);
                throw new ASelectException("4009");
            }
            try {
                this._sMyServerId = this._configManager.getParam(object2, "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve 'server_id' config parameter in 'aselect' config section", (Throwable)aSelectConfigException);
                throw new ASelectException("4009");
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error during initialize", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    public void destroy() {
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        try {
            String string2 = httpServletRequest.getParameter("rid");
            if (string2 == null) {
                this._systemLogger.log(Level.FINER, MODULE, string, "No rid in request");
                throw new ASelectException("0030");
            }
            if (!this.validateRid(string2)) {
                this._systemLogger.log(Level.FINER, MODULE, string, "Invalid rid in request: " + string2);
                throw new ASelectException("0030");
            }
            Hashtable hashtable = this._sessionManager.getSessionContext(string2);
            if (hashtable == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Session expired -> SessionContext not available for rid: " + string2);
                throw new ASelectException("0102");
            }
            String string3 = (String)hashtable.get("remote_organization");
            if (string3 == null) {
                this._systemLogger.log(Level.FINER, MODULE, string, "Invalid session: No 'remote_organization' in session with rid: " + string2);
                throw new ASelectException("0070");
            }
            String string4 = (String)hashtable.get("app_id");
            if (string4 == null) {
                this._systemLogger.log(Level.FINER, MODULE, string, "Invalid session: No 'app_id' in session with rid: " + string2);
                throw new ASelectException("0070");
            }
            Hashtable hashtable2 = (Hashtable)hashtable.get("cross_attributes");
            if (hashtable2 == null) {
                this._systemLogger.log(Level.FINER, MODULE, string, "Invalid session: No 'cross_attributes' in session with rid: " + string2);
                throw new ASelectException("0070");
            }
            String string5 = (String)hashtable2.get("uid");
            if (string5 == null) {
                this._systemLogger.log(Level.FINER, MODULE, string, "Invalid session: No 'uid' in 'cross_attributes' in session with rid: " + string2);
                throw new ASelectException("0070");
            }
            this._authenticationLogger.log(new Object[]{"Cross", string5, httpServletRequest.getRemoteAddr(), string3, string4, "granted"});
            TGTIssuer tGTIssuer = new TGTIssuer(this._sMyServerId);
            tGTIssuer.issueCrossTGT(string2, null, hashtable2, httpServletResponse, this.getTGTFromCredentials(httpServletRequest), httpServletRequest);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error during process", (Throwable)exception);
            throw new ASelectException("0001");
        }
        return new RequestState(null);
    }

    private boolean validateRid(String string) {
        return string.matches("[A-Za-z0-9]{16}");
    }

    private String getTGTFromCredentials(HttpServletRequest httpServletRequest) {
        String string = "getTGTFromCredentials()";
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return null;
        }
        String string2 = null;
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals("aselect_credentials")) continue;
            string2 = cookieArray[i].getValue();
            this._systemLogger.log(Level.FINER, MODULE, string, "Cookie 'aselect_credentials' has value: " + string2);
            int n = string2.length();
            if (string2.charAt(0) != '\"' || string2.charAt(n - 1) != '\"') continue;
            string2 = string2.substring(1, n - 1);
        }
        if (string2 == null) {
            return null;
        }
        Hashtable hashtable = Utils.convertCGIMessage(string2);
        if (hashtable == null) {
            return null;
        }
        String string3 = (String)hashtable.get("tgt");
        if (string3 == null) {
            return null;
        }
        String string4 = (String)hashtable.get("uid");
        if (string4 == null) {
            return null;
        }
        String string5 = (String)hashtable.get("a-select-server");
        if (string5 == null) {
            return null;
        }
        if (!string5.equals(this._sMyServerId)) {
            return null;
        }
        Hashtable hashtable2 = this._tgtManager.getTGT(string3);
        if (hashtable2 == null) {
            return null;
        }
        if (!string4.equals(hashtable2.get("uid"))) {
            return null;
        }
        return string3;
    }
}

