/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.entree.sso.cookiemonster;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.elo.ELO;
import org.aselect.server.elo.ELOFactory;
import org.aselect.server.elo.IELOStorage;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class CookieMonsterHandler
extends AbstractRequestHandler {
    private static final String MODULE = "CookieMonsterHandler";
    private String _sSSOserviceURL = null;
    private IELOStorage _oStore = null;
    private SessionManager _oSessionManager = null;
    private static final String REPLY_PARAM_NAME = "redirect_url";

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        super.init(servletConfig, object);
        String string = "init()";
        this._oStore = ELOFactory.getHandle().getEloStore();
        this._oSessionManager = SessionManager.getHandle();
        Object object2 = null;
        try {
            object2 = this._configManager.getSection(object, "ssoservice");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'ssoservice' found");
            throw new ASelectException("4009");
        }
        try {
            this._sSSOserviceURL = this._configManager.getParam(object2, "url");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'url' in section 'ssoservice' found");
            throw new ASelectException("4009");
        }
    }

    public void destroy() {
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        if (this._oStore == null || this._oSessionManager == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Cookie monster not initialized");
            throw new ASelectException("0001");
        }
        String string2 = httpServletRequest.getParameter("rid");
        String string3 = httpServletRequest.getParameter("uid");
        String string4 = httpServletRequest.getParameter("shared_secret");
        String string5 = httpServletRequest.getParameter("attributes");
        if (string2 == null || "".equals(string2)) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Elo Cookie Monster request lacks 'rid' parameter, and response could not be sent");
            throw new ASelectException("0030");
        }
        if (string3 == null || "".equals(string3)) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Elo Cookie Monster request lacks 'uid' parameter, and response could not be sent");
            throw new ASelectException("0030");
        }
        if (string4 == null || "".equals(string4)) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Elo Cookie Monster request lacks 'shared_secret' parameter, and response could not be sent");
            throw new ASelectException("0030");
        }
        Hashtable hashtable = this._oSessionManager.getSessionContext(string2);
        if (hashtable == null) {
            this._systemLogger.log(Level.INFO, MODULE, string, "Could not load session");
            throw new ASelectException("0070");
        }
        String string6 = (String)hashtable.get("elo_id");
        if (string6 == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve 'elo_id' from session, ELO ID: " + string6);
            throw new ASelectException("0070");
        }
        ELO eLO = this._oStore.getEloByID(string6);
        if (eLO == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not load Elo information from elo store, ELO ID: " + string6);
            throw new ASelectException("0070");
        }
        if (!string4.equals(eLO.getSharedSecret())) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "ELO shared secret mismatch, ELO ID: " + string6);
            throw new ASelectException("0030");
        }
        hashtable.put("uid", string3);
        if (string5 != null && !"".equals(string5)) {
            hashtable.put("elo_attributes", string5);
        }
        hashtable.put("remote_organization", eLO.getID());
        this._oSessionManager.updateSession(string2, hashtable);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._sSSOserviceURL);
        if (this._sSSOserviceURL.indexOf(63) == -1) {
            stringBuffer.append("?");
        } else {
            stringBuffer.append("&");
        }
        stringBuffer.append("rid=");
        stringBuffer.append(string2);
        PrintWriter printWriter = null;
        try {
            StringBuffer stringBuffer2 = new StringBuffer(REPLY_PARAM_NAME);
            stringBuffer2.append("=");
            stringBuffer2.append(URLEncoder.encode(stringBuffer.toString(), "UTF-8"));
            printWriter = httpServletResponse.getWriter();
            this._systemLogger.log(Level.FINER, MODULE, string, "Sending response: " + stringBuffer2.toString());
            printWriter.write(stringBuffer2.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not URLEncode with UTF-8", (Throwable)unsupportedEncodingException);
            throw new ASelectException("0001");
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Cookie monster could not reply", (Throwable)iOException);
            throw new ASelectException("0001");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return new RequestState(null);
    }
}

