/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.entree.sso.notification;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.elo.ELO;
import org.aselect.server.elo.ELOFactory;
import org.aselect.server.elo.IELOStorage;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class SSONotifcationServiceHandler
extends AbstractRequestHandler {
    private static final String MODULE = "SSONotifcationServiceHandler";
    private static final String COOKIE_NOTIFICATION = "elo";
    private String _sCookieDomain;
    private String _sCookieDomainPath;
    private IELOStorage _oStore = null;
    private String _sTemplate;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            super.init(servletConfig, object);
            this._oStore = ELOFactory.getHandle().getEloStore();
            this.readCookieSettings(object);
            String string2 = null;
            try {
                string2 = this._configManager.getParam(object, "template");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sTemplate = null;
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'template' item found in configuration", (Throwable)aSelectConfigException);
            }
            if (string2 != null) {
                String string3 = this._configManager.getWorkingdir();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3);
                if (!string3.endsWith(File.separator)) {
                    stringBuffer.append(File.separator);
                }
                stringBuffer.append("conf");
                stringBuffer.append(File.separator);
                stringBuffer.append("html");
                stringBuffer.append(File.separator);
                stringBuffer.append(string2);
                File file = new File(stringBuffer.toString());
                if (!file.exists()) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Configured template does not exists: " + stringBuffer.toString());
                    throw new ASelectException("4009");
                }
                this._sTemplate = this.readTemplate(file);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        try {
            String string2 = httpServletRequest.getParameter(COOKIE_NOTIFICATION);
            if (string2 == null || "".equals(string2)) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "ELO notification request lacks 'elo' parameter, and response could not be sent");
                throw new ASelectException("0030");
            }
            ELO eLO = this._oStore.getEloByID(string2);
            if (eLO == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Unknown ELO id in request: " + string2);
                throw new ASelectException("0030");
            }
            this.verifyReferer(httpServletRequest, eLO);
            Cookie cookie = new Cookie(COOKIE_NOTIFICATION, eLO.getURL());
            if (this._sCookieDomain != null) {
                cookie.setDomain(this._sCookieDomain);
            }
            if (this._sCookieDomainPath != null) {
                cookie.setPath(this._sCookieDomainPath);
            }
            if (this._configManager.getCookiesVersion() != -1) {
                cookie.setVersion(this._configManager.getCookiesVersion());
            }
            httpServletResponse.addCookie(cookie);
            if (this._sTemplate != null && eLO.showTemplate()) {
                this.showSuccess(httpServletResponse);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process", (Throwable)exception);
            throw new ASelectException("0001");
        }
        return new RequestState(null);
    }

    public void destroy() {
    }

    private void readCookieSettings(Object object) throws ASelectException {
        String string = "readCookieSettings()";
        Object object2 = null;
        try {
            object2 = this._configManager.getSection(object, "notification_cookie");
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No 'notification_cookie' section found in configuration");
            throw new ASelectException("4009");
        }
        try {
            this._sCookieDomain = this._configManager.getParam(object2, "domain");
            if (!this._sCookieDomain.startsWith(".")) {
                this._sCookieDomain = "." + this._sCookieDomain;
            }
            this._systemLogger.log(Level.INFO, MODULE, string, "Notification cookie will be set on domain: " + this._sCookieDomain);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'domain' item in 'notification_cookie' section found in configuration");
        }
        try {
            this._sCookieDomainPath = this._configManager.getParam(object2, "path");
            this._systemLogger.log(Level.INFO, MODULE, string, "Notification cookie will be set on path: " + this._sCookieDomainPath);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'path' item in 'notification_cookie' section found in configuration");
        }
    }

    private void verifyReferer(HttpServletRequest httpServletRequest, ELO eLO) throws ASelectException {
        String string = "verifyReferer()";
        String string2 = httpServletRequest.getHeader("referer");
        if (string2 == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No referer header in request");
            throw new ASelectException("0030");
        }
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid referer header in request: " + string2, (Throwable)malformedURLException);
            throw new ASelectException("0030");
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(eLO.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid ELO url in ELO store: " + eLO.getURL(), (Throwable)malformedURLException);
            throw new ASelectException("0001");
        }
        if (!uRL2.getHost().equalsIgnoreCase(uRL.getHost())) {
            StringBuffer stringBuffer = new StringBuffer("Header referer contains invalid hostname for ELO with id '");
            stringBuffer.append(eLO.getID());
            stringBuffer.append("': ");
            stringBuffer.append(string2);
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
            throw new ASelectException("0030");
        }
    }

    private void showSuccess(HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "showSuccess()";
        PrintWriter printWriter = null;
        try {
            printWriter = httpServletResponse.getWriter();
            printWriter.print(this._sTemplate);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Can't show success page", (Throwable)exception);
            throw new ASelectException("0001");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private String readTemplate(File file) throws ASelectException {
        String string = "readTemplate()";
        BufferedReader bufferedReader = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not read template", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close BufferedReader", (Throwable)iOException);
            }
        }
        return stringBuffer.toString();
    }
}

