/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.entree.sso.service;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.elo.ELO;
import org.aselect.server.elo.ELOFactory;
import org.aselect.server.elo.IELOStorage;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.processor.IProcessor;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.server.tgt.TGTIssuer;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class SSOServiceHandler
extends AbstractRequestHandler {
    private static final String MODULE = "SSOServiceHandler";
    private ASelectAuthenticationLogger _authenticationLogger;
    private IProcessor _processorSSOService;
    private IELOStorage _oStore = ELOFactory.getHandle().getEloStore();
    private String _sMyServerID = null;
    private TGTManager _tgtManager = null;

    public SSOServiceHandler() throws ASelectException {
        this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
        this._tgtManager = TGTManager.getHandle();
    }

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            super.init(servletConfig, object);
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not find 'aselect' config section in config file");
                throw new ASelectException("4009");
            }
            try {
                this._sMyServerID = this._configManager.getParam(object2, "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not retrieve 'server_id' config parameter in 'aselect' config section");
                throw new ASelectException("4009");
            }
            this._processorSSOService = this.createProcessor(this._configManager, object, "sso_service");
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void destroy() {
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        String string2 = httpServletRequest.getParameter("rid");
        if (string2 == null || "".equals(string2)) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "ELO SSO service request lacks 'rid' parameter, and response could not be sent");
            throw new ASelectException("0030");
        }
        Hashtable hashtable = this._oSessionManager.getSessionContext(string2);
        if (hashtable == null) {
            this._systemLogger.log(Level.FINE, MODULE, string, "Session could not be loaded");
            throw new ASelectException("0070");
        }
        String string3 = (String)hashtable.get("elo_id");
        if (string3 == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "ELO ID could not be loaded from session");
            throw new ASelectException("0030");
        }
        ELO eLO = this._oStore.getEloByID(string3);
        if (eLO == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "ELO could not be loaded from ELO Storage");
            throw new ASelectException("0001");
        }
        Hashtable hashtable2 = new Hashtable();
        Object v = hashtable.get("uid");
        if (v != null) {
            hashtable2.put("uid", v);
        }
        hashtable2.put("organization", eLO.getID());
        hashtable2.put("authsp_level", "" + eLO.getLevel());
        hashtable2.put("authsp", eLO.getID());
        String string4 = (String)hashtable.get("elo_attributes");
        if (string4 != null) {
            hashtable2.put("attributes", string4);
        }
        boolean bl = true;
        if (this._processorSSOService != null) {
            bl = this._processorSSOService.process(httpServletResponse, string2, null, hashtable2);
        }
        if (bl) {
            this._authenticationLogger.log(new Object[]{"SSOService", v, httpServletRequest.getRemoteAddr(), eLO.getID(), hashtable.get("app_id"), "granted"});
            TGTIssuer tGTIssuer = new TGTIssuer(this._sMyServerID);
            tGTIssuer.issueCrossTGT(string2, null, hashtable2, httpServletResponse, this.getTGTFromCredentials(httpServletRequest), httpServletRequest);
        }
        return new RequestState(null);
    }

    private IProcessor createProcessor(ASelectConfigManager aSelectConfigManager, Object object, String string) throws ASelectException {
        String string2 = "createProcessor()";
        IProcessor iProcessor = null;
        Object object2 = null;
        try {
            object2 = aSelectConfigManager.getSection(object, "processor", "id=" + string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, MODULE, string2, "No optional 'processor' section found in configuration with id: " + string);
        }
        if (object2 != null) {
            String string3 = null;
            try {
                string3 = aSelectConfigManager.getParam(object2, "class");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No 'class' item in 'processor' section found in configuration", (Throwable)aSelectConfigException);
                throw new ASelectException("4009");
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Configured 'class' item in 'processor' section not found: " + string3, (Throwable)classNotFoundException);
                throw new ASelectException("4009");
            }
            Object var9_12 = null;
            try {
                var9_12 = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not instantiate: " + string3, (Throwable)instantiationException);
                throw new ASelectException("4009");
            }
            catch (IllegalAccessException illegalAccessException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not access: " + string3, (Throwable)illegalAccessException);
                throw new ASelectException("4009");
            }
            try {
                iProcessor = var9_12;
            }
            catch (ClassCastException classCastException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Configured class is not of type IProcessor: " + string3, (Throwable)classCastException);
                throw new ASelectException("4009");
            }
            try {
                iProcessor.init(aSelectConfigManager, object2);
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not initialize: " + string3, (Throwable)aSelectException);
                throw new ASelectException("4009");
            }
            this._systemLogger.log(Level.INFO, MODULE, string2, "Processor initialized: " + string3);
        }
        return iProcessor;
    }

    private String getTGTFromCredentials(HttpServletRequest httpServletRequest) {
        String string = "getTGTFromCredentials()";
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return null;
        }
        String string2 = null;
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals("aselect_credentials")) continue;
            string2 = cookieArray[i].getValue();
            this._systemLogger.log(Level.FINER, MODULE, string, "Cookie 'aselect_credentials' has value: " + string2);
            int n = string2.length();
            if (string2.charAt(0) != '\"' || string2.charAt(n - 1) != '\"') continue;
            string2 = string2.substring(1, n - 1);
        }
        if (string2 == null) {
            return null;
        }
        Hashtable hashtable = Utils.convertCGIMessage(string2);
        if (hashtable == null) {
            return null;
        }
        String string3 = (String)hashtable.get("tgt");
        if (string3 == null) {
            return null;
        }
        String string4 = (String)hashtable.get("uid");
        if (string4 == null) {
            return null;
        }
        String string5 = (String)hashtable.get("a-select-server");
        if (string5 == null) {
            return null;
        }
        if (!string5.equals(this._sMyServerID)) {
            return null;
        }
        Hashtable hashtable2 = this._tgtManager.getTGT(string3);
        if (hashtable2 == null) {
            return null;
        }
        if (!string4.equals(hashtable2.get("uid"))) {
            return null;
        }
        return string3;
    }
}

