/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class RC6
extends BlockCipher {
    private static final int ROUNDS = 20;
    private static final int BLOCK_SIZE = 16;
    private static final int P = -1209970333;
    private static final int Q = -1640531527;
    private int[] S = new int[44];
    private boolean decrypt;

    protected void coreInit(Key key, boolean decrypt) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key missing");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] userkey = key.getEncoded();
        if (userkey == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        int len = userkey.length;
        if (len != 16 && len != 24 && len != 32) {
            throw new InvalidKeyException("Invalid user key length");
        }
        this.generateSubKeys(userkey);
        this.decrypt = decrypt;
    }

    protected final void coreCrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        int A = in[inOffset++] & 0xFF | (in[inOffset++] & 0xFF) << 8 | (in[inOffset++] & 0xFF) << 16 | in[inOffset++] << 24;
        int B = in[inOffset++] & 0xFF | (in[inOffset++] & 0xFF) << 8 | (in[inOffset++] & 0xFF) << 16 | in[inOffset++] << 24;
        int C = in[inOffset++] & 0xFF | (in[inOffset++] & 0xFF) << 8 | (in[inOffset++] & 0xFF) << 16 | in[inOffset++] << 24;
        int D = in[inOffset++] & 0xFF | (in[inOffset++] & 0xFF) << 8 | (in[inOffset++] & 0xFF) << 16 | in[inOffset] << 24;
        if (this.decrypt) {
            C -= this.S[43];
            A -= this.S[42];
            int i = 42;
            while (i > 2) {
                int t = D;
                D = C;
                C = B;
                B = A;
                A = t;
                int u = RC6.rotl(D * (2 * D + 1), 5);
                t = RC6.rotl(B * (2 * B + 1), 5);
                C = RC6.rotr(C - this.S[--i], t) ^ u;
                A = RC6.rotr(A - this.S[--i], u) ^ t;
            }
            D -= this.S[1];
            B -= this.S[0];
        } else {
            B += this.S[0];
            D += this.S[1];
            int i = 1;
            while (i <= 40) {
                int t = RC6.rotl(B * (2 * B + 1), 5);
                int u = RC6.rotl(D * (2 * D + 1), 5);
                A = RC6.rotl(A ^ t, u) + this.S[++i];
                C = RC6.rotl(C ^ u, t) + this.S[++i];
                t = A;
                A = B;
                B = C;
                C = D;
                D = t;
            }
            A += this.S[42];
            C += this.S[43];
        }
        out[outOffset++] = (byte)A;
        out[outOffset++] = (byte)(A >>> 8);
        out[outOffset++] = (byte)(A >>> 16);
        out[outOffset++] = (byte)(A >>> 24);
        out[outOffset++] = (byte)B;
        out[outOffset++] = (byte)(B >>> 8);
        out[outOffset++] = (byte)(B >>> 16);
        out[outOffset++] = (byte)(B >>> 24);
        out[outOffset++] = (byte)C;
        out[outOffset++] = (byte)(C >>> 8);
        out[outOffset++] = (byte)(C >>> 16);
        out[outOffset++] = (byte)(C >>> 24);
        out[outOffset++] = (byte)D;
        out[outOffset++] = (byte)(D >>> 8);
        out[outOffset++] = (byte)(D >>> 16);
        out[outOffset] = (byte)(D >>> 24);
    }

    private final void generateSubKeys(byte[] key) {
        int len = key.length;
        int c = len / 4;
        int[] L = new int[c];
        int off = 0;
        int i = 0;
        while (i < c) {
            L[i] = key[off++] & 0xFF | (key[off++] & 0xFF) << 8 | (key[off++] & 0xFF) << 16 | (key[off++] & 0xFF) << 24;
            ++i;
        }
        this.S[0] = -1209970333;
        int i2 = 1;
        while (i2 <= 43) {
            this.S[i2] = this.S[i2 - 1] + -1640531527;
            ++i2;
        }
        int A = 0;
        int B = 0;
        int i3 = 0;
        int j = 0;
        int v = 132;
        int s = 1;
        while (s <= v) {
            A = this.S[i3] = RC6.rotl(this.S[i3] + A + B, 3);
            B = L[j] = RC6.rotl(L[j] + A + B, A + B);
            i3 = (i3 + 1) % 44;
            j = (j + 1) % c;
            ++s;
        }
    }

    private static int rotl(int val, int amount) {
        return val << amount | val >>> 32 - amount;
    }

    private static int rotr(int val, int amount) {
        return val >>> amount | val << 32 - amount;
    }

    public RC6() {
        super(16);
    }
}

