/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.udb.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.udb.IUDBConnector;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.exception.ASelectUDBException;
import org.aselect.system.sam.agent.SAMResource;

public class JNDIConnector
implements IUDBConnector {
    private static final String MODULE = "JNDIConnector";
    private ASelectSystemLogger _oASelectSystemLogger;
    private ASelectAuthenticationLogger _oASelectAuthenticationLogger;
    private Hashtable _htConfiguredAuthSPs;
    private String _sBaseDN;
    private String _sUserDN;
    private boolean _bFullUid;
    private String _sUDBResourceGroup;
    private ASelectSAMAgent _oASelectSAMAgent;
    private ASelectConfigManager _oASelectConfigManager;

    public void init(Object object) throws ASelectUDBException {
        String string = "init()";
        this._htConfiguredAuthSPs = new Hashtable();
        Object object2 = null;
        Object object3 = null;
        String string2 = null;
        try {
            this._oASelectSystemLogger = ASelectSystemLogger.getHandle();
            this._oASelectAuthenticationLogger = ASelectAuthenticationLogger.getHandle();
            this._oASelectConfigManager = ASelectConfigManager.getHandle();
            this._oASelectSAMAgent = ASelectSAMAgent.getHandle();
            this.readConfig(object);
            DirContext dirContext = this.getConnection();
            try {
                if (dirContext != null) {
                    dirContext.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object2 = this._oASelectConfigManager.getSection(null, "authsps");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config section 'authsps' found in main A-Select config", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            try {
                object3 = this._oASelectConfigManager.getSection(object2, "authsp");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config section 'authsps' found in main A-Select config", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            while (object3 != null) {
                try {
                    string2 = this._oASelectConfigManager.getParam(object3, "id");
                }
                catch (Exception exception) {
                    this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No config item 'id' found in 'authsp' section", (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
                this._htConfiguredAuthSPs.put(string2.toUpperCase(), string2);
                object3 = this._oASelectConfigManager.getNextSection(object3);
            }
        }
        catch (ASelectUDBException aSelectUDBException) {
            throw aSelectUDBException;
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize JNDI Connector", (Throwable)exception);
            throw new ASelectUDBException("0001", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getUserProfile(String string) {
        String string2 = "getUserProfile()";
        Context context = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = null;
        Attribute attribute = null;
        Attributes attributes = null;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        hashtable.put("result_code", "0003");
        try {
            CharSequence charSequence;
            int n;
            if (string.indexOf("*") >= 0 || string.indexOf("?") >= 0 || string.indexOf("=") >= 0) {
                StringBuffer stringBuffer2 = new StringBuffer("User id contains illegal characters: ");
                stringBuffer2.append(string);
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer2.toString());
                this.logAuthentication(string, "0002", "User unknown");
                throw new ASelectUDBException("0002");
            }
            if (!this._bFullUid && (n = string.indexOf(64)) > 0) {
                string = string.substring(0, n);
            }
            stringBuffer = new StringBuffer("(");
            stringBuffer.append(this._sUserDN);
            stringBuffer.append("=");
            stringBuffer.append(string);
            stringBuffer.append(")");
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            context = this.getConnection();
            try {
                namingEnumeration = context.search(this._sBaseDN, stringBuffer.toString(), searchControls);
            }
            catch (NamingException namingException) {
                StringBuffer stringBuffer3 = new StringBuffer("User unknown: ");
                stringBuffer3.append(string);
                stringBuffer3.append(namingException.getMessage());
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer3.toString(), (Throwable)namingException);
                this.logAuthentication(string, "0002", "User unknown");
                throw new ASelectUDBException("0002");
            }
            if (!namingEnumeration.hasMore()) {
                StringBuffer stringBuffer4 = new StringBuffer("User '");
                stringBuffer4.append(string);
                stringBuffer4.append("' not found during LDAP search. The filter was: ");
                stringBuffer4.append(stringBuffer.toString());
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer4.toString());
                this.logAuthentication(string, "0002", "User unknown");
                throw new ASelectUDBException("0002");
            }
            SearchResult searchResult = namingEnumeration.next();
            attributes = searchResult.getAttributes();
            Object object = attributes.getAll();
            while (object.hasMore()) {
                attribute = object.next();
                string3 = attribute.getID();
                try {
                    string4 = (String)attribute.get();
                }
                catch (Exception exception) {
                    string4 = "";
                }
                if (string4 == null) {
                    string4 = "";
                }
                hashtable3.put(string3.toUpperCase(), string4);
            }
            string4 = (String)hashtable3.get("ASELECTACCOUNTENABLED");
            if (string4 == null) {
                this.logAuthentication(string, "0008", "User account disabled");
                throw new ASelectUDBException("0008");
            }
            if (string4.equalsIgnoreCase("false")) {
                this.logAuthentication(string, "0008", "User account disabled");
                throw new ASelectUDBException("0008");
            }
            object = null;
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                String string5;
                object = (String)enumeration.nextElement();
                string4 = (String)hashtable3.get(object);
                if (!((String)object).startsWith("ASELECT") || !((String)object).endsWith("REGISTERED") || !string4.equalsIgnoreCase("TRUE")) continue;
                charSequence = ((String)object).substring(7, ((String)object).length() - 10);
                StringBuffer stringBuffer5 = new StringBuffer("ASELECT");
                stringBuffer5.append((String)charSequence);
                stringBuffer5.append("USERATTRIBUTES");
                string4 = (String)hashtable3.get(stringBuffer5.toString());
                if (string4 == null) {
                    string4 = "";
                }
                if ((string5 = (String)this._htConfiguredAuthSPs.get(charSequence)) == null) continue;
                hashtable2.put(string5, string4);
            }
            if (hashtable2.size() == 0) {
                charSequence = new StringBuffer("No user attributes found for user: ");
                charSequence.append(string);
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, charSequence.toString());
                throw new ASelectUDBException("0003");
            }
            hashtable.put("user_authsps", hashtable2);
            hashtable.put("result_code", "0000");
        }
        catch (ASelectUDBException aSelectUDBException) {
            hashtable.put("result_code", aSelectUDBException.getMessage());
        }
        catch (Exception exception) {
            StringBuffer stringBuffer6 = new StringBuffer("Failed to fetch profile of user ");
            stringBuffer6.append(string);
            stringBuffer6.append(": ");
            stringBuffer6.append(exception.getMessage());
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer6.toString(), (Throwable)exception);
            hashtable.put("result_code", "0060");
        }
        finally {
            try {
                if (namingEnumeration != null) {
                    namingEnumeration.close();
                }
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    public String getUserAttributes(String string, String string2) throws ASelectUDBException {
        String string3;
        block25: {
            String string4 = "getUserAttributes()";
            Context context = null;
            NamingEnumeration<SearchResult> namingEnumeration = null;
            String string5 = null;
            string3 = null;
            StringBuffer stringBuffer = null;
            Attribute attribute = null;
            Attributes attributes = null;
            try {
                int n;
                if (string.indexOf("*") >= 0 || string.indexOf("?") >= 0 || string.indexOf("=") >= 0) {
                    StringBuffer stringBuffer2 = new StringBuffer("User id contains illegal characters: '");
                    stringBuffer2.append(string).append("'");
                    this._oASelectSystemLogger.log(Level.FINE, MODULE, string4, stringBuffer2.toString());
                    String string6 = null;
                    return string6;
                }
                if (!this._bFullUid && (n = string.indexOf(64)) > 0) {
                    string = string.substring(0, n);
                }
                stringBuffer = new StringBuffer("(");
                stringBuffer.append(this._sUserDN);
                stringBuffer.append("=");
                stringBuffer.append(string);
                stringBuffer.append(")");
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                context = this.getConnection();
                try {
                    namingEnumeration = context.search(this._sBaseDN, stringBuffer.toString(), searchControls);
                }
                catch (NamingException namingException) {
                    StringBuffer stringBuffer3 = new StringBuffer("User unknown: ");
                    stringBuffer3.append(string);
                    stringBuffer3.append(namingException.getMessage());
                    this._oASelectSystemLogger.log(Level.FINE, MODULE, string4, stringBuffer3.toString(), (Throwable)namingException);
                    this.logAuthentication(string, "0002", "User unknown");
                    throw new ASelectUDBException("0002");
                }
                if (namingEnumeration.hasMore()) {
                    SearchResult searchResult = namingEnumeration.next();
                    attributes = searchResult.getAttributes();
                    boolean bl = false;
                    Object object = attributes.getAll();
                    while (object.hasMore() && !bl) {
                        attribute = object.next();
                        string5 = attribute.getID();
                        StringBuffer stringBuffer4 = new StringBuffer("ASELECT");
                        stringBuffer4.append(string2);
                        stringBuffer4.append("USERATTRIBUTES");
                        if (!string5.equalsIgnoreCase(stringBuffer4.toString())) continue;
                        try {
                            string3 = (String)attribute.get();
                        }
                        catch (Exception exception) {
                            StringBuffer stringBuffer5 = new StringBuffer("Error retrieving A-Select attributes value for authsp: '");
                            stringBuffer5.append(string2).append("', user: '");
                            stringBuffer5.append(string).append("'");
                            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string4, stringBuffer5.toString(), (Throwable)exception);
                        }
                        bl = true;
                    }
                    if (string3 == null) {
                        object = new StringBuffer("User attributes for AuthSP: '");
                        ((StringBuffer)object).append(string2).append("' not found for user: '");
                        ((StringBuffer)object).append(string).append("'");
                        this._oASelectSystemLogger.log(Level.FINE, MODULE, string4, ((StringBuffer)object).toString());
                    }
                    break block25;
                }
                StringBuffer stringBuffer6 = new StringBuffer("User '");
                stringBuffer6.append(string);
                stringBuffer6.append("' not found during LDAP search. The filter was: ");
                stringBuffer6.append(stringBuffer.toString());
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string4, stringBuffer6.toString());
            }
            catch (NamingException namingException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string4, "Could not execute JNDI query", (Throwable)namingException);
                throw new ASelectUDBException("0060", (Throwable)namingException);
            }
            catch (ASelectUDBException aSelectUDBException) {
                throw aSelectUDBException;
            }
            catch (ASelectSAMException aSelectSAMException) {
                throw new ASelectUDBException(aSelectSAMException.getMessage(), (Throwable)aSelectSAMException);
            }
            finally {
                try {
                    if (namingEnumeration != null) {
                        namingEnumeration.close();
                    }
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return string3;
    }

    public boolean isUserEnabled(String string) throws ASelectUDBException {
        boolean bl;
        block24: {
            String string2 = "isUserEnabled()";
            Context context = null;
            bl = false;
            NamingEnumeration<SearchResult> namingEnumeration = null;
            String string3 = null;
            String string4 = null;
            StringBuffer stringBuffer = null;
            Attribute attribute = null;
            Attributes attributes = null;
            try {
                int n;
                if (string.indexOf("*") >= 0 || string.indexOf("?") >= 0 || string.indexOf("=") >= 0) {
                    StringBuffer stringBuffer2 = new StringBuffer("User id contains illegal characters: '");
                    stringBuffer2.append(string).append("'");
                    this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer2.toString());
                    boolean bl2 = false;
                    return bl2;
                }
                if (!this._bFullUid && (n = string.indexOf(64)) > 0) {
                    string = string.substring(0, n);
                }
                stringBuffer = new StringBuffer("(");
                stringBuffer.append(this._sUserDN);
                stringBuffer.append("=");
                stringBuffer.append(string);
                stringBuffer.append(")");
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                context = this.getConnection();
                namingEnumeration = context.search(this._sBaseDN, stringBuffer.toString(), searchControls);
                if (namingEnumeration.hasMore()) {
                    SearchResult searchResult = namingEnumeration.next();
                    attributes = searchResult.getAttributes();
                    boolean bl3 = false;
                    Object object = attributes.getAll();
                    while (object.hasMore() && !bl3) {
                        attribute = object.next();
                        string3 = attribute.getID();
                        if (!string3.equalsIgnoreCase("ASELECTACCOUNTENABLED")) continue;
                        try {
                            string4 = (String)attribute.get();
                        }
                        catch (Exception exception) {
                            StringBuffer stringBuffer3 = new StringBuffer("Error retrieving A-Select account enabled attribute value for user '");
                            stringBuffer3.append(string).append("'");
                            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer3.toString(), (Throwable)exception);
                        }
                        if (string4 != null && string4.equalsIgnoreCase("true")) {
                            bl = true;
                            bl3 = true;
                            continue;
                        }
                        bl3 = true;
                    }
                    if (!bl) {
                        object = new StringBuffer("User not A-Select enabled: '");
                        ((StringBuffer)object).append(string).append("'");
                        this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, ((StringBuffer)object).toString(), (Throwable)new ASelectUDBException("0008"));
                    }
                    break block24;
                }
                StringBuffer stringBuffer4 = new StringBuffer("User '");
                stringBuffer4.append(string);
                stringBuffer4.append("' not found during LDAP search. The filter was: ");
                stringBuffer4.append(stringBuffer.toString());
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer4.toString());
            }
            catch (NamingException namingException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, "Could not execute JNDI query", (Throwable)namingException);
                throw new ASelectUDBException("0060", (Throwable)namingException);
            }
            catch (ASelectUDBException aSelectUDBException) {
                throw aSelectUDBException;
            }
            catch (ASelectSAMException aSelectSAMException) {
                throw new ASelectUDBException(aSelectSAMException.getMessage(), (Throwable)aSelectSAMException);
            }
            finally {
                try {
                    if (namingEnumeration != null) {
                        namingEnumeration.close();
                    }
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    private Hashtable createJNDIEnvironment(String string, String string2, String string3, String string4, String string5) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(11);
        hashtable.put("java.naming.factory.initial", string);
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", string2);
        hashtable.put("java.naming.security.credentials", string3);
        if (string4.equalsIgnoreCase("true")) {
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        hashtable.put("java.naming.provider.url", string5);
        return hashtable;
    }

    private void readConfig(Object object) throws ASelectUDBException {
        String string = "readConfig()";
        try {
            try {
                this._sBaseDN = this._oASelectConfigManager.getParam(object, "base_dn");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "No valid config item 'base_dn' found in connector configuration", (Throwable)aSelectConfigException);
                throw new ASelectUDBException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sUserDN = this._oASelectConfigManager.getParam(object, "user_dn");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "No valid config item 'user_dn' found in connector configuration", (Throwable)aSelectConfigException);
                throw new ASelectUDBException("4009", (Throwable)aSelectConfigException);
            }
            String string2 = null;
            try {
                string2 = this._oASelectConfigManager.getParam(object, "full_uid");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string2 = "false";
                this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No config item 'full_uid' found in connector configuration, using default: full_uid = " + string2, (Throwable)aSelectConfigException);
            }
            if (string2.equalsIgnoreCase("true")) {
                this._bFullUid = true;
            } else if (string2.equalsIgnoreCase("false")) {
                this._bFullUid = false;
            } else {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "No valid config item 'full_uid' found in connector configuration: " + string2);
                throw new ASelectUDBException("4009");
            }
            try {
                this._sUDBResourceGroup = this._oASelectConfigManager.getParam(object, "resourcegroup");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "No 'resourcegroup' config item found in udb 'connector' config section.", (Throwable)aSelectConfigException);
                throw new ASelectUDBException("4009", (Throwable)aSelectConfigException);
            }
        }
        catch (ASelectUDBException aSelectUDBException) {
            throw aSelectUDBException;
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Could not read the JNDI udb connector configuration", (Throwable)exception);
            throw new ASelectUDBException("4009", (Throwable)exception);
        }
    }

    private DirContext getConnection() throws ASelectUDBException, ASelectSAMException {
        String string = "getConnection()";
        SAMResource sAMResource = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        InitialDirContext initialDirContext = null;
        Object object = null;
        try {
            sAMResource = this._oASelectSAMAgent.getActiveResource(this._sUDBResourceGroup);
        }
        catch (ASelectSAMException aSelectSAMException) {
            StringBuffer stringBuffer = new StringBuffer("No active resource found in udb resourcegroup: ");
            stringBuffer.append(this._sUDBResourceGroup);
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)aSelectSAMException);
            throw aSelectSAMException;
        }
        object = sAMResource.getAttributes();
        try {
            string2 = this._oASelectConfigManager.getParam(object, "driver");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid config item 'driver' found in connector configuration", (Throwable)aSelectConfigException);
            throw new ASelectUDBException("4011", (Throwable)aSelectConfigException);
        }
        try {
            string3 = this._oASelectConfigManager.getParam(object, "security_principal_dn");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid config item 'security_principal_dn' found in connector resource configuration", (Throwable)aSelectConfigException);
            throw new ASelectUDBException("4011", (Throwable)aSelectConfigException);
        }
        try {
            string4 = this._oASelectConfigManager.getParam(object, "security_principal_password");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "Invalid or empty config item 'security_principal_password' found in connector resource configuration, using empty password.", (Throwable)aSelectConfigException);
        }
        try {
            string5 = this._oASelectConfigManager.getParam(object, "ssl");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid config item 'ssl' found in connector resource configuration", (Throwable)aSelectConfigException);
            throw new ASelectUDBException("4011", (Throwable)aSelectConfigException);
        }
        try {
            string6 = this._oASelectConfigManager.getParam(object, "url");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid config item 'url' found in connector resource configuration", (Throwable)aSelectConfigException);
            throw new ASelectUDBException("4011", (Throwable)aSelectConfigException);
        }
        try {
            initialDirContext = new InitialDirContext(this.createJNDIEnvironment(string2, string3, string4, string5, string6));
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "Could not create JNDI environment", (Throwable)exception);
            throw new ASelectUDBException("4006", (Throwable)exception);
        }
        return initialDirContext;
    }

    private void logAuthentication(String string, String string2, String string3) {
        this._oASelectAuthenticationLogger.log(new Object[]{MODULE, string, null, null, null, string3, string2});
    }
}

