/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.saml11;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.server.request.handler.saml11.common.AssertionSessionManager;
import org.aselect.system.exception.ASelectException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLBindingFactory;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.SAMLArtifact;

public class SAML11ArtifactRequestHandler
extends AbstractRequestHandler {
    private static final String MODULE = "SAML11ArtifactRequestHandler";
    private SAMLBinding _oSAMLBinding;
    private AssertionSessionManager _oAssertionSessionManager;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            super.init(servletConfig, object);
            this._oAssertionSessionManager = AssertionSessionManager.getHandle();
            this._oSAMLBinding = SAMLBindingFactory.getInstance((String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        SAMLRequest sAMLRequest = null;
        SAMLResponse sAMLResponse = null;
        SAMLArtifact sAMLArtifact = null;
        SAMLAssertion sAMLAssertion = null;
        try {
            httpServletResponse.setContentType("text/xml");
            String string2 = httpServletRequest.getRequestURL().toString();
            try {
                sAMLRequest = this._oSAMLBinding.receive((Object)httpServletRequest, 1);
            }
            catch (SAMLException sAMLException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not parse SAML request with SOAP binding", (Throwable)sAMLException);
                throw sAMLException;
            }
            StringBuffer stringBuffer = new StringBuffer("Retrieving SAML Artifact Request message:\r\n");
            stringBuffer.append(sAMLRequest.toString());
            this._systemLogger.log(Level.FINER, MODULE, string, stringBuffer.toString());
            Vector<SAMLAssertion> vector = new Vector<SAMLAssertion>();
            Iterator iterator = sAMLRequest.getArtifacts();
            while (iterator.hasNext()) {
                sAMLArtifact = (SAMLArtifact)iterator.next();
                sAMLAssertion = this._oAssertionSessionManager.getAssertion((Artifact)sAMLArtifact);
                if (sAMLAssertion == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No SAML Assertion available for the supplied artifact");
                    throw new SAMLException(SAMLException.REQUESTER, "No SAML Assertion available for the supplied artifact");
                }
                long l = sAMLAssertion.getNotBefore().getTime();
                long l2 = sAMLAssertion.getNotOnOrAfter().getTime();
                long l3 = System.currentTimeMillis();
                if (l3 > l && l3 <= l2) {
                    vector.add(sAMLAssertion);
                    this._oAssertionSessionManager.remove(sAMLArtifact);
                    continue;
                }
                this._systemLogger.log(Level.WARNING, MODULE, string, "SAML Assertion expired");
                throw new SAMLException(SAMLException.REQUESTER, "SAML Assertion expired");
            }
            sAMLResponse = new SAMLResponse(sAMLRequest.getId(), string2, vector, null);
            Vector<X509Certificate> vector2 = new Vector<X509Certificate>();
            vector2.add(this._configManager.getDefaultCertificate());
            sAMLResponse.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Key)this._configManager.getDefaultPrivateKey(), vector2);
            String string3 = sAMLResponse.toString();
            stringBuffer = new StringBuffer("Sending SAML Artifact Response message:\r\n");
            stringBuffer.append(string3);
            this._systemLogger.log(Level.FINER, MODULE, string, stringBuffer.toString());
            this._oSAMLBinding.respond((Object)httpServletResponse, sAMLResponse, null);
        }
        catch (SAMLException sAMLException) {
            this.respondError(httpServletResponse, sAMLRequest, sAMLException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process request", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return new RequestState(null);
    }

    public void destroy() {
    }

    private void respondError(HttpServletResponse httpServletResponse, SAMLRequest sAMLRequest, SAMLException sAMLException) throws ASelectException {
        String string = "respondError()";
        String string2 = null;
        try {
            if (sAMLRequest != null) {
                string2 = sAMLRequest.getId();
            }
            SAMLResponse sAMLResponse = new SAMLResponse(string2, null, null, sAMLException);
            this._oSAMLBinding.respond((Object)httpServletResponse, sAMLResponse, null);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not send failure over SAML binding", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }
}

