/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.saml11;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeDesignator;
import org.opensaml.SAMLAttributeQuery;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationQuery;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLAuthorizationDecisionQuery;
import org.opensaml.SAMLAuthorizationDecisionStatement;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLBindingFactory;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectQuery;
import org.opensaml.SAMLSubjectStatement;

public class SAML11QueryRequestHandler
extends AbstractRequestHandler {
    private static final String MODULE = "SAMLQueryRequestHandler";
    private static final String SESSION_ID_PREFIX = "saml11_";
    private SAMLBinding _oSAMLBinding;
    private String _sASelectServerID;
    private String _sAttributeNamespace;
    private long _lAssertionExpireTime;
    private Hashtable _htAuthenticationMethods;
    private TGTManager _oTGTManager;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            super.init(servletConfig, object);
            this._oTGTManager = TGTManager.getHandle();
            this._oSAMLBinding = SAMLBindingFactory.getInstance((String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'aselect' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sASelectServerID = this._configManager.getParam(object2, "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'server_id' in section 'aselect' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object3 = null;
            try {
                object3 = this._configManager.getSection(object, "assertion");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'expire' in 'assertion' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            String string2 = null;
            try {
                string2 = this._configManager.getParam(object3, "expire");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'expire' in 'assertion' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object4 = null;
            try {
                object4 = this._configManager.getSection(object, "attribute");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'attribute' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sAttributeNamespace = this._configManager.getParam(object4, "namespace");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'namespace' in 'attribute' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            long l = 0L;
            try {
                l = Long.parseLong(string2);
                this._lAssertionExpireTime = l * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Config item 'expire' in 'assertion' section isn't a number: " + string2);
                throw new ASelectException("4009", (Throwable)numberFormatException);
            }
            if (l < 1L) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Config item 'expire' in 'assertion' section must be higher than 0 and not: " + string2);
                throw new ASelectException("4009");
            }
            Object object5 = null;
            try {
                object5 = this._configManager.getSection(object, "authentication_methods");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'authentication_methods' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object6 = null;
            try {
                object6 = this._configManager.getSection(object5, "identifier");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Not one config section 'identifier' in section 'authentication_methods' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            this._htAuthenticationMethods = new Hashtable();
            while (object6 != null) {
                String string3 = null;
                try {
                    string3 = this._configManager.getParam(object6, "authsp_id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'authsp_id' in section 'identifier' found", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                String string4 = null;
                try {
                    string4 = this._configManager.getParam(object6, "uri");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'uri' in section 'identifier' found", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                this._htAuthenticationMethods.put(string3, string4);
                object6 = this._configManager.getNextSection(object6);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        SAMLRequest sAMLRequest = null;
        SAMLResponse sAMLResponse = null;
        SAMLSubjectQuery sAMLSubjectQuery = null;
        SAMLSubjectStatement sAMLSubjectStatement = null;
        try {
            Object object;
            httpServletResponse.setContentType("text/xml");
            try {
                sAMLRequest = this._oSAMLBinding.receive((Object)httpServletRequest, 1);
            }
            catch (SAMLException sAMLException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not parse SAML request with SOAP binding", (Throwable)sAMLException);
                throw sAMLException;
            }
            StringBuffer stringBuffer = new StringBuffer("Retrieving SAML Query Request message:\r\n");
            stringBuffer.append(sAMLRequest.toString());
            this._systemLogger.log(Level.FINER, MODULE, string, stringBuffer.toString());
            sAMLSubjectQuery = (SAMLSubjectQuery)sAMLRequest.getQuery();
            if (sAMLSubjectQuery == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not find a SAML subject Query in request");
                throw new SAMLException(SAMLException.REQUESTER, "No SAML subject Query in request");
            }
            SAMLSubject sAMLSubject = sAMLSubjectQuery.getSubject();
            boolean bl = false;
            Iterator iterator = sAMLSubject.getConfirmationMethods();
            while (iterator.hasNext() && !bl) {
                object = (String)iterator.next();
                if (((String)object).equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
                bl = true;
            }
            object = sAMLSubject.getNameIdentifier();
            String string2 = object.getNameQualifier();
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Wrong request, missing: name qualifier");
                throw new SAMLException(SAMLException.REQUESTER, "No name qualifier in request");
            }
            if (!string2.equals(this._sASelectServerID)) {
                StringBuffer stringBuffer2 = new StringBuffer("Wrong request, name qualifier is '");
                stringBuffer2.append(string2);
                stringBuffer2.append("', but must be: ");
                stringBuffer2.append(this._sASelectServerID);
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer2.toString());
                throw new SAMLException(SAMLException.REQUESTER, "Wrong name qualifier in request");
            }
            String string3 = object.getName();
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Wrong request, missing: name identifier");
                throw new SAMLException(SAMLException.REQUESTER, "No name identifier in request");
            }
            String string4 = SESSION_ID_PREFIX + string3;
            Hashtable hashtable = this._oTGTManager.getTGT(string4);
            if (hashtable == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No SAML session information found for name identifier: " + string3);
                throw new SAMLException(SAMLException.REQUESTER, "Unknown name identifier: " + string3);
            }
            long l = this._oTGTManager.getExpirationTime((Object)string4);
            if (l <= System.currentTimeMillis()) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "SAML session information expired for name identifier: " + string3);
                throw new SAMLException(SAMLException.REQUESTER, "A-Select TGT Expired");
            }
            String string5 = httpServletRequest.getRequestURL().toString();
            String string6 = httpServletRequest.getRemoteAddr();
            String string7 = httpServletRequest.getRemoteHost();
            if (sAMLSubjectQuery instanceof SAMLAuthenticationQuery) {
                sAMLSubjectStatement = this.handleAuthenticationQuery(hashtable, (SAMLAuthenticationQuery)sAMLSubjectQuery, string3, l, string6, string7);
            } else if (sAMLSubjectQuery instanceof SAMLAttributeQuery) {
                sAMLSubjectStatement = this.handleAttributeQuery(hashtable, (SAMLAttributeQuery)sAMLSubjectQuery, string3);
            } else if (sAMLSubjectQuery instanceof SAMLAuthorizationDecisionQuery) {
                sAMLSubjectStatement = this.handleAuthorizationDecisionQuery(hashtable, (SAMLAuthorizationDecisionQuery)sAMLSubjectQuery, string3);
            }
            sAMLResponse = this.generateSAMLResponse(sAMLRequest.getId(), string5, sAMLSubjectStatement);
            stringBuffer = new StringBuffer("Sending SAML Query Response message:\r\n");
            stringBuffer.append(sAMLResponse.toString());
            this._systemLogger.log(Level.FINER, MODULE, string, stringBuffer.toString());
            this._oSAMLBinding.respond((Object)httpServletResponse, sAMLResponse, null);
        }
        catch (SAMLException sAMLException) {
            this.respondError(httpServletResponse, sAMLRequest, sAMLException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process request", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return new RequestState(null);
    }

    public void destroy() {
    }

    private SAMLSubjectStatement handleAuthenticationQuery(Hashtable hashtable, SAMLAuthenticationQuery sAMLAuthenticationQuery, String string, long l, String string2, String string3) throws SAMLException {
        String string4 = "handleAuthenticationQuery()";
        String string5 = null;
        String string6 = null;
        SAMLAuthenticationStatement sAMLAuthenticationStatement = null;
        try {
            String string7;
            SAMLNameIdentifier sAMLNameIdentifier;
            Vector vector = (Vector)hashtable.get("authsps");
            if (vector == null || vector.isEmpty()) {
                this._systemLogger.log(Level.WARNING, MODULE, string4, "Invalid session for name identifier: " + string);
                throw new SAMLException(SAMLException.REQUESTER, "Invalid session for name identifier: " + string);
            }
            String string8 = sAMLAuthenticationQuery.getAuthMethod();
            if (string8 != null) {
                sAMLNameIdentifier = this._htAuthenticationMethods.keys();
                while (sAMLNameIdentifier.hasMoreElements() && string5 == null) {
                    string7 = (String)sAMLNameIdentifier.nextElement();
                    String string9 = (String)this._htAuthenticationMethods.get(string7);
                    if (!string9.equals(string8) || !vector.contains(string7)) continue;
                    string5 = string7;
                    string6 = string9;
                }
                if (string5 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, string4, "No AuthSP ID mapped to authentication method: " + string8);
                    throw new SAMLException(SAMLException.REQUESTER, "Unknown Authentication Method");
                }
            } else {
                string5 = (String)vector.lastElement();
                if (string5 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, string4, "Invalid session for name identifier: " + string);
                    throw new SAMLException(SAMLException.REQUESTER, "Invalid session for name identifier: " + string);
                }
                string6 = (String)this._htAuthenticationMethods.get(string5);
                if (string6 == null) {
                    this._systemLogger.log(Level.WARNING, MODULE, string4, "No authentication method configured for AuthSP ID: " + string5);
                    throw new SAMLException(SAMLException.RESPONDER, "Internal error: invalid configuration");
                }
            }
            sAMLNameIdentifier = new SAMLNameIdentifier(string, this._sASelectServerID, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            string7 = new SAMLSubject(sAMLNameIdentifier, null, null, null);
            string7.addConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:bearer");
            sAMLAuthenticationStatement = new SAMLAuthenticationStatement((SAMLSubject)string7, new Date(l), string2, string3, null);
        }
        catch (SAMLException sAMLException) {
            throw sAMLException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string4, "Could not handle SAML Authentication Query", (Throwable)exception);
            throw new SAMLException(SAMLException.RESPONDER, "Internal error", exception);
        }
        return sAMLAuthenticationStatement;
    }

    private SAMLSubjectStatement handleAttributeQuery(Hashtable hashtable, SAMLAttributeQuery sAMLAttributeQuery, String string) throws SAMLException {
        String string2 = "handleAttributeQuery()";
        SAMLAttributeStatement sAMLAttributeStatement = null;
        Hashtable hashtable2 = null;
        try {
            String string3;
            SAMLAttributeDesignator sAMLAttributeDesignator;
            Object object;
            Object object2;
            Hashtable hashtable3 = (Hashtable)hashtable.get("attributes");
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No attributes found for name identifier: " + string);
                throw new SAMLException(SAMLException.REQUESTER, "No attributes found for name identifier: " + string);
            }
            String string4 = sAMLAttributeQuery.getResource();
            if (string4 != null) {
                hashtable2 = (Hashtable)hashtable3.get(string4);
                if (hashtable2 == null) {
                    StringBuffer stringBuffer = new StringBuffer("Unknown resource (");
                    stringBuffer.append(string4);
                    stringBuffer.append(") for name identifier: ");
                    stringBuffer.append(string);
                    this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                    throw new SAMLException(SAMLException.REQUESTER, "Unknown resource: " + string4);
                }
            } else {
                hashtable2 = new Hashtable();
                object2 = hashtable3.elements();
                while (object2.hasMoreElements()) {
                    object = (Hashtable)object2.nextElement();
                    hashtable2.putAll(object);
                }
            }
            object2 = new Vector();
            object = sAMLAttributeQuery.getDesignators();
            if (!object.hasNext()) {
                sAMLAttributeDesignator = hashtable2.keys();
                while (sAMLAttributeDesignator.hasMoreElements()) {
                    string3 = (String)sAMLAttributeDesignator.nextElement();
                    Object v = hashtable2.get(string3);
                    SAMLAttribute sAMLAttribute = this.createSAMLAttribute(string3, v);
                    ((Vector)object2).add(sAMLAttribute);
                }
            } else {
                while (object.hasNext()) {
                    Object object3;
                    sAMLAttributeDesignator = (SAMLAttributeDesignator)object.next();
                    string3 = sAMLAttributeDesignator.getName();
                    if (!hashtable2.containsKey(string3)) {
                        object3 = new StringBuffer("Attribute '");
                        ((StringBuffer)object3).append(string3);
                        ((StringBuffer)object3).append("' not found for name identifier: ");
                        ((StringBuffer)object3).append(string);
                        this._systemLogger.log(Level.FINE, MODULE, string2, ((StringBuffer)object3).toString());
                        continue;
                    }
                    object3 = hashtable2.get(string3);
                    SAMLAttribute sAMLAttribute = this.createSAMLAttribute(string3, object3);
                    ((Vector)object2).add(sAMLAttribute);
                }
            }
            if (((Vector)object2).isEmpty()) {
                this._systemLogger.log(Level.FINE, MODULE, string2, "Requested attributes not found for name identifier: " + string);
                throw new SAMLException(SAMLException.REQUESTER, "Requested attributes not found for name identifier: " + string);
            }
            sAMLAttributeDesignator = new SAMLNameIdentifier(string, this._sASelectServerID, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            string3 = new SAMLSubject((SAMLNameIdentifier)sAMLAttributeDesignator, null, null, null);
            sAMLAttributeStatement = new SAMLAttributeStatement((SAMLSubject)string3, (Collection)object2);
        }
        catch (SAMLException sAMLException) {
            throw sAMLException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not handle SAML Attribute Query", (Throwable)exception);
            throw new SAMLException(SAMLException.RESPONDER, "Internal error", exception);
        }
        return sAMLAttributeStatement;
    }

    private SAMLSubjectStatement handleAuthorizationDecisionQuery(Hashtable hashtable, SAMLAuthorizationDecisionQuery sAMLAuthorizationDecisionQuery, String string) throws SAMLException {
        String string2 = "handleAuthorizationDecisionQuery()";
        SAMLAuthorizationDecisionStatement sAMLAuthorizationDecisionStatement = null;
        String string3 = null;
        try {
            SAMLAction sAMLAction;
            SAMLAction sAMLAction2;
            Hashtable hashtable2 = (Hashtable)hashtable.get("resources");
            if (hashtable2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No resources found for name identifier: " + string);
                throw new SAMLException(SAMLException.REQUESTER, "No resources found for name identifier: " + string);
            }
            String string4 = sAMLAuthorizationDecisionQuery.getResource();
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No resource found in request for name identifier: " + string);
                throw new SAMLException(SAMLException.REQUESTER, "No resource found in request");
            }
            Vector<SAMLAction> vector = new Vector<SAMLAction>();
            Iterator iterator = sAMLAuthorizationDecisionQuery.getActions();
            while (iterator.hasNext()) {
                sAMLAction2 = (SAMLAction)iterator.next();
                sAMLAction = new SAMLAction(sAMLAction2.getNamespace(), sAMLAction2.getData());
                vector.add(sAMLAction);
            }
            string3 = hashtable2.containsKey(string4) ? "Indeterminate" : "Deny";
            sAMLAction2 = new SAMLNameIdentifier(string, this._sASelectServerID, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            sAMLAction = new SAMLSubject((SAMLNameIdentifier)sAMLAction2, null, null, null);
            sAMLAuthorizationDecisionStatement = new SAMLAuthorizationDecisionStatement((SAMLSubject)sAMLAction, string4, string3, vector, null);
        }
        catch (SAMLException sAMLException) {
            throw sAMLException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not handle SAML Authorization Decision Query", (Throwable)exception);
            throw new SAMLException(SAMLException.RESPONDER, "Internal error", exception);
        }
        return sAMLAuthorizationDecisionStatement;
    }

    private SAMLResponse generateSAMLResponse(String string, String string2, SAMLSubjectStatement sAMLSubjectStatement) throws SAMLException {
        String string3 = "generateSAMLResponse()";
        SAMLResponse sAMLResponse = null;
        try {
            Vector<SAMLSubjectStatement> vector = new Vector<SAMLSubjectStatement>();
            vector.add(sAMLSubjectStatement);
            Date date = new Date(System.currentTimeMillis() + this._lAssertionExpireTime);
            SAMLAssertion sAMLAssertion = new SAMLAssertion(this._sASelectServerID, new Date(), date, null, null, vector);
            Vector<SAMLAssertion> vector2 = new Vector<SAMLAssertion>();
            vector2.add(sAMLAssertion);
            sAMLResponse = new SAMLResponse(string, string2, vector2, null);
            Vector<X509Certificate> vector3 = new Vector<X509Certificate>();
            vector3.add(this._configManager.getDefaultCertificate());
            sAMLResponse.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Key)this._configManager.getDefaultPrivateKey(), vector3);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "Could not create SAMLAttributeStatement", (Throwable)exception);
            throw new SAMLException(SAMLException.RESPONDER, "Internal error", exception);
        }
        return sAMLResponse;
    }

    private void respondError(HttpServletResponse httpServletResponse, SAMLRequest sAMLRequest, SAMLException sAMLException) throws ASelectException {
        String string = "respondError()";
        String string2 = null;
        try {
            if (sAMLRequest != null) {
                string2 = sAMLRequest.getId();
            }
            SAMLResponse sAMLResponse = new SAMLResponse(string2, null, null, sAMLException);
            this._oSAMLBinding.respond((Object)httpServletResponse, sAMLResponse, null);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not send failure over SAML binding", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private SAMLAttribute createSAMLAttribute(String string, Object object) throws ASelectException {
        String string2 = "generateSAMLAttribute()";
        SAMLAttribute sAMLAttribute = new SAMLAttribute();
        try {
            sAMLAttribute.setNamespace(this._sAttributeNamespace);
            sAMLAttribute.setName(string);
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    sAMLAttribute.addValue(enumeration.nextElement());
                }
            } else {
                sAMLAttribute.addValue(object);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not create a SAML attribute object", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return sAMLAttribute;
    }
}

