/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.saml11;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.application.ApplicationManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.server.request.handler.saml11.common.AssertionSessionManager;
import org.aselect.server.request.handler.saml11.websso.IWebSSOProfile;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.communication.client.raw.RawCommunicator;
import org.aselect.system.communication.client.soap11.SOAP11Communicator;
import org.aselect.system.communication.client.soap12.SOAP12Communicator;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;

public class SAML11RequestHandler
extends AbstractRequestHandler {
    private static final String MODULE = "SAML11RequestHandler";
    private static final String SESSION_ID_PREFIX = "saml11_";
    private IClientCommunicator _oClientCommunicator;
    private String _sDefaultWebSSOProfile;
    private Hashtable _htWebSSOProfiles;
    private Hashtable _htApplications;
    private AssertionSessionManager _oAssertionSessionManager;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        String string2 = null;
        long l = -1L;
        try {
            Object object2;
            Object object3;
            Object object4;
            super.init(servletConfig, object);
            String string3 = null;
            try {
                string3 = this._configManager.getParam(object, "clientcommunicator");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'clientcommunicator' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object5 = null;
            try {
                object5 = this._configManager.getSection(object, "assertion");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'expire' in 'assertion' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            String string4 = null;
            try {
                string4 = this._configManager.getParam(object5, "expire");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'expire' in 'assertion' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object6 = null;
            try {
                object6 = this._configManager.getSection(object, "attribute");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'attribute' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                string2 = this._configManager.getParam(object6, "namespace");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'namespace' in 'attribute' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            boolean bl = false;
            try {
                String string5 = this._configManager.getParam(object6, "send_statement");
                StringBuffer stringBuffer = new StringBuffer("Sending Attribute Statements directly in WebSSO response: ");
                if (string5.equalsIgnoreCase("TRUE")) {
                    stringBuffer.append("enabled");
                } else if (string5.equalsIgnoreCase("FALSE")) {
                    stringBuffer.append("disabled");
                } else {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid config item 'send_statement' in 'attribute' section found, must be 'true' or 'false' not: " + string5);
                    throw new ASelectException("4009");
                }
                this._systemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString());
                bl = new Boolean(string5);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'send_statement' in 'attribute' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            long l2 = 0L;
            try {
                l2 = Long.parseLong(string4);
                l = l2 * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Config item 'expire' in 'assertion' section isn't a number: " + string4);
                throw new ASelectException("4009", (Throwable)numberFormatException);
            }
            if (l2 < 1L) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Config item 'expire' in 'assertion' section must be higher than 0 and not: " + string4);
                throw new ASelectException("4009");
            }
            Object object7 = null;
            try {
                object7 = this._configManager.getSection(object, "websso");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'websso' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sDefaultWebSSOProfile = this._configManager.getParam(object7, "default");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'default' in 'websso' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object8 = null;
            try {
                object8 = this._configManager.getSection(object7, "profile");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'class' in 'profile' section found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            this._htWebSSOProfiles = new Hashtable();
            while (object8 != null) {
                object4 = null;
                try {
                    object4 = this._configManager.getParam(object8, "class");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'class' in 'profile' section found", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                object3 = null;
                object2 = null;
                try {
                    object3 = Class.forName((String)object4);
                    object2 = (IWebSSOProfile)((Class)object3).newInstance();
                }
                catch (Exception exception) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Not a correct 'IWebSSOProfile' class: " + (String)object4, (Throwable)exception);
                    throw new ASelectException("4009", (Throwable)exception);
                }
                object2.init(object8, l, string2, bl);
                if (this._htWebSSOProfiles.containsKey(object2.getID())) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "profile id is not unique: " + object2.getID());
                    throw new ASelectException("4009");
                }
                this._htWebSSOProfiles.put(object2.getID(), object2);
                object8 = this._configManager.getNextSection(object8);
            }
            object4 = null;
            try {
                object4 = this._configManager.getSection(object, "applications");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'applications' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            object3 = null;
            try {
                object3 = this._configManager.getSection(object4, "application");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'application' in section 'applications' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            this._htApplications = new Hashtable();
            while (object3 != null) {
                object2 = null;
                try {
                    object2 = this._configManager.getParam(object3, "id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'id' in 'application' section found", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                String string6 = null;
                try {
                    string6 = this._configManager.getParam(object3, "profile");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'profile' in 'application' section found", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                if (this._htApplications.containsKey(object2)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "application id is not unique: " + (String)object2);
                    throw new ASelectException("4009");
                }
                this._htApplications.put(object2, string6);
                object3 = this._configManager.getNextSection(object3);
            }
            object2 = null;
            try {
                object2 = this._configManager.getSection(object, "storagemanager", "id=assertions");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'storagemanager' with 'id=assertions' found", (Throwable)aSelectConfigException);
                throw new ASelectStorageException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._oAssertionSessionManager = AssertionSessionManager.getHandle();
                this._oAssertionSessionManager.init(object2);
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "AssertionSessionManager could not be initialized", (Throwable)aSelectException);
                throw new ASelectException("4009", (Throwable)aSelectException);
            }
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'clientcommunicator' found");
                throw new ASelectException("4009");
            }
            if (string3.equalsIgnoreCase("soap11")) {
                this._oClientCommunicator = new SOAP11Communicator("ASelect", (SystemLogger)this._systemLogger);
            } else if (string3.equalsIgnoreCase("soap12")) {
                this._oClientCommunicator = new SOAP12Communicator("ASelect", (SystemLogger)this._systemLogger);
            } else if (string3.equalsIgnoreCase("raw")) {
                this._oClientCommunicator = new RawCommunicator((SystemLogger)this._systemLogger);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        try {
            String string2 = httpServletRequest.getParameter("aselect_credentials");
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No parameter 'aselect_credentials' in request");
                throw new ASelectException("0001");
            }
            String string3 = httpServletRequest.getParameter("rid");
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No parameter 'rid' in request");
                throw new ASelectException("0001");
            }
            Hashtable hashtable = this.handleVerifyCredentials(string2, string3, httpServletRequest);
            if (hashtable.isEmpty()) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No response after 'verify_credentials' call");
                throw new ASelectException("0001");
            }
            Hashtable hashtable2 = this._oSessionManager.getSessionContext(SESSION_ID_PREFIX + string3);
            if (hashtable2 == null) {
                StringBuffer stringBuffer = new StringBuffer("No SAML session found with id: ");
                stringBuffer.append(SESSION_ID_PREFIX);
                stringBuffer.append(string3);
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
                throw new ASelectException("0001");
            }
            String string4 = (String)hashtable2.get("app_id");
            String string5 = null;
            string5 = (String)this._htApplications.get(string4);
            if (string5 == null) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Using default WebSSOProfile, because there was no profile configured for app_id: " + string4);
                string5 = this._sDefaultWebSSOProfile;
            }
            IWebSSOProfile iWebSSOProfile = null;
            iWebSSOProfile = (IWebSSOProfile)this._htWebSSOProfiles.get(string5);
            if (iWebSSOProfile == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No WebSSOProfile found with id: " + string5);
                throw new ASelectException("0001");
            }
            String string6 = httpServletRequest.getRemoteAddr();
            String string7 = httpServletRequest.getRemoteHost();
            iWebSSOProfile.process(hashtable, httpServletResponse, string6, string7);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process request", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return new RequestState(null);
    }

    public void destroy() {
        if (this._htWebSSOProfiles != null) {
            Enumeration enumeration = this._htWebSSOProfiles.elements();
            while (enumeration.hasMoreElements()) {
                IWebSSOProfile iWebSSOProfile = (IWebSSOProfile)enumeration.nextElement();
                iWebSSOProfile.destroy();
            }
        }
        if (this._oAssertionSessionManager != null) {
            this._oAssertionSessionManager.destroy();
        }
    }

    private Hashtable handleVerifyCredentials(String string, String string2, HttpServletRequest httpServletRequest) throws ASelectException {
        String string3 = "handleVerifyCredentials()";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        try {
            String string4;
            String string5 = httpServletRequest.getParameter("a-select-server");
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'a-select-server' in request");
                throw new ASelectException("0001");
            }
            String string6 = httpServletRequest.getRequestURL().toString();
            String string7 = httpServletRequest.getContextPath();
            String string8 = httpServletRequest.getServletPath();
            int n = string6.indexOf(string7);
            String string9 = string6.substring(0, n);
            StringBuffer stringBuffer = new StringBuffer(string9);
            stringBuffer.append(string7);
            stringBuffer.append(string8);
            hashtable.put("request", "verify_credentials");
            hashtable.put("aselect_credentials", string);
            hashtable.put("rid", string2);
            hashtable.put("a-select-server", string5);
            if (ApplicationManager.getHandle().isSigningRequired()) {
                CryptoEngine.getHandle().signRequest(hashtable);
            }
            if (!(string4 = (String)(hashtable2 = this._oClientCommunicator.sendMessage(hashtable, stringBuffer.toString())).get("result_code")).equals("0000")) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "A-Select Server returned error code: " + string4);
                throw new ASelectException("0001");
            }
            return hashtable2;
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string3, "Could not send 'verify_credentials' request", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }
}

