/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.saml11.common;

import java.util.logging.Level;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMAgent;
import org.aselect.system.storagemanager.StorageManager;
import org.opensaml.SAMLAssertion;
import org.opensaml.artifact.Artifact;

public class AssertionSessionManager
extends StorageManager {
    private static final String MODULE = "AssertionSessionManager";
    private static AssertionSessionManager _oAssertionSessionManager;
    private ASelectSystemLogger _systemLogger;

    public void init(Object object) throws ASelectStorageException {
        String string = "init()";
        try {
            this._systemLogger = ASelectSystemLogger.getHandle();
            ASelectConfigManager aSelectConfigManager = ASelectConfigManager.getHandle();
            ASelectSAMAgent aSelectSAMAgent = ASelectSAMAgent.getHandle();
            super.init(object, (ConfigManager)aSelectConfigManager, (SystemLogger)this._systemLogger, (SAMAgent)aSelectSAMAgent);
        }
        catch (ASelectStorageException aSelectStorageException) {
            throw aSelectStorageException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not send initialize", (Throwable)exception);
            throw new ASelectStorageException("0001", (Throwable)exception);
        }
    }

    public static AssertionSessionManager getHandle() {
        if (_oAssertionSessionManager == null) {
            _oAssertionSessionManager = new AssertionSessionManager();
        }
        return _oAssertionSessionManager;
    }

    public void putAssertion(Artifact artifact, SAMLAssertion sAMLAssertion) throws ASelectException {
        String string = "putAssertion()";
        try {
            if (this.containsKey(artifact)) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Session already exists with id: " + artifact.toString());
                throw new ASelectException("0001");
            }
            try {
                this.put(artifact, sAMLAssertion);
            }
            catch (ASelectStorageException aSelectStorageException) {
                if (aSelectStorageException.getMessage().equals("6010")) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Maximum number of request sessions reached", (Throwable)aSelectStorageException);
                    throw new ASelectException("0050", (Throwable)aSelectStorageException);
                }
                throw aSelectStorageException;
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not create session with session id: " + artifact.toString(), (Throwable)exception);
            throw new ASelectStorageException("0001", (Throwable)exception);
        }
    }

    public SAMLAssertion getAssertion(Artifact artifact) {
        String string = "getAssertion()";
        SAMLAssertion sAMLAssertion = null;
        try {
            sAMLAssertion = (SAMLAssertion)this.get(artifact);
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "No session context with id: " + artifact.toString(), (Throwable)aSelectStorageException);
        }
        return sAMLAssertion;
    }

    private AssertionSessionManager() {
    }
}

