/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.saml11.websso.profile;

import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.request.handler.saml11.common.AssertionSessionManager;
import org.aselect.server.request.handler.saml11.websso.AbstractWebSSOProfile;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.opensaml.SAMLAssertion;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.SAMLArtifact;
import org.opensaml.artifact.SAMLArtifactType0001;
import org.opensaml.artifact.SAMLArtifactType0002;
import org.opensaml.artifact.URI;
import org.opensaml.artifact.Util;

public class BrowserArtifact
extends AbstractWebSSOProfile {
    private static final String MODULE = "BrowserArtifact";
    private static final String ARTIFACTTYPE = "1";
    private int _iArtifactType;
    private String _sSourceLocation;
    private AssertionSessionManager _oAssertionSessionManager;
    private String _sIssuer;

    public void init(Object object, long l, String string, boolean bl) throws ASelectException {
        String string2 = "init()";
        try {
            this._oAssertionSessionManager = AssertionSessionManager.getHandle();
            super.init(object, l, string, bl);
            String string3 = null;
            try {
                string3 = this._configManager.getParam(object, "artifact");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No config item 'artifact' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(object, "artifact", "id=" + string3);
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("No config section 'artifact' found with id='");
                stringBuffer.append(string3);
                stringBuffer.append("'");
                this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            String string4 = null;
            try {
                string4 = this._configManager.getParam(object2, "type");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string2, "No config item 'type' in section 'artifact' found, using default type: 1", (Throwable)aSelectConfigException);
                string4 = ARTIFACTTYPE;
            }
            try {
                this._iArtifactType = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Config item 'type' in section 'artifact' isn't a number: " + string4, (Throwable)numberFormatException);
                throw new ASelectException("4009", (Throwable)numberFormatException);
            }
            if (this._iArtifactType != 1 && this._iArtifactType != 2) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Config item 'type' in section 'artifact' must be '1' or '2', not: " + this._iArtifactType);
                throw new ASelectException("4009");
            }
            if (this._iArtifactType == 2) {
                try {
                    this._sSourceLocation = this._configManager.getParam(object2, "sourcelocation");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string2, "No config item 'sourcelocation' in section 'artifact' found", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
            }
            this._systemLogger.log(Level.CONFIG, MODULE, string2, "Using artifact type: " + this._iArtifactType);
            try {
                this._sIssuer = this._configManager.getParam(object, "issuer");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No config item 'issuer' found", (Throwable)aSelectConfigException);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void process(Hashtable hashtable, HttpServletResponse httpServletResponse, String string, String string2) throws ASelectException {
        String string3 = "process()";
        SAMLArtifactType0001 sAMLArtifactType0001 = null;
        try {
            Object object;
            String string4 = (String)hashtable.get("rid");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'rid' found");
                throw new ASelectException("0001");
            }
            Hashtable hashtable2 = this._oSessionManager.getSessionContext("saml11_" + string4);
            if (hashtable2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No SAML Session available for rid: " + string4);
                throw new ASelectException("0001");
            }
            String string5 = (String)hashtable2.get("shire");
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'shire' found in session");
                throw new ASelectException("0001");
            }
            String string6 = (String)hashtable2.get("target");
            if (string6 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'target' found in session");
                throw new ASelectException("0001");
            }
            String string7 = (String)hashtable2.get("providerId");
            if (string7 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'providerId' found in session");
                throw new ASelectException("0001");
            }
            String string8 = this._sIssuer;
            if (string8 == null && (string8 = (String)hashtable.get("organization")) == null) {
                this._systemLogger.log(Level.FINE, MODULE, string3, "No parameter 'organization' found in result from verify_credentials");
                string8 = this._sASelectServerID;
            }
            string8 = URLEncoder.encode(string8, "UTF-8");
            string8 = string8.replaceAll("\\+", "%20");
            String string9 = null;
            if (this._iArtifactType == 1) {
                object = Util.generateSourceId((String)this._sASelectServerID);
                sAMLArtifactType0001 = new SAMLArtifactType0001(object);
                string9 = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
            } else if (this._iArtifactType == 2) {
                object = new URI(this._sSourceLocation);
                sAMLArtifactType0001 = new SAMLArtifactType0002((URI)object);
                string9 = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
            }
            if (this._oAssertionSessionManager.containsKey(sAMLArtifactType0001)) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "Artifact already exists in Artifact Session Manager");
                throw new ASelectException("0001");
            }
            object = (String)hashtable.get("uid");
            if (object == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'uid' found");
                throw new ASelectException("0001");
            }
            SAMLAssertion sAMLAssertion = this.createSAMLAssertion((String)object, string7, hashtable, string, string2, string9, string8);
            this._systemLogger.log(Level.FINER, MODULE, string3, "Storing SAML assertion: " + sAMLAssertion.toString());
            this._oAssertionSessionManager.putAssertion((Artifact)sAMLArtifactType0001, sAMLAssertion);
            this.send(httpServletResponse, (SAMLArtifact)sAMLArtifactType0001, string5, string6);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string3, "Could not process", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void destroy() {
    }

    private void send(HttpServletResponse httpServletResponse, SAMLArtifact sAMLArtifact, String string, String string2) throws ASelectException {
        String string3 = "send()";
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append("?TARGET=");
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append("&SAMLart=");
            stringBuffer.append(URLEncoder.encode(sAMLArtifact.encode(), "UTF-8"));
            StringBuffer stringBuffer2 = new StringBuffer("Sending to '");
            stringBuffer2.append(string);
            stringBuffer2.append("' SAML Artifact message:\r\n");
            stringBuffer2.append(sAMLArtifact.toString());
            this._systemLogger.log(Level.FINER, MODULE, string3, stringBuffer2.toString());
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string3, "Could not send SAML Artifact", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }
}

