/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.saml11.websso.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.request.handler.saml11.websso.AbstractWebSSOProfile;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Base64;
import org.aselect.system.utils.Utils;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLResponse;

public class BrowserPost
extends AbstractWebSSOProfile {
    private static final String MODULE = "BrowserPost";
    private String _sTemplate;
    private String _sIssuer;

    public void init(Object object, long l, String string, boolean bl) throws ASelectException {
        String string2 = "init()";
        try {
            super.init(object, l, string, bl);
            String string3 = null;
            try {
                string3 = this._configManager.getParam(object, "template");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No config item 'template' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            String string4 = this._configManager.getWorkingdir();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string4);
            if (!string4.endsWith(File.separator)) {
                stringBuffer.append(File.separator);
            }
            stringBuffer.append("conf");
            stringBuffer.append(File.separator);
            stringBuffer.append("html");
            stringBuffer.append(File.separator);
            stringBuffer.append(string3);
            File file = new File(stringBuffer.toString());
            if (!file.exists()) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Configured template does not exists: " + stringBuffer.toString());
                throw new ASelectException("4009");
            }
            this._sTemplate = this.readTemplate(file);
            try {
                this._sIssuer = this._configManager.getParam(object, "issuer");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No config item 'issuer' found", (Throwable)aSelectConfigException);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void process(Hashtable hashtable, HttpServletResponse httpServletResponse, String string, String string2) throws ASelectException {
        String string3 = "process()";
        try {
            String string4 = (String)hashtable.get("rid");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'rid' found");
                throw new ASelectException("0001");
            }
            Hashtable hashtable2 = this._oSessionManager.getSessionContext("saml11_" + string4);
            if (hashtable2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No SAML Session available for rid: " + string4);
                throw new ASelectException("0001");
            }
            String string5 = (String)hashtable2.get("shire");
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'shire' found in session");
                throw new ASelectException("0001");
            }
            String string6 = (String)hashtable2.get("target");
            if (string6 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'target' found in session");
                throw new ASelectException("0001");
            }
            String string7 = (String)hashtable.get("uid");
            if (string7 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'uid' found");
                throw new ASelectException("0001");
            }
            String string8 = (String)hashtable2.get("providerId");
            if (string8 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "No parameter 'providerId' found in session");
                throw new ASelectException("0001");
            }
            String string9 = this._sIssuer;
            if (string9 == null && (string9 = (String)hashtable.get("organization")) == null) {
                this._systemLogger.log(Level.FINE, MODULE, string3, "No parameter 'organization' found in result from verify_credentials");
                string9 = this._sASelectServerID;
            }
            string9 = URLEncoder.encode(string9, "UTF-8");
            string9 = string9.replaceAll("\\+", "%20");
            SAMLAssertion sAMLAssertion = this.createSAMLAssertion(string7, string8, hashtable, string, string2, "urn:oasis:names:tc:SAML:1.0:cm:bearer", string9);
            Vector<SAMLAssertion> vector = new Vector<SAMLAssertion>();
            vector.add(sAMLAssertion);
            SAMLResponse sAMLResponse = new SAMLResponse(null, string5, vector, null);
            Vector<X509Certificate> vector2 = new Vector<X509Certificate>();
            vector2.add(this._configManager.getDefaultCertificate());
            sAMLResponse.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Key)this._configManager.getDefaultPrivateKey(), vector2);
            this.send(httpServletResponse, sAMLResponse, string5, string6);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string3, "Could not process", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void destroy() {
    }

    private void send(HttpServletResponse httpServletResponse, SAMLResponse sAMLResponse, String string, String string2) throws ASelectException {
        String string3 = "send()";
        PrintWriter printWriter = null;
        String string4 = null;
        try {
            httpServletResponse.setContentType("text/html");
            printWriter = httpServletResponse.getWriter();
            string4 = this._sTemplate;
            string4 = Utils.replaceString((String)string4, (String)"[action]", (String)string);
            string4 = Utils.replaceString((String)string4, (String)"[target]", (String)string2);
            String string5 = sAMLResponse.toString();
            StringBuffer stringBuffer = new StringBuffer("Sending Browser/Post to '");
            stringBuffer.append(string);
            this._systemLogger.log(Level.FINE, MODULE, string3, stringBuffer.toString());
            StringBuffer stringBuffer2 = new StringBuffer("SAML Browser/Post response message:\r\n");
            stringBuffer2.append(string5);
            this._systemLogger.log(Level.FINER, MODULE, string3, stringBuffer2.toString());
            String string6 = Base64.encode((byte[])string5.getBytes("ASCII"));
            string4 = Utils.replaceString((String)string4, (String)"[samlresponse]", (String)string6);
            printWriter.print(string4);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string3, "Could not send SAMLResponse", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private String readTemplate(File file) throws ASelectException {
        String string = "readTemplate()";
        BufferedReader bufferedReader = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not read template", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Could not close BufferedReader", (Throwable)iOException);
            }
        }
        return stringBuffer.toString();
    }
}

