/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.logging;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.logging.SystemLogger;

public class AuthenticationLogger {
    private final String MODULE = "AuthenticationLogger";
    private final String DELIMITER = ",";
    private String _sLogComponent;
    private String _sDelimiter;
    private boolean _bLogToDatabase = false;
    private String _sUrl;
    private String _sDriver;
    private String _sUser;
    private String _sPassword;
    private String _sTableName;
    private StringBuffer _sbPreparedQuery;
    private Vector _vColumnNames = null;
    private Vector _vColumnTypes = null;
    private static Connection _conn = null;
    private SystemLogger _systemLogger = null;

    public void init(String string, String string2, String string3, ConfigManager configManager, Object object, SystemLogger systemLogger, String string4) throws ASelectException {
        String string5 = "init()";
        try {
            this._bLogToDatabase = false;
            this._sLogComponent = string;
            if (this._sLogComponent == null) {
                this._sLogComponent = "";
            }
            try {
                this._sDelimiter = configManager.getParam(object, "delimiter");
            }
            catch (Exception exception) {
                this._sDelimiter = ",";
                StringBuffer stringBuffer = new StringBuffer("No valid config item: 'delimiter' in config section 'target' found, using default value: ");
                stringBuffer.append(this._sDelimiter);
                systemLogger.log(Level.CONFIG, "AuthenticationLogger", string5, stringBuffer.toString(), exception);
            }
            this._systemLogger = new SystemLogger();
            this._systemLogger.init(string2, string3, configManager, object, string4);
        }
        catch (Exception exception) {
            systemLogger.log(Level.CONFIG, "AuthenticationLogger", string5, "Could not initialize Authentication Logger", exception);
            throw new ASelectException("0001", exception);
        }
    }

    public void init(String string, ConfigManager configManager, Object object, SystemLogger systemLogger) throws ASelectException {
        String string2 = "init()";
        try {
            this._sDelimiter = ",";
            this._sLogComponent = string;
            if (this._sLogComponent == null) {
                this._sLogComponent = "";
            }
            this._systemLogger = systemLogger;
            this.readConfig(configManager, object);
            try {
                this.connect();
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Could not connect with logger back-end: ");
                stringBuffer.append(this._sUrl);
                throw new ASelectException(stringBuffer.toString(), exception);
            }
            this._vColumnTypes = this.retrieveColumnTypes();
            this._sbPreparedQuery = this.createStatementQuery();
            this._bLogToDatabase = true;
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "AuthenticationLogger", string2, "Error during initialize", exception);
            throw new ASelectException("0001", exception);
        }
    }

    public void log(String string, String string2, String string3, String string4, String string5) {
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        this.log(objectArray);
    }

    public void log(String string) {
        Object[] objectArray = null;
        if (this._bLogToDatabase) {
            int n = this._vColumnNames.size();
            objectArray = new Object[n];
            objectArray[n] = string;
            this.log(objectArray);
        } else {
            objectArray = new Object[]{string};
            this.log(objectArray);
        }
    }

    public void log(Object[] objectArray) {
        if (objectArray != null) {
            if (this._bLogToDatabase) {
                try {
                    this.logToDB(objectArray);
                }
                catch (Exception exception) {
                    try {
                        this._systemLogger.log(Level.WARNING, "AuthenticationLogger", "log()", "Logging to database failed (first try), retrying.");
                        this.connect();
                        this.logToDB(objectArray);
                    }
                    catch (Exception exception2) {
                        this._systemLogger.log(Level.WARNING, "AuthenticationLogger", "log()", "Logging to database failed (second try) using back-up logger.");
                        this.logToFile(objectArray);
                    }
                }
            } else {
                this.logToFile(objectArray);
            }
        }
    }

    public void closeHandlers() {
        if (!this._bLogToDatabase && this._systemLogger != null) {
            this._systemLogger.closeHandlers();
        }
        this.disconnect();
    }

    private void logToFile(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(this._sLogComponent);
        stringBuffer.append(this._sDelimiter);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            String string = "";
            if (object instanceof String) {
                string = (String)object;
            }
            stringBuffer.append(string);
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(this._sDelimiter);
        }
        this._systemLogger.log(Level.INFO, stringBuffer.toString());
    }

    private void logToDB(Object[] objectArray) throws ASelectException {
        String string = "logToDB";
        Statement statement = null;
        try {
            Object object;
            int n;
            int n2 = objectArray.length;
            int n3 = n2 + 1;
            int n4 = this._vColumnTypes.size();
            StringBuffer stringBuffer = new StringBuffer();
            if (n3 > n4) {
                for (n = n4 - 1; n < n3; ++n) {
                    Object object2 = objectArray[n - 1];
                    object = "";
                    if (object2 instanceof String) {
                        object = (String)object2;
                    }
                    stringBuffer.append((String)object);
                    if (n + 1 >= n3) continue;
                    stringBuffer.append(",");
                }
            }
            statement = _conn.prepareStatement(this._sbPreparedQuery.toString());
            for (n = 1; n <= n4; ++n) {
                int n5 = (Integer)this._vColumnTypes.get(n - 1);
                if (n <= n3) {
                    object = null;
                    object = n == 1 ? this._sLogComponent : (n4 == n && n3 > n4 ? stringBuffer.toString() : objectArray[n - 2]);
                    try {
                        statement.setObject(n, object, n5);
                    }
                    catch (Exception exception) {
                        statement.setNull(n, n5);
                        StringBuffer stringBuffer2 = new StringBuffer("Could not write object: '");
                        stringBuffer2.append(object);
                        stringBuffer2.append("' to column '");
                        stringBuffer2.append(n);
                        stringBuffer2.append("' of database table: ");
                        stringBuffer2.append(this._sTableName);
                        this._systemLogger.log(Level.FINE, "AuthenticationLogger", string, stringBuffer2.toString());
                    }
                    continue;
                }
                statement.setNull(n, n5);
            }
            statement.executeUpdate();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this._systemLogger.log(Level.WARNING, "AuthenticationLogger", string, "Internal error: Array index out of bounds", arrayIndexOutOfBoundsException);
            throw new ASelectException("5004", arrayIndexOutOfBoundsException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, "AuthenticationLogger", string, "Internal error", exception);
            throw new ASelectException("5004", exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private synchronized void connect() throws Exception {
        try {
            _conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _conn = null;
        _conn = DriverManager.getConnection(this._sUrl, this._sUser, this._sPassword);
    }

    private synchronized void disconnect() {
        String string = new String("disconnect()");
        try {
            if (this._bLogToDatabase && _conn != null) {
                _conn.close();
            }
        }
        catch (SQLException sQLException) {
            this.altLog(string, "Database Error" + sQLException.getMessage());
        }
        catch (Exception exception) {
            this.altLog(string, "Internal Error" + exception.getMessage());
        }
        _conn = null;
    }

    private void altLog(String string, String string2) {
        if (this._systemLogger == null) {
            System.err.println("[" + this.getTimestamp() + "] " + "AuthenticationLogger" + "." + string + " -> " + string2);
        } else {
            this._systemLogger.log(Level.SEVERE, "AuthenticationLogger", string, string2);
        }
    }

    private String getTimestamp() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(calendar.get(1)).append("-");
        int n = calendar.get(2) + 1;
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n).append("-");
        n = calendar.get(5);
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n).append(" ");
        n = calendar.get(11);
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n).append(":");
        n = calendar.get(12);
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n).append(":");
        n = calendar.get(13);
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    private void readConfig(ConfigManager configManager, Object object) throws ASelectException {
        String string = "readConfig()";
        Object object2 = null;
        Object object3 = null;
        try {
            try {
                this._sUrl = configManager.getParam(object, "url");
            }
            catch (Exception exception) {
                throw new ASelectException("No valid 'url' config item found in logging 'target' section");
            }
            try {
                this._sDriver = configManager.getParam(object, "driver");
            }
            catch (Exception exception) {
                throw new ASelectException("No valid 'driver' config item found in logging 'target' section");
            }
            try {
                Class.forName(this._sDriver);
            }
            catch (Exception exception) {
                throw new ASelectException("Could not initialize driver that is configured int the 'back-end' in logger section", exception);
            }
            try {
                this._sUser = configManager.getParam(object, "user");
            }
            catch (Exception exception) {
                throw new ASelectException("No valid 'user' config item found in logging 'target' section");
            }
            try {
                this._sPassword = configManager.getParam(object, "password");
            }
            catch (Exception exception) {
                this._sPassword = "";
                this._systemLogger.log(Level.CONFIG, "AuthenticationLogger", string, "Invalid or empty 'password' config item found, using empty password", exception);
            }
            try {
                object2 = configManager.getSection(object, "table");
            }
            catch (Exception exception) {
                throw new Exception("Could not find the 'table' config section in logger 'target' section");
            }
            try {
                this._sTableName = configManager.getParam(object2, "name");
            }
            catch (Exception exception) {
                throw new ASelectException("No valid 'name' config item found in 'table' section", exception);
            }
            this._vColumnNames = new Vector();
            try {
                object3 = configManager.getSection(object2, "column");
            }
            catch (Exception exception) {
                throw new ASelectException("Not one valid 'column' config item found in 'table' section", exception);
            }
            while (object3 != null) {
                String string2 = null;
                try {
                    string2 = configManager.getParam(object3, "name");
                }
                catch (Exception exception) {
                    throw new ASelectException("Not one valid 'name' config item found in 'column' section", exception);
                }
                this._vColumnNames.add(string2);
                object3 = configManager.getNextSection(object3);
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, "AuthenticationLogger", string, "Error reading config", aSelectException);
            throw new ASelectException("4009", aSelectException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "AuthenticationLogger", string, "Internal error", exception);
            throw new ASelectException("0001", exception);
        }
    }

    private Vector retrieveColumnTypes() throws ASelectException {
        String string = "retrieveColumnTypes()";
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        Vector<Integer> vector = new Vector<Integer>();
        try {
            statement = _conn.createStatement();
            StringBuffer stringBuffer = new StringBuffer("SELECT * FROM ");
            stringBuffer.append(this._sTableName);
            try {
                resultSet = statement.executeQuery(stringBuffer.toString());
            }
            catch (Exception exception) {
                StringBuffer stringBuffer2 = new StringBuffer("Could not execute query:");
                stringBuffer2.append(stringBuffer.toString());
                throw new ASelectException(stringBuffer2.toString(), exception);
            }
            try {
                resultSetMetaData = resultSet.getMetaData();
            }
            catch (Exception exception) {
                throw new ASelectException("Could not resolve meta data", exception);
            }
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (!this._vColumnNames.contains(resultSetMetaData.getColumnName(i))) continue;
                vector.add(new Integer(resultSetMetaData.getColumnType(i)));
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, "AuthenticationLogger", string, "Error retreiving ColumnTypes", aSelectException);
            throw new ASelectException("4009", aSelectException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, "AuthenticationLogger", string, "Internal error", exception);
            throw new ASelectException("0001", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
        return vector;
    }

    private StringBuffer createStatementQuery() throws ASelectException {
        String string = "createStatementQuery()";
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(this._sTableName);
            stringBuffer.append(" (");
            for (int i = 0; i < this._vColumnTypes.size(); ++i) {
                stringBuffer.append(this._vColumnNames.get(i)).append(",");
            }
            String string2 = stringBuffer.toString();
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            string2 = string2 + ") ";
            stringBuffer = new StringBuffer(string2);
            stringBuffer.append(" VALUES (");
            for (int i = 0; i < this._vColumnTypes.size() - 1; ++i) {
                stringBuffer.append("?,");
            }
            stringBuffer.append("?)");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "AuthenticationLogger", string, "Internal error", exception);
            throw new ASelectException("0001", exception);
        }
        return stringBuffer;
    }
}

