/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.logging;

import java.io.File;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectException;

public class SystemLogger {
    private final String MODULE = "SystemLogger";
    private static final int MAXLOGSIZE = 307200;
    private static final int LOGFILES = 4;
    private Logger _oLogger;
    private boolean _bDebug = false;

    public void init(String string, String string2, String string3, int n, int n2) throws Exception {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append(File.separator).append(string2).append("%g.log");
            FileHandler fileHandler = new FileHandler(stringBuffer.toString(), n, n2, true);
            fileHandler.setFormatter(new SystemLogFormatter());
            fileHandler.setLevel(Level.ALL);
            this._oLogger = Logger.getLogger(string3);
            this._oLogger.addHandler(fileHandler);
            this.setLevel(Level.FINE);
        }
        catch (Exception exception) {
            System.err.println("SystemLogger: could not initialize logger -> " + exception.getMessage());
            throw exception;
        }
    }

    public void init(String string, String string2, ConfigManager configManager, Object object, String string3) throws ASelectException {
        String string4 = "init()";
        int n = -1;
        int n2 = -1;
        StringBuffer stringBuffer = null;
        try {
            Object object2;
            Object object3;
            Comparable<StringBuffer> comparable;
            if (object == null) {
                this.log(Level.CONFIG, "SystemLogger", string4, "No valid config section supplied, using default logging settings.");
                n = 307200;
                n2 = 4;
                stringBuffer = new StringBuffer(string3);
                stringBuffer.append(File.separator);
                stringBuffer.append("log");
                stringBuffer.append(File.separator);
            } else {
                try {
                    n = new Integer(configManager.getParam(object, "max_file_size"));
                }
                catch (Exception exception) {
                    n = 307200;
                    comparable = new StringBuffer("No valid config item: 'max_file_size' in config section 'target' found, using default value: ");
                    ((StringBuffer)comparable).append(n);
                    this.log(Level.CONFIG, "SystemLogger", string4, ((StringBuffer)comparable).toString(), exception);
                }
                try {
                    n2 = new Integer(configManager.getParam(object, "nr_of_files"));
                }
                catch (Exception exception) {
                    n2 = 4;
                    comparable = new StringBuffer("No valid config item: 'nr_of_files' in config section 'target' found, using default value: ");
                    ((StringBuffer)comparable).append(n2);
                    this.log(Level.CONFIG, "SystemLogger", string4, ((StringBuffer)comparable).toString(), exception);
                }
                try {
                    object3 = configManager.getParam(object, "directory");
                    if (!((String)object3).endsWith(File.separator)) {
                        object3 = (String)object3 + File.separator;
                    }
                    if (!((File)(comparable = new File((String)object3))).exists()) {
                        object2 = new StringBuffer("The configured system logging dir doesn't exist, try to create directory: ");
                        ((StringBuffer)object2).append((String)object3);
                        this.log(Level.INFO, "SystemLogger", string4, ((StringBuffer)object2).toString());
                        if (!((File)comparable).mkdirs()) {
                            throw new ASelectException("4006");
                        }
                    }
                    stringBuffer = new StringBuffer((String)object3);
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer(string3);
                    stringBuffer.append(File.separator);
                    stringBuffer.append("log");
                    stringBuffer.append(File.separator);
                    comparable = new StringBuffer("No valid config item: 'directory' in config section 'target' found, using default directory: ");
                    ((StringBuffer)comparable).append(stringBuffer.toString());
                    this.log(Level.CONFIG, "SystemLogger", string4, ((StringBuffer)comparable).toString(), exception);
                }
            }
            stringBuffer.append(string);
            object3 = new File(stringBuffer.toString());
            if (!((File)object3).exists()) {
                comparable = new StringBuffer("System logging dir doesn't exist, try to create directory: ");
                ((StringBuffer)comparable).append(stringBuffer.toString());
                this.log(Level.INFO, "SystemLogger", string4, ((StringBuffer)comparable).toString());
                if (!((File)object3).mkdirs()) {
                    object2 = new StringBuffer("Could not access the system logging directory: ");
                    ((StringBuffer)object2).append(stringBuffer.toString());
                    this.log(Level.WARNING, "SystemLogger", string4, ((StringBuffer)object2).toString());
                    throw new ASelectException("4006");
                }
            }
            comparable = new StringBuffer(stringBuffer.toString());
            ((StringBuffer)comparable).append(File.separator);
            ((StringBuffer)comparable).append(string);
            ((StringBuffer)comparable).append("%g.log");
            object2 = new FileHandler(((StringBuffer)comparable).toString(), n, n2, true);
            ((Handler)object2).setFormatter(new SystemLogFormatter());
            ((Handler)object2).setLevel(Level.ALL);
            this._oLogger = Logger.getLogger(string2 + "." + this.hashCode());
            this._oLogger.addHandler((Handler)object2);
            this.setLevel(Level.FINE);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this.log(Level.CONFIG, "SystemLogger", string4, "Could not initialize System Logger", exception);
            throw new ASelectException("0001", exception);
        }
    }

    public void log(Level level, String string) {
        try {
            this._oLogger.log(level, string);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(new Date().toString()).append("] ");
            stringBuffer.append(string);
            System.err.println(stringBuffer);
        }
    }

    public void log(Level level, String string, Throwable throwable) {
        try {
            this._oLogger.log(level, string, throwable);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(new Date().toString()).append("] ");
            stringBuffer.append(string);
            stringBuffer.append(", cause: ");
            stringBuffer.append(throwable.getMessage());
            System.err.println(stringBuffer);
        }
    }

    public void log(Level level, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        stringBuffer.append(" -> ");
        stringBuffer.append(string3);
        this.log(level, stringBuffer.toString());
    }

    public void log(Level level, String string, String string2, String string3, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        stringBuffer.append(" -> ");
        stringBuffer.append(string3);
        this.log(level, stringBuffer.toString(), throwable);
    }

    public void setDebug(boolean bl) {
        this._oLogger.setUseParentHandlers(bl);
    }

    public void setLevel(Level level) {
        this._bDebug = level.intValue() < Level.FINER.intValue();
        this._oLogger.setUseParentHandlers(this._bDebug);
        this._oLogger.setLevel(level);
    }

    public void closeHandlers() {
        if (this._oLogger != null) {
            Handler[] handlerArray = this._oLogger.getHandlers();
            for (int i = 0; i < handlerArray.length; ++i) {
                if (handlerArray[i] instanceof FileHandler) {
                    FileHandler fileHandler = (FileHandler)handlerArray[i];
                    fileHandler.close();
                }
                this._oLogger.removeHandler(handlerArray[i]);
            }
        }
    }

    public boolean isDebug() {
        return this._bDebug;
    }

    public static String formatDetailedError(String string, String string2, Exception exception, String string3) {
        StackTraceElement[] stackTraceElementArray;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string).append(".");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("::").append(string3).append(": ");
        String string4 = exception.getClass().getName();
        stringBuffer.append(string4.substring(string4.lastIndexOf(".") + 1));
        if (exception.getMessage() != null) {
            stringBuffer.append(" \"").append(exception.getMessage()).append("\"");
        }
        if ((stackTraceElementArray = exception.getStackTrace()) != null && stackTraceElementArray.length > 0) {
            stringBuffer.append(" at ");
            String string5 = stackTraceElementArray[0].getClassName();
            String string6 = stackTraceElementArray[0].getMethodName();
            int n = stackTraceElementArray[0].getLineNumber();
            stringBuffer.append(string5).append(".");
            stringBuffer.append(string6).append("()");
            stringBuffer.append(":").append(n);
        }
        return stringBuffer.toString();
    }

    public static String formatInternalError(String string, String string2, Exception exception) {
        return SystemLogger.formatDetailedError(string, string2, exception, "INTERNAL ERROR");
    }

    class SystemLogFormatter
    extends Formatter {
        SystemLogFormatter() {
        }

        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(new Date().toString());
            stringBuffer.append("] - ");
            String string = logRecord.getLevel().getName();
            stringBuffer.append(string);
            stringBuffer.append(": ");
            for (int i = 0; i < 7 - string.length(); ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(logRecord.getMessage());
            Throwable throwable = logRecord.getThrown();
            if (throwable != null) {
                stringBuffer.append(", Cause: " + throwable.getMessage());
                if (SystemLogger.this._bDebug) {
                    stringBuffer.append("\nStacktrace {\n");
                    stringBuffer.append("\t").append(throwable).append("\n");
                    StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                    for (int i = 0; i < stackTraceElementArray.length; ++i) {
                        stringBuffer.append("\t\t at ").append(stackTraceElementArray[i]).append("\n");
                    }
                    stringBuffer.append("}\n");
                }
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

