/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.utils.Utils;

public abstract class ASelectHttpServlet
extends HttpServlet {
    private static final String MODULE = "ASelectHttpServlet";
    private boolean _bFirstInit = true;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Security.setProperty("networkaddress.cache.ttl", "60");
        if (this.isRestartableServlet()) {
            this.registerRestartableServlet(this.getModuleName());
        }
    }

    public void setDisableCachingHttpHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest.getProtocol().equalsIgnoreCase("HTTP/1.0")) {
            httpServletResponse.setHeader("Pragma", "no-cache");
        } else if (httpServletRequest.getProtocol().equalsIgnoreCase("HTTP/1.1")) {
            httpServletResponse.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        }
        httpServletResponse.setHeader("Expires", "-1");
    }

    public void showErrorPage(PrintWriter printWriter, String string, String string2, String string3) {
        String string4 = new String(string);
        string4 = Utils.replaceString(string4, "[error]", string2);
        string4 = Utils.replaceString(string4, "[error_message]", string3);
        printWriter.println(string4);
    }

    protected abstract boolean isRestartableServlet();

    protected boolean isReinit() {
        boolean bl = !this._bFirstInit;
        this._bFirstInit = false;
        return bl;
    }

    protected String getModuleName() {
        String string = ((Object)((Object)this)).getClass().getName();
        if ((string = string.substring(string.lastIndexOf(".") + 1)).endsWith("Servlet")) {
            string = string.toLowerCase().substring(0, string.length() - 7);
        }
        return string;
    }

    protected String getWorkingDir() {
        return this.getServletConfig().getInitParameter("working_dir");
    }

    protected String handleRestartRequest(HttpServletRequest httpServletRequest, String string, PrintWriter printWriter, SystemLogger systemLogger) {
        String string2 = "handleRestartRequest()";
        String string3 = httpServletRequest.getParameter("shared_secret");
        if (string3 == null) {
            if (systemLogger != null) {
                systemLogger.log(Level.WARNING, MODULE, string2, "parameter 'shared_secret' not found");
            } else {
                System.err.println("parameter 'shared_secret' not found");
            }
            return "0030";
        }
        if (!string3.equals(string)) {
            StringBuffer stringBuffer = new StringBuffer("Invalid 'shared_secret' received from ");
            stringBuffer.append(httpServletRequest.getRemoteAddr());
            if (systemLogger != null) {
                systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            } else {
                System.err.println(stringBuffer.toString());
            }
            return "0030";
        }
        String string4 = this.restartServlets(systemLogger) ? "0000" : "0001";
        printWriter.print("result_code=" + string4);
        return string4;
    }

    protected synchronized boolean restartServlets(SystemLogger systemLogger) {
        String string = "restartServlets()";
        StringBuffer stringBuffer = null;
        boolean bl = true;
        Hashtable hashtable = (Hashtable)this.getServletConfig().getServletContext().getAttribute("restartable_servlets");
        if (hashtable == null) {
            stringBuffer = new StringBuffer(this.getModuleName()).append(".").append(string).append("::").append("ERROR::\"Restart: no restartable servlets registered.\"");
            if (systemLogger != null) {
                systemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
            } else {
                System.err.println(stringBuffer.toString());
            }
            return false;
        }
        try {
            this.getServletConfig().getServletContext().setAttribute("restarting_servlets", (Object)"true");
            StringBuffer stringBuffer2 = new StringBuffer("Restart: ");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                ASelectHttpServlet aSelectHttpServlet = (ASelectHttpServlet)((Object)hashtable.get(string2));
                boolean bl2 = true;
                try {
                    aSelectHttpServlet.init(aSelectHttpServlet.getServletConfig());
                }
                catch (Exception exception) {
                    bl2 = false;
                }
                bl &= bl2;
                stringBuffer2.append(string2).append(" (");
                stringBuffer2.append(bl2 ? "OK" : "Failed");
                stringBuffer2.append(")");
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer2.append(", ");
            }
            if (systemLogger != null) {
                systemLogger.log(Level.INFO, MODULE, string, stringBuffer2.toString());
            } else {
                System.err.println(stringBuffer2.toString());
            }
        }
        catch (Exception exception) {
            if (systemLogger != null) {
                systemLogger.log(Level.SEVERE, this.getModuleName(), string, "Restarting servlets failed", exception);
            } else {
                System.err.println(this.getModuleName() + " " + string + exception.getMessage());
            }
            bl = false;
        }
        this.getServletConfig().getServletContext().removeAttribute("restarting_servlets");
        return bl;
    }

    protected boolean isRestartInProgress() {
        String string = (String)this.getServletConfig().getServletContext().getAttribute("restarting_servlets");
        return string != null && string.equals("true");
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isRestartInProgress()) {
            httpServletResponse.sendError(503);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    private void registerRestartableServlet(String string) {
        ServletConfig servletConfig = this.getServletConfig();
        Hashtable<String, ASelectHttpServlet> hashtable = (Hashtable<String, ASelectHttpServlet>)servletConfig.getServletContext().getAttribute("restartable_servlets");
        if (hashtable == null) {
            hashtable = new Hashtable<String, ASelectHttpServlet>();
        }
        hashtable.put(string, this);
        servletConfig.getServletContext().setAttribute("restartable_servlets", hashtable);
    }
}

