/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.admin;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.aselect.server.admin.SessionMonitorModel;
import org.aselect.server.admin.TGTMonitorModel;
import org.aselect.server.config.Version;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.tgt.TGTManager;

public class AdminMonitor
extends JFrame
implements TableModelListener {
    public static final String MODULE = "AdminMonitor";
    private JTable _oTGTsTable;
    private JLabel _oTGTsLabel = null;
    private TGTMonitorModel _oTGTsModel = null;
    private JScrollPane _oTGTsScrollPane = null;
    private JTable _oSessionsTable;
    private JLabel _oSessionsLabel = null;
    private JScrollPane _oSessionsScrollPane = null;
    private SessionMonitorModel _oSessionsModel = null;
    private JButton _oRevokeTGTButton = null;
    private JButton _oRevokeAllTGTsButton = null;
    private int _iButtonWidth = 130;
    private int _iButtonHeight = 24;
    private JButton _oLineButton1;
    private JButton _oLineButton2;
    private JButton _oLineButton3;
    private JLabel _oNumberOfTGTsLabel;
    private JLabel _oNumberOfSessionsLabel;
    private JLabel _oTotalSessionsLabel;
    private JLabel _oTotalTGTsLabel;
    private JLabel _oTimeLabel;
    private TGTManager _oTGTManager = TGTManager.getHandle();

    public AdminMonitor() throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        StringBuffer stringBuffer = new StringBuffer(Version.getVersion());
        stringBuffer.append(" Admin Monitor ");
        this.setTitle(stringBuffer.toString());
        this.setSize(800, 600);
        this.setLocation(1, 1);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new BasicWindowAdapter());
        this.getContentPane().setLayout(null);
        this._oTGTsTable = new JTable();
        this._oTGTsScrollPane = new JScrollPane(this._oTGTsTable);
        this.getContentPane().add(this._oTGTsScrollPane);
        this._oTGTsLabel = new JLabel("Issued TGT's");
        this.getContentPane().add(this._oTGTsLabel);
        this._oSessionsTable = new JTable();
        this._oSessionsScrollPane = new JScrollPane(this._oSessionsTable);
        this.getContentPane().add(this._oSessionsScrollPane);
        this._oSessionsLabel = new JLabel("Pending sessions");
        this.getContentPane().add(this._oSessionsLabel);
        this._oLineButton1 = new JButton();
        this._oLineButton1.setEnabled(false);
        this.getContentPane().add(this._oLineButton1);
        this._oLineButton2 = new JButton();
        this._oLineButton2.setEnabled(false);
        this.getContentPane().add(this._oLineButton2);
        this._oLineButton3 = new JButton();
        this._oLineButton3.setEnabled(false);
        this.getContentPane().add(this._oLineButton3);
        this._oNumberOfSessionsLabel = new JLabel("");
        this.getContentPane().add(this._oNumberOfSessionsLabel);
        this._oNumberOfTGTsLabel = new JLabel("");
        this.getContentPane().add(this._oNumberOfTGTsLabel);
        this._oTotalSessionsLabel = new JLabel("");
        this.getContentPane().add(this._oTotalSessionsLabel);
        this._oTotalTGTsLabel = new JLabel("");
        this.getContentPane().add(this._oTotalTGTsLabel);
        this._oTimeLabel = new JLabel("");
        this.getContentPane().add(this._oTimeLabel);
        this._oRevokeAllTGTsButton = new JButton("Kill All TGTs");
        this.getContentPane().add(this._oRevokeAllTGTsButton);
        this._oRevokeAllTGTsButton.addActionListener(new RevokeAllTGTsButtonListener());
        this._oRevokeTGTButton = new JButton("Kill TGT");
        this.getContentPane().add(this._oRevokeTGTButton);
        this._oRevokeTGTButton.addActionListener(new RevokeTGTButtonListener());
        this.getRootPane().setDefaultButton(this._oRevokeTGTButton);
    }

    public void start(int n) throws Exception {
        this._oTGTsModel = new TGTMonitorModel(n);
        this._oTGTsModel.addTableModelListener(this);
        this._oTGTsTable.setModel(this._oTGTsModel);
        this._oSessionsModel = new SessionMonitorModel(n);
        this._oSessionsModel.addTableModelListener(this);
        this._oSessionsTable.setModel(this._oSessionsModel);
        this._oTimeLabel.setText("Started at " + new Date().toString());
        this.repaint();
        this.setVisible(true);
        this.toFront();
        ASelectSystemLogger.getHandle().log(Level.INFO, MODULE, "start()", "Successfully initialized Admin monitor.");
    }

    public void stop() {
        if (this._oTGTsModel != null) {
            this._oTGTsModel.stop();
        }
        if (this._oSessionsModel != null) {
            this._oSessionsModel.stop();
        }
        this.setVisible(false);
        ASelectSystemLogger.getHandle().log(Level.INFO, MODULE, "stop()", "Admin monitor stopped");
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Number of pending sessions: ");
        stringBuffer.append(Integer.toString(this._oSessionsModel.getRowCount()));
        this._oNumberOfSessionsLabel.setText(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("Number of issued TGT's: ");
        stringBuffer.append(Integer.toString(this._oTGTsModel.getRowCount()));
        this._oNumberOfTGTsLabel.setText(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("Total sessions handled since startup: ");
        stringBuffer.append(this._oSessionsModel.getSessionsCounter());
        this._oTotalSessionsLabel.setText(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("Total TGT's issued since startup: ");
        stringBuffer.append(this._oTGTsModel.getTGTCounter());
        this._oTotalTGTsLabel.setText(stringBuffer.toString());
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getContentPane().getSize();
        int n = 4;
        int n2 = 16;
        int n3 = dimension.width - 8;
        this._oSessionsLabel.setBounds(n + 10, n2, n3, 20);
        this._oSessionsScrollPane.setBounds(n, n2 + 24, n3, 120);
        n2 = this._oSessionsScrollPane.getY() + this._oSessionsScrollPane.getHeight() + 20;
        this._oLineButton1.setBounds(n, n2, n3, 2);
        this._oTGTsLabel.setBounds(n + 10, n2 += 12, n3, 20);
        this._oTGTsScrollPane.setBounds(n, n2 + 24, n3, dimension.height - 400);
        n2 = this._oTGTsScrollPane.getY() + this._oTGTsScrollPane.getHeight() + 4;
        this._oRevokeTGTButton.setBounds((n3 - this._iButtonWidth) / 2, n2, this._iButtonWidth, this._iButtonHeight);
        n = 4;
        n2 = this._oRevokeTGTButton.getY() + this._oRevokeTGTButton.getHeight() + 20;
        this._oLineButton2.setBounds(n, n2, n3, 2);
        this._oLineButton3.setBounds(n3 - this._iButtonWidth - 20, n2, 2, dimension.height - n2);
        this._oRevokeAllTGTsButton.setBounds(n3 - this._iButtonWidth - 8, n2 += 30, this._iButtonWidth, this._iButtonHeight);
        n = 8;
        this._oNumberOfSessionsLabel.setBounds(n, n2 -= 20, this._oRevokeAllTGTsButton.getX() - 10, 20);
        this._oTotalSessionsLabel.setBounds(n, n2 += 24, this._oRevokeAllTGTsButton.getX() - 10, 20);
        this._oNumberOfTGTsLabel.setBounds(n, n2 += 24, this._oRevokeAllTGTsButton.getX() - 10, 20);
        this._oTotalTGTsLabel.setBounds(n, n2 += 24, this._oRevokeAllTGTsButton.getX() - 10, 20);
        this._oTimeLabel.setBounds(n, n2 += 24, this._oRevokeAllTGTsButton.getX() - 10, 20);
        super.paint(graphics);
    }

    class BasicWindowAdapter
    extends WindowAdapter {
        BasicWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == AdminMonitor.this) {
                // empty if block
            }
        }
    }

    class RevokeAllTGTsButtonListener
    implements ActionListener {
        RevokeAllTGTsButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AdminMonitor.this._oTGTManager.removeAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AdminMonitor.this.repaint();
        }
    }

    class RevokeTGTButtonListener
    implements ActionListener {
        RevokeTGTButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int[] nArray = AdminMonitor.this._oTGTsTable.getSelectedRows();
                if (nArray == null) {
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    AdminMonitor.this._oTGTManager.remove(AdminMonitor.this._oTGTsModel.getValueAt(nArray[i], AdminMonitor.this._oTGTsModel.getColumnCount()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            AdminMonitor.this.repaint();
        }
    }
}

