/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.admin;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.table.AbstractTableModel;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectStorageException;

public class SessionMonitorModel
extends AbstractTableModel
implements Runnable {
    public static final String MODULE = "SessionMonitorModel";
    private Thread _oRunnerThread;
    private String[] _saSessions;
    private String[] _saHeaders = new String[]{"User", "For Application", "Expires at", "AuthSP", "Type"};
    private int _iCheckInterval;
    private Hashtable _htSessionContexts;
    private SessionManager _oSessionManager = SessionManager.getHandle();
    private ASelectConfigManager _oConfigManager = ASelectConfigManager.getHandle();
    private boolean _bActive = false;

    public SessionMonitorModel(int n) {
        this._iCheckInterval = n;
        Integer n2 = null;
        try {
            Object object = this._oConfigManager.getSection(null, "storagemanager", "id=session");
            String string = this._oConfigManager.getParam(object, "max");
            n2 = Integer.valueOf(string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            ASelectSystemLogger.getHandle().log(Level.SEVERE, MODULE, "SessionMonitorModel()", "No valid 'max' config item in storage handler with id='session'", aSelectConfigException);
            n2 = Integer.valueOf("100");
        }
        this._saSessions = new String[n2.intValue()];
        this.getServerStatus();
        this._bActive = true;
        this._oRunnerThread = new Thread(this);
        this._oRunnerThread.start();
        this.fireTableDataChanged();
    }

    public void stop() {
        this._bActive = false;
        this._oRunnerThread.interrupt();
    }

    public long getSessionsCounter() {
        return this._oSessionManager.getCounter();
    }

    public int getRowCount() {
        return this._htSessionContexts.size();
    }

    public int getColumnCount() {
        return this._saHeaders.length;
    }

    public Object getValueAt(int n, int n2) {
        String string = this._saSessions[n];
        Hashtable hashtable = (Hashtable)this._htSessionContexts.get(string);
        if (n2 == 0) {
            String string2 = (String)hashtable.get("user_id");
            if (string2 == null) {
                return "[unknown]";
            }
            return string2;
        }
        if (n2 == 1) {
            String string3 = (String)hashtable.get("remote_session");
            String string4 = (String)hashtable.get("local_organization");
            if (string3 != null && string4 != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[unknown] at ");
                stringBuffer.append(string4);
                String string5 = stringBuffer.toString();
                return string5;
            }
            string3 = (String)hashtable.get("app_id");
            string4 = (String)hashtable.get("app_url");
            String string6 = string3 == null ? "[unknown] at " : string3;
            if (string4 == null) {
                StringBuffer stringBuffer = new StringBuffer(string6);
                stringBuffer.append("[unknown]");
                string6 = stringBuffer.toString();
            } else {
                StringBuffer stringBuffer = new StringBuffer(string6);
                stringBuffer.append(" (at ");
                stringBuffer.append(string4);
                stringBuffer.append(")");
                string6 = stringBuffer.toString();
            }
            return string6;
        }
        if (n2 == 2) {
            long l = 0L;
            try {
                l = this._oSessionManager.getExpirationTime(string);
                return new Date(l).toString();
            }
            catch (ASelectStorageException aSelectStorageException) {
                return "unknown";
            }
        }
        if (n2 == 3) {
            String string7 = (String)hashtable.get("authsp");
            if (string7 == null) {
                return "Not chosen yet";
            }
            return string7;
        }
        if (n2 == 4) {
            String string8 = (String)hashtable.get("remote_organization");
            if (string8 == null) {
                return "Local";
            }
            return "Cross (at " + string8 + ")";
        }
        if (n2 == 5) {
            return string;
        }
        return null;
    }

    public String getColumnName(int n) {
        return this._saHeaders[n];
    }

    public void run() {
        while (this._bActive) {
            try {
                Thread.sleep(this._iCheckInterval * 1000);
                this.getServerStatus();
                this.fireTableDataChanged();
            }
            catch (Exception exception) {}
        }
        ASelectSystemLogger.getHandle().log(Level.INFO, MODULE, "run()", "SessionMonitorModel stopped");
    }

    private void getServerStatus() {
        try {
            this._htSessionContexts = this._oSessionManager.getAll();
            int n = 0;
            Enumeration enumeration = this._htSessionContexts.keys();
            while (enumeration.hasMoreElements()) {
                this._saSessions[n++] = (String)enumeration.nextElement();
            }
        }
        catch (Exception exception) {
            ASelectSystemLogger.getHandle().log(Level.WARNING, MODULE, "getServerStatus()", "No session contexts available");
        }
    }
}

