/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.application.Application;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class ApplicationManager {
    private Hashtable _htApplications;
    private Hashtable _htSSOGroupedApplications;
    private static final String MODULE = "ApplicationManager";
    private static ApplicationManager _oApplicationManager;
    private ASelectConfigManager _oASelectConfigManager;
    private ASelectSystemLogger _systemLogger;
    private boolean _bRequireSigning;
    private String _sApplicationsKeystoreName = null;
    private boolean _bApplicationsConfigured = false;
    private Object _oApplicationsConfigSection = null;

    public static ApplicationManager getHandle() {
        if (_oApplicationManager == null) {
            _oApplicationManager = new ApplicationManager();
        }
        return _oApplicationManager;
    }

    public void init() throws ASelectException {
        String string = "init()";
        this._htApplications = new Hashtable();
        try {
            Object object;
            Object object2;
            this._oASelectConfigManager = ASelectConfigManager.getHandle();
            this._systemLogger = ASelectSystemLogger.getHandle();
            try {
                object2 = this._oASelectConfigManager.getSection(null, "applications");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'applications' section found in A-Select config", aSelectConfigException);
                return;
            }
            try {
                object = this._oASelectConfigManager.getParam(object2, "require_signing");
                this._bRequireSigning = new Boolean((String)object);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'require_signing' parameter found in section 'applications', using default value 'false'", aSelectConfigException);
            }
            if (this._bRequireSigning) {
                this._sApplicationsKeystoreName = this._oASelectConfigManager.getWorkingdir() + File.separator + "keystores" + File.separator + "applications" + File.separator + "applications.keystore";
            }
            object = null;
            try {
                object = this._oASelectConfigManager.getSection(object2, "application");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'application' section found in 'applications' section", aSelectConfigException);
                return;
            }
            while (object != null) {
                String string2;
                String string3 = null;
                Integer n = null;
                Integer n2 = null;
                boolean bl = false;
                String string4 = null;
                String string5 = null;
                boolean bl2 = false;
                boolean bl3 = false;
                Application application = new Application();
                String string6 = null;
                try {
                    string3 = this._oASelectConfigManager.getParam(object, "id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'id' parameter found in section 'application'", aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                try {
                    n = new Integer(this._oASelectConfigManager.getParam(object, "level"));
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'level' parameter found in section 'application'", aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                try {
                    n2 = new Integer(this._oASelectConfigManager.getParam(object, "max_level"));
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'max_level' parameter found in section 'application'", aSelectConfigException);
                }
                try {
                    string2 = this._oASelectConfigManager.getParam(object, "forced_authenticate");
                    bl = new Boolean(string2);
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'forced_authenticate' parameter found in section 'applications', set 'forced_authenticate' to default value 'false'", aSelectConfigException);
                }
                try {
                    string4 = this._oASelectConfigManager.getParam(object, "friendly_name");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'friendly_name' parameter found in section 'applications'", aSelectConfigException);
                }
                try {
                    string5 = this._oASelectConfigManager.getParam(object, "maintainer_email");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No optional 'maintainer_email' parameter found in section 'applications'", aSelectConfigException);
                }
                try {
                    string2 = this._oASelectConfigManager.getParam(object, "show_url");
                    bl2 = new Boolean(string2);
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No valid 'show_url' parameter found in section 'applications', set 'show_url' to default value 'false'", aSelectConfigException);
                }
                try {
                    string2 = this._oASelectConfigManager.getParam(object, "use_opaque_uid");
                    bl3 = new Boolean(string2);
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No valid 'use_opaque_uid' parameter found in section 'applications', set 'use_opaque_uid'to default value 'false'", aSelectConfigException);
                }
                try {
                    string6 = this._oASelectConfigManager.getParam(object, "attribute_policy");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No valid 'attribute_policy' parameter found in section 'applications', not using an attribute policy for application with id: '" + string3, aSelectConfigException);
                }
                application.setId(string3);
                application.setMinLevel(n);
                application.setMaxLevel(n2);
                application.setForcedAuthenticate(bl);
                application.setFriendlyName(string4);
                application.setMaintainerEmail(string5);
                application.setUseOpaqueUId(bl3);
                application.setShowUrl(bl2);
                application.setAttributePolicy(string6);
                if (this._bRequireSigning) {
                    application.setSigningKey(this.loadPublicKeyFromKeystore(string3));
                }
                this._htApplications.put(string3, application);
                object = this._oASelectConfigManager.getNextSection(object);
            }
            if (this._htApplications.size() >= 0) {
                this._bApplicationsConfigured = true;
            }
            this._htSSOGroupedApplications = this.resolveSSOGroups();
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Error during initializing", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public boolean hasApplicationsConfigured() {
        return this._bApplicationsConfigured;
    }

    public boolean isApplication(String string) {
        return this._htApplications.containsKey(string);
    }

    public boolean isSigningRequired() {
        return this._bRequireSigning;
    }

    public Integer getRequiredLevel(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.getMinLevel();
    }

    public Integer getMaxLevel(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.getMaxLevel();
    }

    public PublicKey getSigningKey(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.getSigningKey();
    }

    public boolean isForcedAuthenticateEnabled(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.isForcedAuthenticate();
    }

    public String getAttributePolicy(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.getAttributePolicy();
    }

    public String getFriendlyName(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.getFriendlyName();
    }

    public String getMaintainerEmail(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.getMaintainerEmail();
    }

    public boolean isUseOpaqueUid(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.isUseOpaqueUId();
    }

    public boolean isShowUrl(String string) throws ASelectException {
        Application application = this.getApplication(string);
        return application.isShowUrl();
    }

    public Vector getSSOGroups(String string) {
        Vector vector = null;
        if (this._htSSOGroupedApplications.containsKey(string)) {
            vector = (Vector)this._htSSOGroupedApplications.get(string);
        } else {
            vector = new Vector();
            vector.add(new String("0"));
        }
        return vector;
    }

    public boolean isValidSSOGroup(Vector vector, Vector vector2) {
        String string = "isValidSSOGroup";
        try {
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.get(i);
                if (!vector2.contains(string2)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not check if sso_groups: ");
            stringBuffer.append(vector2);
            stringBuffer.append(" contains in one of these sso_groups: ");
            stringBuffer.append(vector);
            this._systemLogger.log(Level.FINE, MODULE, string, stringBuffer.toString(), exception);
        }
        return false;
    }

    public String getParam(String string, String string2) {
        String string3 = null;
        String string4 = "getParam()";
        Object object = null;
        try {
            try {
                object = this._oASelectConfigManager.getSection(this._oApplicationsConfigSection, "application", "id=" + string);
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("No valid 'application' section found for '");
                stringBuffer.append(string).append("' in A-Select config");
                this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), aSelectConfigException);
                return null;
            }
            try {
                string3 = this._oASelectConfigManager.getParam(object, string2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                StringBuffer stringBuffer = new StringBuffer("No valid '");
                stringBuffer.append(string2).append("' found for '");
                stringBuffer.append(string).append("' in 'application' section");
                this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), aSelectConfigException);
                return null;
            }
            string3 = string3.trim();
            return string3;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string4, "Internal error", exception);
            return null;
        }
    }

    public String getOptionalParam(String string, String string2) throws ASelectException {
        String string3 = null;
        String string4 = "getOptionalParam()";
        Object object = null;
        try {
            object = this._oASelectConfigManager.getSection(this._oApplicationsConfigSection, "application", "id=" + string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            StringBuffer stringBuffer = new StringBuffer("No valid 'application' section found for '");
            stringBuffer.append(string).append("' in A-Select config");
            this._systemLogger.log(Level.WARNING, MODULE, string4, stringBuffer.toString(), aSelectConfigException);
            throw new ASelectException("4011");
        }
        try {
            string3 = this._oASelectConfigManager.getParam(object, string2);
        }
        catch (ASelectConfigException aSelectConfigException) {
            return null;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string4, "Internal error", exception);
            throw new ASelectException("0001");
        }
        string3 = string3.trim();
        return string3;
    }

    private Application getApplication(String string) throws ASelectException {
        String string2 = "getApplication()";
        Application application = (Application)this._htApplications.get(string);
        if (application == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No application found with Id: '" + string + "'.");
            throw new ASelectException("0031");
        }
        return application;
    }

    private Hashtable resolveSSOGroups() throws ASelectException {
        Hashtable<String, Serializable> hashtable;
        block18: {
            String string = "resolveSSOGroups()";
            hashtable = new Hashtable<String, Serializable>();
            try {
                Object object = null;
                try {
                    object = this._oASelectConfigManager.getSection(null, "sso_groups");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No valid 'sso_groups' config item found, disabling single sign-on groups.", aSelectConfigException);
                }
                if (object == null) break block18;
                Object object2 = null;
                try {
                    object2 = this._oASelectConfigManager.getSection(object, "sso_group");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Not even one valid 'sso_group' config section defined.", aSelectConfigException);
                    throw aSelectConfigException;
                }
                while (object2 != null) {
                    Serializable serializable;
                    String string2 = null;
                    try {
                        string2 = this._oASelectConfigManager.getParam(object2, "id");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'id' config item defined in 'sso_group' config item.", aSelectConfigException);
                        throw aSelectConfigException;
                    }
                    Object object3 = null;
                    try {
                        object3 = this._oASelectConfigManager.getSection(object2, "application");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        serializable = new StringBuffer("Not even one valid 'application' config section defined in 'sso_group' with id: ");
                        ((StringBuffer)serializable).append(string2);
                        this._systemLogger.log(Level.WARNING, MODULE, string, ((StringBuffer)serializable).toString(), aSelectConfigException);
                        throw aSelectConfigException;
                    }
                    while (object3 != null) {
                        String string3 = null;
                        try {
                            string3 = this._oASelectConfigManager.getParam(object3, "id");
                        }
                        catch (ASelectConfigException aSelectConfigException) {
                            StringBuffer stringBuffer = new StringBuffer("No valid 'id' config item defined in 'application' config section within the 'sso_group with id:'");
                            stringBuffer.append(string2);
                            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), aSelectConfigException);
                            throw aSelectConfigException;
                        }
                        serializable = null;
                        if (!hashtable.containsKey(string3)) {
                            serializable = new Vector();
                            ((Vector)serializable).add(string2);
                            hashtable.put(string3, serializable);
                        } else {
                            serializable = (Vector)hashtable.get(string3);
                            if (((Vector)serializable).contains(string2)) {
                                StringBuffer stringBuffer = new StringBuffer("'sso_group' with id='");
                                stringBuffer.append(string2);
                                stringBuffer.append("' isn't unique");
                                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
                                throw new ASelectException("0001");
                            }
                            ((Vector)serializable).add(string2);
                        }
                        hashtable.put(string3, serializable);
                        object3 = this._oASelectConfigManager.getNextSection(object3);
                    }
                    object2 = this._oASelectConfigManager.getNextSection(object2);
                }
            }
            catch (ASelectException aSelectException) {
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not load the ss_groups config", exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
        }
        return hashtable;
    }

    private PublicKey loadPublicKeyFromKeystore(String string) throws ASelectException {
        String string2 = "loadPublicKeyFromKeystore()";
        try {
            string = string.toLowerCase();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(this._sApplicationsKeystoreName), null);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            return x509Certificate.getPublicKey();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("could not load public key of application '");
            stringBuffer.append(string);
            stringBuffer.append("'");
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), exception);
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not load application public key.");
            throw new ASelectException("4005");
        }
    }
}

