/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.cross.selectorhandler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.config.Version;
import org.aselect.server.cross.ISelectorHandler;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class RegexSelectorHandler
implements ISelectorHandler {
    private static final String MODULE = "RegexSelectorHandler";
    private String _sCrossRegexSelectorPage;
    private String _sFriendlyName;
    private ASelectConfigManager _configManager;
    private ASelectSystemLogger _systemLogger;
    private Vector _vPatterns;
    private String _sMyServerId;
    private static final String ERROR_ASELECT_REGEX_SELECTOR_ORGANIZATION_UNKNOWN = "REGEX001";

    public void init(Object object) throws ASelectException {
        String string = "init()";
        try {
            Hashtable<String, Object> hashtable;
            this._systemLogger = ASelectSystemLogger.getHandle();
            this._configManager = ASelectConfigManager.getHandle();
            this._vPatterns = new Vector();
            Object object2 = null;
            Object object3 = null;
            try {
                hashtable = this._configManager.getSection(null, "aselect");
                this._sMyServerId = this._configManager.getParam(hashtable, "server_id");
                this._sFriendlyName = this._configManager.getParam(hashtable, "organization_friendly_name");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Failed to load basic A-Select configuration", aSelectConfigException);
                throw new ASelectConfigException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this.loadHTMLTemplates();
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Failed to load Regex Cross Selector HTML templates.", aSelectException);
                throw new ASelectConfigException("4009", (Throwable)aSelectException);
            }
            try {
                object2 = this._configManager.getSection(object, "expressions");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'expressions' found.", aSelectConfigException);
                throw new ASelectException("0001", (Throwable)aSelectConfigException);
            }
            try {
                object3 = this._configManager.getSection(object2, "regex");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'regex found' in 'expressions'", aSelectConfigException);
                throw new ASelectException("4011", (Throwable)aSelectConfigException);
            }
            while (object3 != null) {
                hashtable = new Hashtable<String, Object>();
                String string2 = null;
                String string3 = null;
                try {
                    string2 = this._configManager.getParam(object3, "value");
                    string3 = this._configManager.getParam(object3, "remote_organization");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'value' or 'remote_organization' found.", aSelectConfigException);
                    throw new ASelectException("4011", (Throwable)aSelectConfigException);
                }
                try {
                    Pattern pattern = Pattern.compile(string2);
                    hashtable.put("pattern", pattern);
                    hashtable.put("organization_id", string3);
                    this._vPatterns.add(hashtable);
                }
                catch (Exception exception) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Pattern '" + string2 + "' is not a valid regex", exception);
                    throw new ASelectConfigException("4011", (Throwable)exception);
                }
                object3 = this._configManager.getNextSection(object3);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize the regex selector handler", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public Hashtable getRemoteServerId(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        String string = "getRemoteServerId()";
        boolean bl = false;
        String string2 = null;
        Hashtable<String, String> hashtable2 = null;
        String string3 = (String)hashtable.get("user_id");
        if (string3 == null) {
            this.showAuthenticationForm(hashtable, printWriter, "");
            return null;
        }
        try {
            for (int i = 0; i < this._vPatterns.size() && !bl; ++i) {
                Hashtable hashtable3 = (Hashtable)this._vPatterns.get(i);
                Pattern pattern = (Pattern)hashtable3.get("pattern");
                Matcher matcher = pattern.matcher(string3);
                bl = matcher.matches();
                if (!bl) continue;
                hashtable2 = new Hashtable<String, String>();
                string2 = (String)hashtable3.get("organization_id");
                hashtable2.put("organization_id", string2);
                hashtable2.put("user_id", string3);
            }
            if (!bl) {
                this.showAuthenticationForm(hashtable, printWriter, ERROR_ASELECT_REGEX_SELECTOR_ORGANIZATION_UNKNOWN);
                this._systemLogger.log(Level.FINE, MODULE, string, "No organization found for user: " + string3);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "get remote server id failed. ", exception);
        }
        return hashtable2;
    }

    private void loadHTMLTemplates() throws ASelectException {
        String string = this._configManager.getWorkingdir() + File.separator + "conf" + File.separator + "html" + File.separator;
        this._sCrossRegexSelectorPage = this.loadHTMLTemplate(string + "regexselect.html");
        this._sCrossRegexSelectorPage = Utils.replaceString((String)this._sCrossRegexSelectorPage, (String)"[version]", (String)Version.getVersion());
        this._sCrossRegexSelectorPage = Utils.replaceString((String)this._sCrossRegexSelectorPage, (String)"[organization_friendly]", (String)this._sFriendlyName);
    }

    private String loadHTMLTemplate(String string) throws ASelectException {
        String string2 = new String();
        BufferedReader bufferedReader = null;
        String string3 = "loadHTMLTemplate()";
        try {
            String string4;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string4 = bufferedReader.readLine()) != null) {
                string2 = string2 + string4 + "\n";
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not load '");
            stringBuffer.append(string).append("'HTML template.");
            this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Could not close '");
                stringBuffer.append(string).append("' FileInputStream.");
                this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), exception);
            }
        }
        return string2;
    }

    private void showAuthenticationForm(Hashtable hashtable, PrintWriter printWriter, String string) throws ASelectException {
        String string2 = "showAuthenticationForm";
        try {
            String string3 = (String)hashtable.get("rid");
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "parameter 'rid' not found in service request");
                throw new ASelectException("0030");
            }
            String string4 = (String)hashtable.get("my_url");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "parameter 'my_url' not found in service request");
                throw new ASelectException("0030");
            }
            String string5 = this._sCrossRegexSelectorPage;
            string5 = Utils.replaceString((String)string5, (String)"[rid]", (String)string3);
            string5 = Utils.replaceString((String)string5, (String)"[aselect_url]", (String)string4);
            string5 = Utils.replaceString((String)string5, (String)"[request]", (String)"cross_login");
            string5 = Utils.replaceString((String)string5, (String)"[a-select-server]", (String)this._sMyServerId);
            string5 = Utils.replaceString((String)string5, (String)"[error_message]", (String)this._configManager.getErrorMessage(string));
            StringBuffer stringBuffer = new StringBuffer((String)hashtable.get("my_url")).append("?request=error").append("&result_code=").append("0040").append("&a-select-server=").append(this._sMyServerId).append("&rid=").append(string3);
            string5 = Utils.replaceString((String)string5, (String)"[cancel]", (String)stringBuffer.toString());
            string5 = Utils.replaceString((String)string5, (String)"[cross_request]", (String)"cross_login");
            Hashtable hashtable2 = SessionManager.getHandle().getSessionContext(string3);
            if (hashtable2 != null) {
                string5 = this._configManager.updateTemplate(string5, hashtable2);
            }
            printWriter.println(string5);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not show select form", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }
}

