/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.crypto;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMAgent;
import org.aselect.system.storagemanager.StorageManager;
import org.aselect.system.utils.BASE64Decoder;
import org.aselect.system.utils.BASE64Encoder;

public class CryptoEngine {
    private final String MODULE = "CryptoEngine";
    private final String DEFAULT_SIGNATURE_ALGORITHM = "SHA1withRSA";
    private final String DEFAULT_RANDOM_ALGORITHM = "SHA1PRNG";
    private final String DEFAULT_ENCRYPTION_ALGORITHM = "DESede";
    private static CryptoEngine _this;
    private Hashtable _htAuthspSettings;
    private ASelectConfigManager _configManager = ASelectConfigManager.getHandle();
    private ASelectSystemLogger _systemLogger;
    private PrivateKey _defaultPrivateKey;
    private boolean _bIsActive = false;
    private SecretKey _secretKey;
    private Cipher _cipher;
    private SecureRandom _secureRandom;
    private String _sSecureRandomAlgorithm = null;
    private Provider _oSecureRandomProvider = null;
    private String _sSignatureAlgorithm = null;
    private Provider _oSignatureProvider = null;
    private String _sCipherAlgorithm = null;
    private Provider _oCipherProvider = null;
    private StorageManager _storageManager = new StorageManager();

    private CryptoEngine() {
    }

    public static CryptoEngine getHandle() {
        if (_this == null) {
            _this = new CryptoEngine();
        }
        return _this;
    }

    public void init() throws ASelectException {
        String string = "init()";
        try {
            CharSequence charSequence;
            this._systemLogger = ASelectSystemLogger.getHandle();
            Object object = null;
            try {
                object = this._configManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, "CryptoEngine", string, "Could not find aselect config section in config file", aSelectConfigException);
                throw aSelectConfigException;
            }
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(object, "crypto");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "CryptoEngine", string, "Could not find crypto config section in config file", aSelectConfigException);
                throw aSelectConfigException;
            }
            Object object3 = null;
            try {
                object3 = this._configManager.getSection(object2, "providers");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "Could not find 'providers' config section in configuration. No providers specified", aSelectConfigException);
            }
            Object object4 = null;
            Hashtable<String, Provider> hashtable = new Hashtable<String, Provider>();
            if (object3 != null) {
                try {
                    object4 = this._configManager.getSection(object3, "provider");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "Could not find a 'provider' config section in config file. No providers specified", aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                while (object4 != null) {
                    String string2 = null;
                    try {
                        string2 = this._configManager.getParam(object4, "id");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "No valid 'id' config item found", aSelectConfigException);
                        throw new ASelectException("4009", (Throwable)aSelectConfigException);
                    }
                    charSequence = null;
                    try {
                        charSequence = this._configManager.getParam(object4, "class");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "No valid 'class' config item found", aSelectConfigException);
                        throw new ASelectException("4009", (Throwable)aSelectConfigException);
                    }
                    Provider provider = null;
                    try {
                        provider = (Provider)Class.forName((String)charSequence).newInstance();
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer = new StringBuffer("The configured provider is not a valid Provider class: ");
                        stringBuffer.append((String)charSequence);
                        this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, (String)charSequence, exception);
                        throw new ASelectException("4009", (Throwable)exception);
                    }
                    Security.addProvider(provider);
                    hashtable.put(string2, provider);
                    object4 = this._configManager.getNextSection(object4);
                }
            }
            this.readSignatureConfig(object2, hashtable);
            this.readEncryptionConfig(object2, hashtable);
            this._cipher = this._oCipherProvider != null ? Cipher.getInstance(this._sCipherAlgorithm, this._oCipherProvider) : Cipher.getInstance(this._sCipherAlgorithm);
            this.readRandomGeneratorConfig(object2, hashtable);
            try {
                this._secureRandom = this._oSecureRandomProvider != null ? SecureRandom.getInstance(this._sSecureRandomAlgorithm, this._oSecureRandomProvider) : SecureRandom.getInstance(this._sSecureRandomAlgorithm);
            }
            catch (Exception exception) {
                charSequence = new StringBuffer("Unable to create random generator with algorithm: ");
                ((StringBuffer)charSequence).append(this._sSecureRandomAlgorithm);
                this._systemLogger.log(Level.WARNING, "CryptoEngine", string, ((StringBuffer)charSequence).toString(), exception);
                throw new ASelectException("4009");
            }
            this._defaultPrivateKey = this._configManager.getDefaultPrivateKey();
            this._htAuthspSettings = this._configManager.getAuthspSettings();
            this._storageManager.init(this._configManager.getSection(null, "storagemanager", "id=crypto"), (ConfigManager)this._configManager, (SystemLogger)ASelectSystemLogger.getHandle(), (SAMAgent)ASelectSAMAgent.getHandle());
            try {
                this._secretKey = (SecretKey)this._storageManager.get((Object)"server-session-key");
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.INFO, "CryptoEngine", string, "Generating new A-Select Server key");
                this._secretKey = this._oCipherProvider != null ? KeyGenerator.getInstance(this._sCipherAlgorithm, this._oCipherProvider).generateKey() : KeyGenerator.getInstance(this._sCipherAlgorithm).generateKey();
                try {
                    this._storageManager.put((Object)"server-session-key", (Object)this._secretKey);
                }
                catch (ASelectStorageException aSelectStorageException) {
                    if (exception.getMessage().equals("6010")) {
                        this._systemLogger.log(Level.WARNING, "CryptoEngine", string, "Maximum server session keys reached", exception);
                    }
                    throw aSelectStorageException;
                }
            }
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, "CryptoEngine", string, "Could not initialize", aSelectException);
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "CryptoEngine", string, "Unable to initialize CryptoEngine", exception);
            throw new ASelectException("4009");
        }
    }

    public synchronized boolean verifyPrivilegedSignature(String string, String string2, String string3) {
        String string4 = "verifyPrivilegedSignature()";
        PublicKey publicKey = null;
        boolean bl = false;
        try {
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            string = string.toLowerCase();
            publicKey = this._configManager.getPrivilegedPublicKey(string);
            if (publicKey == null) {
                this._systemLogger.log(Level.FINE, "CryptoEngine", string4, "Could not find privileged public key with alias " + string);
                bl = false;
            } else {
                signature.initVerify(publicKey);
                signature.update(string2.getBytes());
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byte[] byArray = bASE64Decoder.decodeBuffer(string3);
                bl = signature.verify(byArray);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.FINE, "CryptoEngine", string4, "could not verify signature for alias: " + string, exception);
            bl = false;
        }
        return bl;
    }

    public synchronized boolean verifySignature(String string, String string2, String string3) {
        String string4 = "verifySignature()";
        PublicKey publicKey = null;
        int n = 0;
        boolean bl = false;
        try {
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            string = string.toLowerCase();
            while (!(bl || n != 0 && publicKey == null)) {
                publicKey = n == 0 ? (PublicKey)this._htAuthspSettings.get(string + ".public_key") : (PublicKey)this._htAuthspSettings.get(string + n + ".public_key");
                if (publicKey == null) {
                    this._systemLogger.log(Level.FINE, "CryptoEngine", string4, "could not find public key with alias " + string);
                    bl = false;
                    continue;
                }
                signature.initVerify(publicKey);
                signature.update(string2.getBytes());
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byte[] byArray = bASE64Decoder.decodeBuffer(string3);
                bl = signature.verify(byArray);
                ++n;
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.FINE, "CryptoEngine", string4, "could not verify signature for alias: " + string, exception);
            bl = false;
        }
        return bl;
    }

    public synchronized boolean verifyCrossASelectSignature(PublicKey publicKey, String string, String string2) {
        String string3 = "verifyCrossASelectSignature()";
        boolean bl = false;
        try {
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            signature.initVerify(publicKey);
            signature.update(string.getBytes());
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string2);
            bl = signature.verify(byArray);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.FINE, "CryptoEngine", string3, "could not verify A-Select Server signature.", exception);
            bl = false;
        }
        return bl;
    }

    public boolean verifyApplicationSignature(PublicKey publicKey, String string, String string2) {
        String string3 = "verifyApplicationSignature()";
        boolean bl = false;
        try {
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            signature.initVerify(publicKey);
            signature.update(string.getBytes());
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string2);
            bl = signature.verify(byArray);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.FINE, "CryptoEngine", string3, "Could not verify application signature", exception);
            bl = false;
        }
        return bl;
    }

    public synchronized String generateSignature(String string, String string2) {
        String string3 = "CryptoEngine.generateSignature()";
        try {
            PrivateKey privateKey = null;
            if (string != null) {
                string = string.toLowerCase();
                privateKey = (PrivateKey)this._htAuthspSettings.get(string + ".specific_private_key");
            }
            if (privateKey == null) {
                privateKey = this._defaultPrivateKey;
            }
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            signature.initSign(privateKey);
            signature.update(string2.getBytes());
            byte[] byArray = signature.sign();
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            return bASE64Encoder.encode(byArray);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, "CryptoEngine", string3, "could not compute signature", exception);
            return null;
        }
    }

    public synchronized String encryptTGT(byte[] byArray) throws ASelectException {
        String string = "encryptTGT()";
        try {
            this._cipher.init(1, this._secretKey);
            byte[] byArray2 = this._cipher.doFinal(byArray);
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            String string2 = bASE64Encoder.encode(byArray2);
            return string2.replace('+', '-').replace('=', '_');
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, "CryptoEngine", string, "could not encrypt", exception);
            throw new ASelectException("0001");
        }
    }

    public synchronized byte[] decryptTGT(String string) throws ASelectException {
        String string2 = "decryptTGT()";
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string.replace('_', '=').replace('-', '+'));
            this._cipher.init(2, this._secretKey);
            return this._cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, "CryptoEngine", string2, "could not decrypt", exception);
            throw new ASelectException("0001");
        }
    }

    public String getAuthSPSpecificCertId(String string) {
        String string2 = (String)this._htAuthspSettings.get((string = string.toLowerCase()) + ".specific_private_key.cert_id");
        if (string2 == null) {
            return this._configManager.getDefaultCertId();
        }
        return string2;
    }

    public void stop() {
        if (this._bIsActive) {
            this._bIsActive = false;
            this._storageManager.destroy();
            this._storageManager = null;
        }
    }

    public static void nextRandomBytes(byte[] byArray) throws Exception {
        CryptoEngine.getHandle()._secureRandom.nextBytes(byArray);
    }

    private void readSignatureConfig(Object object, Hashtable hashtable) throws ASelectException {
        String string = "readSignatureConfig()";
        String string2 = null;
        Object object2 = null;
        try {
            object2 = this._configManager.getSection(object, "signature_algorithm");
        }
        catch (ASelectConfigException aSelectConfigException) {
            object2 = null;
            this._sSignatureAlgorithm = "SHA1withRSA";
            this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "Could not retrieve 'signature_algorithm' config section in crypto config section. Using default algorithm and provider.", aSelectConfigException);
        }
        if (object2 != null) {
            try {
                this._sSignatureAlgorithm = this._configManager.getParam(object2, "algorithm");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sSignatureAlgorithm = "SHA1withRSA";
                StringBuffer stringBuffer = new StringBuffer("Could not retrieve 'algorithm' config parameter in crypto config section. Using default algorithm: ");
                stringBuffer.append(this._sSignatureAlgorithm);
                this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, stringBuffer.toString());
            }
        }
        if (object2 != null) {
            try {
                string2 = this._configManager.getParam(object2, "provider");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string2 = null;
                this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "Could not retrieve 'provider' config section in crypto config section. Using default provider.", aSelectConfigException);
            }
            if (string2 != null) {
                StringBuffer stringBuffer;
                if (!hashtable.containsKey(string2)) {
                    stringBuffer = new StringBuffer("Unknown 'provider': ");
                    stringBuffer.append(string2);
                    this._systemLogger.log(Level.SEVERE, "CryptoEngine", string, stringBuffer.toString());
                    throw new ASelectException("4009");
                }
                this._oSignatureProvider = (Provider)hashtable.get(string2);
                stringBuffer = new StringBuffer("Using provider '");
                stringBuffer.append(string2);
                stringBuffer.append("' for signature generation");
                this._systemLogger.log(Level.INFO, "CryptoEngine", string, stringBuffer.toString());
            }
        }
    }

    private void readEncryptionConfig(Object object, Hashtable hashtable) throws ASelectException {
        String string = "readEncryptionConfig()";
        String string2 = null;
        Object object2 = null;
        try {
            object2 = this._configManager.getSection(object, "encryption_algorithm");
        }
        catch (ASelectConfigException aSelectConfigException) {
            object2 = null;
            this._sCipherAlgorithm = "DESede";
            this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "Could not retrieve 'encryption_algorithm' config section in crypto config section. Using default algorithm and provider.", aSelectConfigException);
        }
        if (object2 != null) {
            try {
                this._sCipherAlgorithm = this._configManager.getParam(object2, "algorithm");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sCipherAlgorithm = "DESede";
                StringBuffer stringBuffer = new StringBuffer("Could not retrieve 'encryption_algorithm' config parameter in crypto config section. Using default algorithm: ");
                stringBuffer.append(this._sCipherAlgorithm);
                this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, stringBuffer.toString());
            }
        }
        if (object2 != null) {
            try {
                string2 = this._configManager.getParam(object2, "provider");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string2 = null;
                this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "Could not retrieve 'provider' config parameter in crypto config section. Using default provider.", aSelectConfigException);
            }
            if (string2 != null) {
                StringBuffer stringBuffer;
                if (!hashtable.containsKey(string2)) {
                    stringBuffer = new StringBuffer("Unknown 'provider': ");
                    stringBuffer.append(string2);
                    this._systemLogger.log(Level.SEVERE, "CryptoEngine", string, stringBuffer.toString());
                    throw new ASelectException("4009");
                }
                this._oCipherProvider = (Provider)hashtable.get(string2);
                stringBuffer = new StringBuffer("Using provider '");
                stringBuffer.append(string2);
                stringBuffer.append("' for encryption");
                this._systemLogger.log(Level.INFO, "CryptoEngine", string, stringBuffer.toString());
            }
        }
    }

    private void readRandomGeneratorConfig(Object object, Hashtable hashtable) throws ASelectException {
        String string = "readRandomGeneratorConfig()";
        String string2 = null;
        Object object2 = null;
        try {
            object2 = this._configManager.getSection(object, "random_generator_algorithm");
        }
        catch (ASelectConfigException aSelectConfigException) {
            object2 = null;
            this._sSecureRandomAlgorithm = "SHA1PRNG";
            this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "Could not retrieve 'random_generator_algorithm' config section in crypto config section. Using default algorithm and provider.", aSelectConfigException);
        }
        if (object2 != null) {
            try {
                this._sSecureRandomAlgorithm = this._configManager.getParam(object2, "algorithm");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sSecureRandomAlgorithm = "SHA1PRNG";
                StringBuffer stringBuffer = new StringBuffer("Could not retrieve 'random_generator_algorithm' config parameter in crypto config section. Using default algorithm: ");
                stringBuffer.append(this._sSecureRandomAlgorithm);
                this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, stringBuffer.toString());
            }
        }
        if (object2 != null) {
            try {
                string2 = this._configManager.getParam(object2, "provider");
            }
            catch (ASelectConfigException aSelectConfigException) {
                string2 = null;
                this._systemLogger.log(Level.CONFIG, "CryptoEngine", string, "Could not retrieve 'provider' config parameter in crypto config section. Using default provider.", aSelectConfigException);
            }
            if (string2 != null) {
                StringBuffer stringBuffer;
                if (!hashtable.containsKey(string2)) {
                    stringBuffer = new StringBuffer("Unknown 'provider': ");
                    stringBuffer.append(string2);
                    this._systemLogger.log(Level.SEVERE, "CryptoEngine", string, stringBuffer.toString());
                    throw new ASelectException("4009");
                }
                this._oSecureRandomProvider = (Provider)hashtable.get(string2);
                stringBuffer = new StringBuffer("Using provider '");
                stringBuffer.append(string2);
                stringBuffer.append("' for the random generator.");
                this._systemLogger.log(Level.INFO, "CryptoEngine", string, stringBuffer.toString());
            }
        }
    }

    public void signRequest(Hashtable hashtable) throws ASelectException {
        try {
            String string;
            Signature signature = null;
            signature = this._oSignatureProvider != null ? Signature.getInstance(this._sSignatureAlgorithm, this._oSignatureProvider) : Signature.getInstance(this._sSignatureAlgorithm);
            StringBuffer stringBuffer = new StringBuffer();
            TreeSet treeSet = new TreeSet(hashtable.keySet());
            Object object = treeSet.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                if (string.equals("request")) continue;
                stringBuffer.append(hashtable.get(string));
            }
            signature.initSign(this._configManager.getDefaultPrivateKey());
            signature.update(stringBuffer.toString().getBytes());
            object = signature.sign();
            string = new BASE64Encoder();
            String string2 = string.encode((byte[])object);
            hashtable.put("signature", string2);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "CryptoEngine", "signRequest()", "Could not sign request", exception);
            throw new ASelectException("0001");
        }
    }
}

