/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.IRequestHandler;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class RequestHandlerFactory {
    private static final String MODULE = "RequestHandlerFactory";
    private static RequestHandlerFactory _oRequestHandlerFactory;
    private ASelectSystemLogger _systemLogger;
    private ASelectConfigManager _configManager;
    private Hashtable _htRequestHandlers;
    private Vector _vRequestHandlers;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            this._systemLogger = ASelectSystemLogger.getHandle();
            this._configManager = ASelectConfigManager.getHandle();
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(object, "handlers");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "No config section 'handlers' found", aSelectConfigException);
                throw aSelectConfigException;
            }
            Object object3 = null;
            try {
                object3 = this._configManager.getSection(object2, "handler");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "No config item 'handler' in section 'handlers' found", aSelectConfigException);
                throw aSelectConfigException;
            }
            this._htRequestHandlers = new Hashtable();
            this._vRequestHandlers = new Vector();
            while (object3 != null) {
                String string2 = null;
                try {
                    string2 = this._configManager.getParam(object3, "class");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, "No config item 'class' in section 'handler' found", aSelectConfigException);
                    throw aSelectConfigException;
                }
                Class<?> clazz = null;
                IRequestHandler iRequestHandler = null;
                try {
                    clazz = Class.forName(string2);
                    iRequestHandler = (IRequestHandler)clazz.newInstance();
                }
                catch (Exception exception) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Not a correct 'IRequestHandler' class: " + string2, exception);
                    throw new ASelectException("4009", (Throwable)exception);
                }
                try {
                    iRequestHandler.init(servletConfig, object3);
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Could not initialize IRequestHandler Object from class: " + string2);
                    throw aSelectException;
                }
                if (this._htRequestHandlers.containsKey(iRequestHandler.getID())) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Request handler id is not unique: " + iRequestHandler.getID());
                    throw new ASelectException("4009");
                }
                this._htRequestHandlers.put(iRequestHandler.getID(), iRequestHandler);
                this._vRequestHandlers.add(iRequestHandler);
                this._systemLogger.log(Level.INFO, MODULE, string, "Successfully started request handler with ID: " + iRequestHandler.getID());
                object3 = this._configManager.getNextSection(object3);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize: " + exception.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        boolean bl = false;
        IRequestHandler iRequestHandler = null;
        RequestState requestState = null;
        try {
            Enumeration enumeration = this._vRequestHandlers.elements();
            while (enumeration.hasMoreElements() && !bl) {
                iRequestHandler = (IRequestHandler)enumeration.nextElement();
                bl = this.matchTarget(httpServletRequest, iRequestHandler.getPattern());
            }
            if (bl && iRequestHandler != null) {
                requestState = iRequestHandler.process(httpServletRequest, httpServletResponse);
            }
            while (requestState != null && requestState.hasNextHandler()) {
                iRequestHandler = (IRequestHandler)this._htRequestHandlers.get(requestState.getNextHandler());
                if (iRequestHandler != null) {
                    requestState = iRequestHandler.process(httpServletRequest, httpServletResponse);
                    continue;
                }
                requestState = null;
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process: " + exception.toString(), exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public static RequestHandlerFactory getHandle() {
        if (_oRequestHandlerFactory == null) {
            _oRequestHandlerFactory = new RequestHandlerFactory();
        }
        return _oRequestHandlerFactory;
    }

    public void destroy() {
        if (this._vRequestHandlers != null) {
            this._vRequestHandlers.clear();
        }
        Enumeration enumeration = this._htRequestHandlers.elements();
        while (enumeration.hasMoreElements()) {
            IRequestHandler iRequestHandler = (IRequestHandler)enumeration.nextElement();
            iRequestHandler.destroy();
        }
    }

    private RequestHandlerFactory() {
    }

    private boolean matchTarget(HttpServletRequest httpServletRequest, Pattern pattern) throws ASelectException {
        String string = "matchTarget()";
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2 = httpServletRequest.getContextPath();
            String string3 = httpServletRequest.getServletPath();
            String string4 = httpServletRequest.getQueryString();
            String string5 = httpServletRequest.getRequestURI();
            String string6 = string5.substring(string2.length() + string3.length());
            stringBuffer.append(string6);
            if (string4 != null) {
                stringBuffer.append('?');
                stringBuffer.append(string4);
            }
            Matcher matcher = pattern.matcher(stringBuffer.toString());
            bl = matcher.matches();
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not match pattern", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return bl;
    }

    public Vector getRequestHandlers() {
        return this._vRequestHandlers;
    }
}

