/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.sam;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.config.Version;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.service.SAMServiceServlet;

public class SAMService
extends SAMServiceServlet {
    public static final String MODULE = "SAMService";
    private ASelectSystemLogger _systemLogger;
    private boolean _bASelectOK;

    public void init(ServletConfig servletConfig) throws ServletException {
        this._systemLogger = ASelectSystemLogger.getHandle();
        super.init(servletConfig);
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.1", "a-select.statistics.specific.maxsessions");
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.2", "a-select.statistics.specific.cursessions");
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.3", "a-select.statistics.specific.sessionload");
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.4", "a-select.statistics.specific.authsps");
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.5", "a-select.statistics.specific.processingTime");
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.6", "a-select.statistics.specific.sessionCount");
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.7", "a-select.statistics.specific.TGTCount");
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.8", "a-select.statistics.specific.curTGTs");
        this._htOIDs.put("1.3.6.1.4.1.15396.10.10.2.2.1.9", "a-select.statistics.specific.maxTGTs");
        this._bASelectOK = true;
        this._systemLogger.log(Level.INFO, MODULE, "init()", "Successfully started SAM Service.");
    }

    public void destroy() {
        super.destroy();
    }

    protected SystemLogger getSystemLogger() {
        return this._systemLogger;
    }

    protected Hashtable getSAMInfo() {
        String string = "getSAMInfo()";
        Hashtable hashtable = this.getCommonSAMInfo();
        long l = 0L;
        long l2 = 0L;
        this._bASelectOK = true;
        ASelectConfigManager aSelectConfigManager = ASelectConfigManager.getHandle();
        if (aSelectConfigManager != null) {
            Object object;
            try {
                object = aSelectConfigManager.getSection(null, "storagemanager", "id=session");
                l = new Long(aSelectConfigManager.getParam(object, "max"));
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Can't find 'max' config item in storagemanager section with id='sessions'", aSelectConfigException);
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Can't convert value of 'max' config item in storagemanager with id='sessions' to a long value.");
            }
            catch (NullPointerException nullPointerException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Can't retrieve value of 'max' config item in storagemanager with id='sessions'.");
                this._bASelectOK = false;
            }
            try {
                object = aSelectConfigManager.getSection(null, "storagemanager", "id=tgt");
                l2 = new Long(aSelectConfigManager.getParam(object, "max"));
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Can't find 'max' config item in storagemanager section with id='tgt'", aSelectConfigException);
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Can't convert value of 'max' config item in storagemanager with id='tgt' to a long value.");
            }
            catch (NullPointerException nullPointerException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Can't retrieve value of 'max' config item in storagemanager with id='tgt'.");
                this._bASelectOK = false;
            }
        }
        long l3 = -1L;
        SessionManager sessionManager = SessionManager.getHandle();
        if (sessionManager != null) {
            try {
                l3 = sessionManager.getCount();
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No contexts available", exception);
            }
        }
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.1", "" + l);
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.2", "" + l3);
        double d = l3 >= 0L ? (double)l3 * (100.0 / (double)l) : -1.0;
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.3", "" + (int)d);
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.4", this.resolveAuthSPs());
        long l4 = -1L;
        if (sessionManager != null) {
            l4 = sessionManager.getProcessingTime();
        }
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.5", "" + l4);
        long l5 = -1L;
        sessionManager = SessionManager.getHandle();
        if (sessionManager != null) {
            l5 = sessionManager.getCounter();
        }
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.6", "" + l5);
        long l6 = -1L;
        TGTManager tGTManager = TGTManager.getHandle();
        if (tGTManager != null) {
            l6 = tGTManager.getTGTCounter();
        }
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.7", "" + l6);
        long l7 = -1L;
        tGTManager = TGTManager.getHandle();
        if (tGTManager != null) {
            try {
                l7 = tGTManager.getCount();
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No contexts available", exception);
            }
        }
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.8", "" + l7);
        hashtable.put("1.3.6.1.4.1.15396.10.10.2.2.1.9", "" + l2);
        return hashtable;
    }

    protected int operational() {
        if (!this._bASelectOK) {
            return 0;
        }
        ServletContext servletContext = this.getServletContext().getContext(super.getContextUrl() + "/server");
        if (servletContext != null) {
            return 1;
        }
        return 0;
    }

    protected String getSysDescr() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("A-Select Server v");
        stringBuffer.append(Version.getRelease());
        String string2 = Version.getSP();
        if (!string2.equals("")) {
            stringBuffer.append(" ,SP ");
            stringBuffer.append(string2);
        }
        if (!(string = Version.getPatch()).equals("")) {
            stringBuffer.append(" ,Patch ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected String getVersion() {
        return Version.getRelease();
    }

    private String resolveAuthSPs() {
        String string = "";
        StringBuffer stringBuffer = null;
        try {
            ASelectConfigManager aSelectConfigManager = ASelectConfigManager.getHandle();
            Object object = aSelectConfigManager.getSection(null, "authsps");
            Object object2 = aSelectConfigManager.getSection(object, "authsp");
            while (object2 != null) {
                String string2 = aSelectConfigManager.getParam(object2, "id");
                String string3 = aSelectConfigManager.getParam(object2, "level");
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string2);
                stringBuffer.append(" (level=");
                stringBuffer.append(string3);
                stringBuffer.append(")");
                object2 = aSelectConfigManager.getNextSection(object2);
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.FINE, MODULE, "resolveAuthSPs()", "No AuthSP information available", exception);
            string = "&nbsp;";
        }
        return string;
    }
}

