/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.tgt;

import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMAgent;
import org.aselect.system.storagemanager.StorageManager;
import org.aselect.system.utils.Utils;

public class TGTManager
extends StorageManager {
    private static final String MODULE = "TGTManager";
    private static final int TGT_LENGTH = 256;
    private static TGTManager _oTGTManager;
    private ASelectSystemLogger _systemLogger;
    private long _lTGTCounter;

    public static TGTManager getHandle() {
        if (_oTGTManager == null) {
            _oTGTManager = new TGTManager();
        }
        return _oTGTManager;
    }

    public void init() throws ASelectException {
        String string = "init()";
        ASelectConfigManager aSelectConfigManager = null;
        Object object = null;
        try {
            this._systemLogger = ASelectSystemLogger.getHandle();
            aSelectConfigManager = ASelectConfigManager.getHandle();
            try {
                object = aSelectConfigManager.getSection(null, "storagemanager", "id=tgt");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'storagemanager' config section found with id='tgt'", aSelectConfigException);
                throw aSelectConfigException;
            }
            super.init(object, (ConfigManager)aSelectConfigManager, (SystemLogger)this._systemLogger, (SAMAgent)ASelectSAMAgent.getHandle());
            this._lTGTCounter = 0L;
            this._systemLogger.log(Level.INFO, MODULE, string, "Successfully initialized TGT Manager");
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Error initializing the TGT storage", aSelectStorageException);
            throw aSelectStorageException;
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal error while initializing TGT Manager", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public synchronized String createTGT(Hashtable hashtable) throws ASelectException {
        String string = "createTGT()";
        String string2 = null;
        String string3 = null;
        try {
            byte[] byArray = new byte[256];
            CryptoEngine.nextRandomBytes(byArray);
            string3 = Utils.toHexString((byte[])byArray);
            while (this.containsKey(string3)) {
                CryptoEngine.nextRandomBytes(byArray);
                string3 = Utils.toHexString((byte[])byArray);
            }
            this.put(string3, hashtable);
            ++this._lTGTCounter;
            string2 = string3;
        }
        catch (ASelectStorageException aSelectStorageException) {
            if (aSelectStorageException.getMessage().equals("6010")) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Maximum number of TGTs reached", aSelectStorageException);
                throw new ASelectException("0050", (Throwable)aSelectStorageException);
            }
            this._systemLogger.log(Level.WARNING, MODULE, string, "Could not store TGT", aSelectStorageException);
            throw aSelectStorageException;
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Internal error while creating TGT", exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return string2;
    }

    public boolean updateTGT(String string, Hashtable hashtable) {
        boolean bl = false;
        if (this.getTGT(string) != null) {
            try {
                this.update(string, hashtable);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
                StringBuffer stringBuffer = new StringBuffer("Could not update context of TGT: ");
                stringBuffer.append(string);
                this._systemLogger.log(Level.WARNING, MODULE, "updateTGT()", stringBuffer.toString(), exception);
            }
        }
        return bl;
    }

    public Hashtable getTGT(String string) {
        String string2 = "getTGT()";
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)this.get(string);
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No TGT context found with id: " + string, aSelectStorageException);
        }
        return hashtable;
    }

    public long getTGTCounter() {
        return this._lTGTCounter;
    }

    private TGTManager() {
    }
}

